/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client.http;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.searchbox.Action;
import io.searchbox.client.AbstractJestClient;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.client.JestResultHandler;
import io.searchbox.client.http.apache.HttpDeleteWithEntity;
import io.searchbox.client.http.apache.HttpGetWithEntity;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.StringEntity;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.reactor.IOReactorStatus;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JestHttpClient
extends AbstractJestClient
implements JestClient {
    static final Logger log = LoggerFactory.getLogger(JestHttpClient.class);
    private HttpClient httpClient;
    private HttpAsyncClient asyncClient;
    private Charset entityEncoding = Charset.forName("utf-8");
    private Gson gson = new Gson();

    @Override
    public JestResult execute(Action clientRequest) throws IOException {
        String elasticSearchRestUrl = this.getRequestURL(this.getElasticSearchServer(), clientRequest.getURI());
        HttpUriRequest request = this.constructHttpMethod(clientRequest.getRestMethodName(), elasticSearchRestUrl, clientRequest.getData());
        if (!clientRequest.getHeaders().isEmpty()) {
            for (Map.Entry<String, Object> header : clientRequest.getHeaders().entrySet()) {
                request.addHeader(header.getKey(), header.getValue().toString());
            }
        }
        HttpResponse response = this.httpClient.execute(request);
        if (request.getMethod().equalsIgnoreCase("HEAD") && response.getEntity() == null) {
            if (response.getStatusLine().getStatusCode() == 200) {
                response.setEntity((HttpEntity)new StringEntity("{\"ok\" : true, \"found\" : true}"));
            } else if (response.getStatusLine().getStatusCode() == 404) {
                response.setEntity((HttpEntity)new StringEntity("{\"ok\" : false, \"found\" : false}"));
            }
        }
        return this.deserializeResponse(response, clientRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAsync(final Action clientRequest, final JestResultHandler<JestResult> resultHandler) throws ExecutionException, InterruptedException, IOException {
        JestHttpClient jestHttpClient = this;
        synchronized (jestHttpClient) {
            if (this.asyncClient.getStatus() == IOReactorStatus.INACTIVE) {
                this.asyncClient.start();
            }
        }
        String elasticSearchRestUrl = this.getRequestURL(this.getElasticSearchServer(), clientRequest.getURI());
        HttpUriRequest request = this.constructHttpMethod(clientRequest.getRestMethodName(), elasticSearchRestUrl, clientRequest.getData());
        if (!clientRequest.getHeaders().isEmpty()) {
            for (Map.Entry<String, Object> header : clientRequest.getHeaders().entrySet()) {
                request.addHeader(header.getKey(), header.getValue() + "");
            }
        }
        this.asyncClient.execute(request, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse response) {
                try {
                    JestResult jestResult = JestHttpClient.this.deserializeResponse(response, clientRequest);
                    resultHandler.completed(jestResult);
                }
                catch (IOException e) {
                    log.error("Exception occurred while serializing the response. Exception: " + e.getMessage());
                }
            }

            public void failed(Exception ex) {
                resultHandler.failed(ex);
            }

            public void cancelled() {
            }
        });
    }

    @Override
    public void shutdownClient() {
        super.shutdownClient();
        try {
            this.asyncClient.shutdown();
        }
        catch (Exception ex) {
            log.error("Exception occurred while shutting down the asynClient. Exception: " + ex.getMessage());
        }
    }

    protected HttpUriRequest constructHttpMethod(String methodName, String url, Object data) throws UnsupportedEncodingException {
        Object httpUriRequest = null;
        if (methodName.equalsIgnoreCase("POST")) {
            httpUriRequest = new HttpPost(url);
            log.debug("POST method created based on client request");
        } else if (methodName.equalsIgnoreCase("PUT")) {
            httpUriRequest = new HttpPut(url);
            log.debug("PUT method created based on client request");
        } else if (methodName.equalsIgnoreCase("DELETE")) {
            httpUriRequest = new HttpDeleteWithEntity(url);
            log.debug("DELETE method created based on client request");
        } else if (methodName.equalsIgnoreCase("GET")) {
            httpUriRequest = new HttpGetWithEntity(url);
            log.debug("GET method created based on client request");
        } else if (methodName.equalsIgnoreCase("HEAD")) {
            httpUriRequest = new HttpHead(url);
            log.debug("HEAD method created based on client request");
        }
        if (httpUriRequest != null && httpUriRequest instanceof HttpEntityEnclosingRequestBase && data != null) {
            ((HttpEntityEnclosingRequestBase)httpUriRequest).setEntity((HttpEntity)new StringEntity(this.createJsonStringEntity(data), this.entityEncoding));
        }
        return httpUriRequest;
    }

    private String createJsonStringEntity(Object data) {
        String entity = data instanceof String && this.isJson(data.toString()) ? data.toString() : this.gson.toJson(data);
        return entity;
    }

    private boolean isJson(String data) {
        try {
            JsonElement result = new JsonParser().parse(data);
            return !result.isJsonNull();
        }
        catch (JsonSyntaxException e) {
            String[] bulkRequest = data.split("\n");
            return bulkRequest.length >= 1;
        }
    }

    private JestResult deserializeResponse(HttpResponse response, Action clientRequest) throws IOException {
        return this.createNewElasticSearchResult(response.getEntity() != null ? EntityUtils.toString((HttpEntity)response.getEntity()) : null, response.getStatusLine(), clientRequest);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public HttpAsyncClient getAsyncClient() {
        return this.asyncClient;
    }

    public void setAsyncClient(HttpAsyncClient asyncClient) {
        this.asyncClient = asyncClient;
    }

    public Charset getEntityEncoding() {
        return this.entityEncoding;
    }

    public void setEntityEncoding(Charset entityEncoding) {
        this.entityEncoding = entityEncoding;
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }
}

