/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.lease;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.time.Duration;
import reactor.util.annotation.Nullable;

public final class Lease {
    final int timeToLiveMillis;
    final int numberOfRequests;
    final ByteBuf metadata;
    final long expirationTime;

    public static Lease create(Duration timeToLive, int numberOfRequests, @Nullable ByteBuf metadata) {
        return new Lease(timeToLive, numberOfRequests, metadata);
    }

    public static Lease create(Duration timeToLive, int numberOfRequests) {
        return Lease.create(timeToLive, numberOfRequests, Unpooled.EMPTY_BUFFER);
    }

    public static Lease unbounded() {
        return Lease.unbounded(null);
    }

    public static Lease unbounded(@Nullable ByteBuf metadata) {
        return Lease.create(Duration.ofMillis(Integer.MAX_VALUE), Integer.MAX_VALUE, metadata);
    }

    public static Lease empty() {
        return Lease.create(Duration.ZERO, 0);
    }

    Lease(Duration timeToLive, int numberOfRequests, @Nullable ByteBuf metadata) {
        this.numberOfRequests = numberOfRequests;
        this.timeToLiveMillis = (int)Math.min(timeToLive.toMillis(), Integer.MAX_VALUE);
        this.metadata = metadata == null ? Unpooled.EMPTY_BUFFER : metadata;
        this.expirationTime = timeToLive.isZero() ? 0L : System.currentTimeMillis() + timeToLive.toMillis();
    }

    public int numberOfRequests() {
        return this.numberOfRequests;
    }

    public int timeToLiveInMillis() {
        return this.timeToLiveMillis;
    }

    public long expirationTime() {
        return this.expirationTime;
    }

    @Nullable
    public ByteBuf metadata() {
        return this.metadata;
    }

    public String toString() {
        return "Lease{timeToLiveMillis=" + this.timeToLiveMillis + ", numberOfRequests=" + this.numberOfRequests + ", expirationTime=" + this.expirationTime + '}';
    }
}

