/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.multipart;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.MessageBodyReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.util.Encode;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.core.multipart.DefaultFileUpload;
import org.jboss.resteasy.reactive.server.core.multipart.FormData;
import org.jboss.resteasy.reactive.server.handlers.RequestDeserializeHandler;
import org.jboss.resteasy.reactive.server.multipart.FormValue;
import org.jboss.resteasy.reactive.server.multipart.MultipartFormDataInput;
import org.jboss.resteasy.reactive.server.multipart.MultipartPartReadingException;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyReader;

public final class MultipartSupport {
    private static final Logger log = Logger.getLogger(RequestDeserializeHandler.class);
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];

    private MultipartSupport() {
    }

    public static MultipartFormDataInput toMultipartFormDataInput(ResteasyReactiveRequestContext context) {
        FormData formData = context.getFormData();
        if (formData == null) {
            return MultipartFormDataInput.Empty.INSTANCE;
        }
        return formData.toMultipartFormDataInput();
    }

    public static Object getConvertedFormAttribute(String attributeName, Class type, Type genericType, MediaType mediaType, ResteasyReactiveRequestContext context) {
        FormValue value = MultipartSupport.getFirstValue(attributeName, context);
        if (value == null) {
            return null;
        }
        MessageBodyReader<?> reader = MultipartSupport.findReader(attributeName, type, genericType, mediaType, context);
        return MultipartSupport.read(reader, attributeName, value, type, genericType, mediaType, context);
    }

    private static Object read(MessageBodyReader<?> reader, String attributeName, final FormValue value, Class type, Type genericType, MediaType mediaType, ResteasyReactiveRequestContext context) {
        Supplier<InputStream> is = value.isFileItem() ? new Supplier<InputStream>(){

            @Override
            public InputStream get() {
                try {
                    return Files.newInputStream(value.getFileItem().getFile(), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        } : new ConstantSupplier<ByteArrayInputStream>(MultipartSupport.formAttributeValueToInputStream(value.getValue()));
        return MultipartSupport.read(reader, attributeName, is, type, genericType, mediaType, context);
    }

    public static List<Object> getConvertedFormAttributes(String attributeName, Class type, Type genericType, MediaType mediaType, ResteasyReactiveRequestContext context) {
        Deque<FormValue> values = MultipartSupport.getValues(attributeName, context);
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        MessageBodyReader<?> reader = MultipartSupport.findReader(attributeName, type, genericType, mediaType, context);
        for (FormValue value : values) {
            ret.add(MultipartSupport.read(reader, attributeName, value, type, genericType, mediaType, context));
        }
        return ret;
    }

    private static MessageBodyReader<?> findReader(String attributeName, Class type, Type genericType, MediaType mediaType, ResteasyReactiveRequestContext context) {
        ServerSerialisers serialisers = context.getDeployment().getSerialisers();
        List readers = serialisers.findReaders(null, type, mediaType, RuntimeType.SERVER);
        if (readers.isEmpty()) {
            throw new NotSupportedException();
        }
        for (MessageBodyReader reader : readers) {
            if (reader instanceof ServerMessageBodyReader) {
                ServerMessageBodyReader serverMessageBodyReader = (ServerMessageBodyReader)reader;
                if (!serverMessageBodyReader.isReadable(type, genericType, context.getTarget().getLazyMethod(), mediaType)) continue;
                return serverMessageBodyReader;
            }
            if (!reader.isReadable(type, genericType, EMPTY_ANNOTATIONS, mediaType)) continue;
            return reader;
        }
        throw new NotSupportedException("Media type '" + mediaType + "' in multipart request is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object read(MessageBodyReader<?> reader, String attributeName, Supplier<InputStream> inputStreamSupplier, Class type, Type genericType, MediaType mediaType, ResteasyReactiveRequestContext context) {
        Object t;
        if (!(reader instanceof ServerMessageBodyReader)) return reader.readFrom(type, genericType, EMPTY_ANNOTATIONS, mediaType, context.getHttpHeaders().getRequestHeaders(), inputStreamSupplier.get());
        ServerMessageBodyReader serverMessageBodyReader = (ServerMessageBodyReader)reader;
        InputStream originalInputStream = context.getInputStream();
        try {
            context.setInputStream(inputStreamSupplier.get());
            t = serverMessageBodyReader.readFrom(type, genericType, mediaType, context);
            context.setInputStream(originalInputStream);
        }
        catch (Throwable throwable) {
            try {
                context.setInputStream(originalInputStream);
                throw throwable;
            }
            catch (IOException | UncheckedIOException e) {
                log.error((Object)("Unable to convert value provided for attribute '" + attributeName + "' of the multipart request into type '" + type.getName() + "'"), (Throwable)e);
                throw new MultipartPartReadingException(e);
            }
        }
        return t;
    }

    private static FormValue getFirstValue(String formName, ResteasyReactiveRequestContext context) {
        Deque<FormValue> values = MultipartSupport.getValues(formName, context);
        if (values != null && !values.isEmpty()) {
            return values.getFirst();
        }
        return null;
    }

    private static Deque<FormValue> getValues(String formName, ResteasyReactiveRequestContext context) {
        FormData form = context.getFormData();
        if (form != null) {
            return form.get(formName);
        }
        return null;
    }

    public static String getString(String formName, ResteasyReactiveRequestContext context) {
        return MultipartSupport.getString(formName, context, false);
    }

    public static String getString(String formName, ResteasyReactiveRequestContext context, boolean encoded) {
        FormValue value = MultipartSupport.getFirstValue(formName, context);
        if (value == null) {
            return null;
        }
        if (value.isFileItem()) {
            try {
                return Files.readString(value.getFileItem().getFile(), Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new MultipartPartReadingException(e);
            }
        }
        if (encoded) {
            return Encode.encodeQueryParam((String)value.getValue());
        }
        return value.getValue();
    }

    public static List<String> getStrings(String formName, ResteasyReactiveRequestContext context) {
        return MultipartSupport.getStrings(formName, context, false);
    }

    public static List<String> getStrings(String formName, ResteasyReactiveRequestContext context, boolean encoded) {
        Deque<FormValue> values = MultipartSupport.getValues(formName, context);
        if (values == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (FormValue value : values) {
            if (value.isFileItem()) {
                try {
                    ret.add(Files.readString(value.getFileItem().getFile(), Charset.defaultCharset()));
                    continue;
                }
                catch (IOException e) {
                    throw new MultipartPartReadingException(e);
                }
            }
            if (encoded) {
                ret.add(Encode.encodeQueryParam((String)value.getValue()));
                continue;
            }
            ret.add(value.getValue());
        }
        return ret;
    }

    public static byte[] getByteArray(String formName, ResteasyReactiveRequestContext context) {
        FormValue value = MultipartSupport.getFirstValue(formName, context);
        if (value == null) {
            return null;
        }
        if (value.isFileItem()) {
            try {
                return Files.readAllBytes(value.getFileItem().getFile());
            }
            catch (IOException e) {
                throw new MultipartPartReadingException(e);
            }
        }
        return value.getValue().getBytes(Charset.defaultCharset());
    }

    public static List<byte[]> getByteArrays(String formName, ResteasyReactiveRequestContext context) {
        Deque<FormValue> values = MultipartSupport.getValues(formName, context);
        if (values == null) {
            return Collections.emptyList();
        }
        ArrayList<byte[]> ret = new ArrayList<byte[]>();
        for (FormValue value : values) {
            if (value.isFileItem()) {
                try {
                    ret.add(Files.readAllBytes(value.getFileItem().getFile()));
                    continue;
                }
                catch (IOException e) {
                    throw new MultipartPartReadingException(e);
                }
            }
            ret.add(value.getValue().getBytes(Charset.defaultCharset()));
        }
        return ret;
    }

    public static InputStream getInputStream(String formName, ResteasyReactiveRequestContext context) {
        FormValue value = MultipartSupport.getFirstValue(formName, context);
        if (value == null) {
            return null;
        }
        if (value.isFileItem()) {
            try {
                return new FileInputStream(value.getFileItem().getFile().toFile());
            }
            catch (IOException e) {
                throw new MultipartPartReadingException(e);
            }
        }
        return new ByteArrayInputStream(value.getValue().getBytes(Charset.defaultCharset()));
    }

    public static List<InputStream> getInputStreams(String formName, ResteasyReactiveRequestContext context) {
        Deque<FormValue> values = MultipartSupport.getValues(formName, context);
        if (values == null) {
            return Collections.emptyList();
        }
        ArrayList<InputStream> ret = new ArrayList<InputStream>();
        for (FormValue value : values) {
            if (value.isFileItem()) {
                try {
                    ret.add(new FileInputStream(value.getFileItem().getFile().toFile()));
                    continue;
                }
                catch (IOException e) {
                    throw new MultipartPartReadingException(e);
                }
            }
            ret.add(new ByteArrayInputStream(value.getValue().getBytes(Charset.defaultCharset())));
        }
        return ret;
    }

    public static DefaultFileUpload getSingleFileUpload(String formName, ResteasyReactiveRequestContext context) {
        List<DefaultFileUpload> uploads = MultipartSupport.getFileUploads(formName, context);
        if (uploads.size() > 1) {
            throw new BadRequestException("Found more than one files for attribute '" + formName + "'. Expected only one file");
        }
        if (uploads.size() == 1) {
            return uploads.get(0);
        }
        return null;
    }

    public static DefaultFileUpload getFileUpload(String formName, ResteasyReactiveRequestContext context) {
        List<DefaultFileUpload> uploads = MultipartSupport.getFileUploads(formName, context);
        if (!uploads.isEmpty()) {
            return uploads.get(0);
        }
        return null;
    }

    public static List<DefaultFileUpload> getFileUploads(String formName, ResteasyReactiveRequestContext context) {
        Deque<FormValue> fileUploadsForName;
        ArrayList<DefaultFileUpload> result = new ArrayList<DefaultFileUpload>();
        FormData formData = context.getFormData();
        if (formData != null && (fileUploadsForName = formData.get(formName)) != null) {
            for (FormValue fileUpload : fileUploadsForName) {
                if (!fileUpload.isFileItem()) continue;
                result.add(new DefaultFileUpload(formName, fileUpload));
            }
        }
        return result;
    }

    public static List<File> getJavaIOFileUploads(String formName, ResteasyReactiveRequestContext context) {
        ArrayList<File> result = new ArrayList<File>();
        List<DefaultFileUpload> uploads = MultipartSupport.getFileUploads(formName, context);
        for (DefaultFileUpload upload : uploads) {
            result.add(upload.uploadedFile().toFile());
        }
        return result;
    }

    public static List<Path> getJavaPathFileUploads(String formName, ResteasyReactiveRequestContext context) {
        ArrayList<Path> result = new ArrayList<Path>();
        List<DefaultFileUpload> uploads = MultipartSupport.getFileUploads(formName, context);
        for (DefaultFileUpload upload : uploads) {
            result.add(upload.uploadedFile());
        }
        return result;
    }

    public static List<DefaultFileUpload> getFileUploads(ResteasyReactiveRequestContext context) {
        FormData formData = context.getFormData();
        if (formData == null) {
            return Collections.emptyList();
        }
        ArrayList<DefaultFileUpload> result = new ArrayList<DefaultFileUpload>();
        for (String name : formData) {
            for (FormValue fileUpload : formData.get(name)) {
                if (!fileUpload.isFileItem()) continue;
                result.add(new DefaultFileUpload(name, fileUpload));
            }
        }
        return result;
    }

    private static ByteArrayInputStream formAttributeValueToInputStream(String formAttributeValue) {
        return new ByteArrayInputStream(formAttributeValue.getBytes(StandardCharsets.UTF_8));
    }

    public static class ConstantSupplier<T>
    implements Supplier<T> {
        private final T val;

        public ConstantSupplier(T val) {
            this.val = val;
        }

        @Override
        public T get() {
            return this.val;
        }
    }
}

