/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateNode;
import java.util.List;
import java.util.concurrent.CompletionStage;

public class InsertSectionHelper
implements SectionHelper {
    private final String name;
    private final SectionBlock defaultBlock;

    public InsertSectionHelper(String name, SectionBlock defaultBlock) {
        this.name = name;
        this.defaultBlock = defaultBlock;
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        SectionBlock extending = context.resolutionContext().getExtendingBlock(this.name);
        if (extending != null) {
            return context.execute(extending, context.resolutionContext());
        }
        return context.execute(this.defaultBlock, context.resolutionContext());
    }

    public static class Factory
    implements SectionHelperFactory<InsertSectionHelper> {
        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of("insert");
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return SectionHelperFactory.ParametersInfo.builder().addParameter("name", "$default$").build();
        }

        @Override
        public InsertSectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
            String name = context.getParameter("name");
            if (context.getEngine().getSectionHelperFactories().containsKey(name)) {
                TemplateNode.Origin origin = context.getOrigin();
                StringBuilder msg = new StringBuilder("An {#insert} section defined in the {#include} section");
                origin.appendTo(msg);
                msg.append(" conflicts with an existing section/tag: ").append(name);
                throw new TemplateException(origin, msg.toString());
            }
            return new InsertSectionHelper(name, context.getBlocks().get(0));
        }
    }
}

