/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.netty.util.AsciiString;
import io.quarkus.vertx.http.runtime.HttpConfiguration;

public class ForwardingProxyOptions {
    boolean proxyAddressForwarding;
    boolean allowForwarded;
    boolean enableForwardedHost;
    AsciiString forwardedHostHeader;

    public ForwardingProxyOptions(boolean proxyAddressForwarding, boolean allowForwarded, boolean enableForwardedHost, AsciiString forwardedHostHeader) {
        this.proxyAddressForwarding = proxyAddressForwarding;
        this.allowForwarded = allowForwarded;
        this.enableForwardedHost = enableForwardedHost;
        this.forwardedHostHeader = forwardedHostHeader;
    }

    public static ForwardingProxyOptions from(HttpConfiguration httpConfiguration) {
        boolean proxyAddressForwarding = httpConfiguration.proxyAddressForwarding.orElse(httpConfiguration.proxy.proxyAddressForwarding);
        boolean allowForwarded = httpConfiguration.allowForwarded.orElse(httpConfiguration.proxy.allowForwarded);
        boolean enableForwardedHost = httpConfiguration.proxy.enableForwardedHost;
        AsciiString forwardedHostHeader = AsciiString.cached((String)httpConfiguration.proxy.forwardedHostHeader);
        return new ForwardingProxyOptions(proxyAddressForwarding, allowForwarded, enableForwardedHost, forwardedHostHeader);
    }
}

