/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkus.security.credential.PasswordCredential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.UsernamePasswordAuthenticationRequest;
import io.quarkus.vertx.http.runtime.FormAuthConfig;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.PersistentLoginManager;
import io.quarkus.vertx.http.runtime.security.TrustedAuthenticationRequest;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.RoutingContext;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.inject.Singleton;
import org.jboss.logging.Logger;

@Singleton
public class FormAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private static final Logger log = Logger.getLogger(FormAuthenticationMechanism.class);
    public static final String DEFAULT_POST_LOCATION = "/j_security_check";
    private volatile String loginPage;
    private volatile String errorPage;
    private volatile String postLocation = "/j_security_check";
    private volatile String locationCookie = "quarkus-redirect-location";
    private volatile String landingPage = "/index.html";
    private volatile PersistentLoginManager loginManager;
    private static String encryptionKey;

    public void init(HttpConfiguration httpConfiguration, HttpBuildTimeConfig buildTimeConfig) {
        String key;
        if (httpConfiguration.encryptionKey.isEmpty()) {
            if (encryptionKey != null) {
                key = encryptionKey;
            } else {
                byte[] data = new byte[32];
                new SecureRandom().nextBytes(data);
                key = encryptionKey = Base64.getEncoder().encodeToString(data);
                log.warn((Object)("Encryption key was not specified for persistent FORM auth, using temporary key " + key));
            }
        } else {
            key = httpConfiguration.encryptionKey;
        }
        FormAuthConfig form = buildTimeConfig.auth.form;
        this.loginManager = new PersistentLoginManager(key, form.cookieName, form.timeout.toMillis(), form.newCookieInterval.toMillis());
        this.loginPage = form.loginPage.startsWith("/") ? form.loginPage : "/" + form.loginPage;
        this.errorPage = form.errorPage.startsWith("/") ? form.errorPage : "/" + form.errorPage;
        this.landingPage = form.landingPage.startsWith("/") ? form.landingPage : "/" + form.landingPage;
    }

    public CompletionStage<SecurityIdentity> runFormAuth(final RoutingContext exchange, final IdentityProviderManager securityContext) {
        exchange.request().setExpectMultipart(true);
        final CompletableFuture<SecurityIdentity> result = new CompletableFuture<SecurityIdentity>();
        exchange.request().resume();
        exchange.request().endHandler((Handler)new Handler<Void>(){

            public void handle(Void event) {
                try {
                    MultiMap res = exchange.request().formAttributes();
                    String jUsername = res.get("j_username");
                    String jPassword = res.get("j_password");
                    if (jUsername == null || jPassword == null) {
                        log.debugf("Could not authenticate as username or password was not present in the posted result for %s", (Object)exchange);
                        result.complete(null);
                        return;
                    }
                    securityContext.authenticate((AuthenticationRequest)new UsernamePasswordAuthenticationRequest(jUsername, new PasswordCredential(jPassword.toCharArray()))).handle(new BiFunction<SecurityIdentity, Throwable, Object>(){

                        @Override
                        public Object apply(SecurityIdentity identity, Throwable throwable) {
                            if (throwable != null) {
                                result.completeExceptionally(throwable);
                            } else {
                                FormAuthenticationMechanism.this.loginManager.save(identity, exchange, null);
                                FormAuthenticationMechanism.this.handleRedirectBack(exchange);
                                result.complete(null);
                            }
                            return null;
                        }
                    });
                }
                catch (Throwable t) {
                    result.completeExceptionally(t);
                }
            }
        });
        return result;
    }

    protected void handleRedirectBack(RoutingContext exchange) {
        String location;
        io.vertx.ext.web.Cookie redirect = exchange.getCookie(this.locationCookie);
        if (redirect != null) {
            location = redirect.getValue();
            exchange.response().addCookie(redirect.setMaxAge(0L));
        } else {
            location = exchange.request().scheme() + "://" + exchange.request().host() + this.landingPage;
        }
        exchange.response().setStatusCode(302);
        exchange.response().headers().add((CharSequence)HttpHeaderNames.LOCATION, (CharSequence)location);
        exchange.response().end();
    }

    protected void storeInitialLocation(RoutingContext exchange) {
        exchange.response().addCookie(Cookie.cookie((String)this.locationCookie, (String)exchange.request().absoluteURI()).setPath("/"));
    }

    protected void servePage(RoutingContext exchange, String location) {
        FormAuthenticationMechanism.sendRedirect(exchange, location);
    }

    static void sendRedirect(RoutingContext exchange, String location) {
        String loc = exchange.request().scheme() + "://" + exchange.request().host() + location;
        exchange.response().headers().add((CharSequence)HttpHeaderNames.LOCATION, (CharSequence)loc);
        exchange.response().setStatusCode(302);
        exchange.response().end();
    }

    static CompletionStage<ChallengeData> getRedirect(RoutingContext exchange, String location) {
        String loc = exchange.request().scheme() + "://" + exchange.request().host() + location;
        return CompletableFuture.completedFuture(new ChallengeData(302, "Location", loc));
    }

    @Override
    public CompletionStage<SecurityIdentity> authenticate(final RoutingContext context, IdentityProviderManager identityProviderManager) {
        final PersistentLoginManager.RestoreResult result = this.loginManager.restore(context);
        if (result != null) {
            CompletionStage ret = identityProviderManager.authenticate((AuthenticationRequest)new TrustedAuthenticationRequest(result.getPrincipal()));
            ret.thenApply(new Function<SecurityIdentity, Object>(){

                @Override
                public Object apply(SecurityIdentity identity) {
                    FormAuthenticationMechanism.this.loginManager.save(identity, context, result);
                    return null;
                }
            });
            return ret;
        }
        if (context.normalisedPath().endsWith(this.postLocation) && context.request().method().equals((Object)HttpMethod.POST)) {
            return this.runFormAuth(context, identityProviderManager);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletionStage<ChallengeData> getChallenge(RoutingContext context) {
        if (context.normalisedPath().endsWith(this.postLocation) && context.request().method().equals((Object)HttpMethod.POST)) {
            log.debugf("Serving form auth error page %s for %s", (Object)this.loginPage, (Object)context);
            return FormAuthenticationMechanism.getRedirect(context, this.errorPage);
        }
        log.debugf("Serving login form %s for %s", (Object)this.loginPage, (Object)context);
        this.storeInitialLocation(context);
        return FormAuthenticationMechanism.getRedirect(context, this.loginPage);
    }
}

