/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.devmode.tests;

import io.quarkus.deployment.dev.testing.TestClassResult;
import io.quarkus.deployment.dev.testing.TestResult;
import io.quarkus.vertx.http.deployment.devmode.tests.Result;
import java.util.List;
import java.util.stream.Collectors;

public class ClassResult
implements Comparable<ClassResult> {
    String className;
    List<Result> passing;
    List<Result> failing;
    List<Result> skipped;
    long latestRunId;

    public ClassResult(String className, List<Result> passing, List<Result> failing, List<Result> skipped) {
        this.className = className;
        this.passing = passing;
        this.failing = failing;
        this.skipped = skipped;
        long runId = 0L;
        for (Result i : passing) {
            runId = Math.max(i.getRunId(), runId);
        }
        for (Result i : failing) {
            runId = Math.max(i.getRunId(), runId);
        }
        this.latestRunId = runId;
    }

    public ClassResult(TestClassResult res) {
        this.className = res.getClassName();
        this.failing = res.getFailing().stream().map(Result::new).collect(Collectors.toList());
        this.passing = res.getPassing().stream().filter(TestResult::isTest).map(Result::new).collect(Collectors.toList());
        this.skipped = res.getSkipped().stream().filter(TestResult::isTest).map(Result::new).collect(Collectors.toList());
        this.latestRunId = res.getLatestRunId();
    }

    public ClassResult() {
    }

    public String getClassName() {
        return this.className;
    }

    public List<Result> getPassing() {
        return this.passing;
    }

    public List<Result> getFailing() {
        return this.failing;
    }

    public List<Result> getSkipped() {
        return this.skipped;
    }

    public long getLatestRunId() {
        return this.latestRunId;
    }

    public ClassResult setClassName(String className) {
        this.className = className;
        return this;
    }

    public ClassResult setPassing(List<Result> passing) {
        this.passing = passing;
        return this;
    }

    public ClassResult setFailing(List<Result> failing) {
        this.failing = failing;
        return this;
    }

    public ClassResult setSkipped(List<Result> skipped) {
        this.skipped = skipped;
        return this;
    }

    public ClassResult setLatestRunId(long latestRunId) {
        this.latestRunId = latestRunId;
        return this;
    }

    @Override
    public int compareTo(ClassResult o) {
        return this.className.compareTo(o.className);
    }
}

