/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.devmode.console;

import io.quarkus.arc.runtime.ConfigRecorder;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ConfigDescriptionBuildItem;
import io.quarkus.deployment.builditem.DevServicesLauncherConfigResultBuildItem;
import io.quarkus.dev.config.CurrentConfig;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRuntimeTemplateInfoBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ProfileManager;
import io.quarkus.vertx.http.runtime.devmode.ConfigDescription;
import io.quarkus.vertx.http.runtime.devmode.ConfigDescriptionsSupplier;
import io.quarkus.vertx.http.runtime.devmode.HasDevServicesSupplier;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.RoutingContext;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ConfigEditorProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void config(BuildProducer<DevConsoleRuntimeTemplateInfoBuildItem> devConsoleRuntimeTemplateProducer, ConfigRecorder recorder, List<ConfigDescriptionBuildItem> configDescriptionBuildItems, Optional<DevServicesLauncherConfigResultBuildItem> devServicesLauncherConfig) {
        ArrayList<ConfigDescription> configDescriptions = new ArrayList<ConfigDescription>();
        for (ConfigDescriptionBuildItem item : configDescriptionBuildItems) {
            configDescriptions.add(new ConfigDescription(item.getPropertyName(), item.getDocs(), item.getDefaultValue(), this.isSetByDevServices(devServicesLauncherConfig, item.getPropertyName()), item.getValueTypeName(), item.getAllowedValues(), item.getConfigPhase().name()));
        }
        devConsoleRuntimeTemplateProducer.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("config", (Supplier)new ConfigDescriptionsSupplier(configDescriptions)));
        devConsoleRuntimeTemplateProducer.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("hasDevServices", (Supplier)new HasDevServicesSupplier(devServicesLauncherConfig.isPresent() && devServicesLauncherConfig.get().getConfig() != null && !devServicesLauncherConfig.get().getConfig().isEmpty())));
    }

    @BuildStep
    void handleRequests(BuildProducer<DevConsoleRouteBuildItem> devConsoleRouteProducer, final Optional<DevServicesLauncherConfigResultBuildItem> devServicesLauncherConfig) {
        CurrentConfig.EDITOR = ConfigEditorProcessor::updateConfig;
        devConsoleRouteProducer.produce((BuildItem)new DevConsoleRouteBuildItem("config", "POST", (Handler)new DevConsolePostHandler(){

            protected void handlePost(RoutingContext event, MultiMap form) throws Exception {
                String action = event.request().getFormAttribute("action");
                if (action.equals("updateProperty")) {
                    String name = event.request().getFormAttribute("name");
                    String value = event.request().getFormAttribute("value");
                    Map<String, String> values = Collections.singletonMap(name, value);
                    ConfigEditorProcessor.updateConfig(values);
                } else if (action.equals("copyDevServices") && devServicesLauncherConfig.isPresent()) {
                    String environment = event.request().getFormAttribute("environment");
                    String filter = event.request().getParam("filterConfigKeys");
                    List<String> configFilter = ConfigEditorProcessor.this.getConfigFilter(filter);
                    Map<String, String> autoconfig = ((DevServicesLauncherConfigResultBuildItem)devServicesLauncherConfig.get()).getConfig();
                    autoconfig = ConfigEditorProcessor.this.filterAndApplyProfile(autoconfig, configFilter, environment.toLowerCase());
                    ConfigEditorProcessor.updateConfig(autoconfig);
                } else if (action.equals("updateProperties")) {
                    LinkedHashMap properties = new LinkedHashMap();
                    String values = event.request().getFormAttribute("values");
                    ConfigEditorProcessor.setConfig(values);
                }
            }
        }));
        devConsoleRouteProducer.produce((BuildItem)new DevConsoleRouteBuildItem("config/all", "GET", e -> e.end(Buffer.buffer((byte[])ConfigEditorProcessor.getConfig()))));
    }

    private Map<String, String> filterAndApplyProfile(Map<String, String> autoconfig, List<String> configFilter, String profile) {
        return autoconfig.entrySet().stream().filter(t -> {
            if (configFilter != null && !configFilter.isEmpty()) {
                for (String sw : configFilter) {
                    if (!((String)t.getKey()).startsWith(sw)) continue;
                    return true;
                }
            } else {
                return true;
            }
            return false;
        }).collect(Collectors.toMap(e -> this.appendProfile(profile, (String)e.getKey()), Map.Entry::getValue));
    }

    private List<String> getConfigFilter(String filter) {
        if (filter != null && !filter.isEmpty()) {
            if (filter.contains(",")) {
                return Arrays.asList(filter.split(","));
            }
            return List.of(filter);
        }
        return Collections.EMPTY_LIST;
    }

    private String appendProfile(String profile, String originalKey) {
        return String.format("%%%s.%s", profile, originalKey);
    }

    static byte[] getConfig() {
        try {
            List resourcesDir = DevConsoleManager.getHotReplacementContext().getResourcesDir();
            if (resourcesDir.isEmpty()) {
                throw new IllegalStateException("Unable to manage configurations - no resource directory found");
            }
            Path path = (Path)resourcesDir.get(0);
            Path configPath = path.resolve("application.properties");
            if (!Files.exists(configPath, new LinkOption[0])) {
                return "".getBytes();
            }
            return Files.readAllBytes(configPath);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    static void updateConfig(Map<String, String> values) {
        if (values != null && !values.isEmpty()) {
            try {
                Path configPath = ConfigEditorProcessor.getConfigPath();
                String profile = ProfileManager.getActiveProfile();
                List<String> lines = Files.readAllLines(configPath);
                for (Map.Entry<String, String> entry : values.entrySet()) {
                    String name = entry.getKey();
                    String value = entry.getValue();
                    name = !profile.equals(LaunchMode.DEVELOPMENT.getDefaultProfile()) ? "%" + profile + "." + name : name;
                    int nameLine = -1;
                    int linesSize = lines.size();
                    for (int i = 0; i < linesSize; ++i) {
                        String line = lines.get(i);
                        if (!line.startsWith(name + "=")) continue;
                        nameLine = i;
                        break;
                    }
                    if (nameLine != -1) {
                        if (value.isEmpty()) {
                            lines.remove(nameLine);
                            continue;
                        }
                        lines.set(nameLine, name + "=" + value);
                        continue;
                    }
                    if (value.isEmpty()) continue;
                    lines.add(name + "=" + value);
                }
                try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
                    for (String i : lines) {
                        writer.write(i);
                        writer.newLine();
                    }
                }
                ConfigEditorProcessor.preventKill();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    static void setConfig(String value) {
        try {
            Path configPath = ConfigEditorProcessor.getConfigPath();
            String profile = ProfileManager.getActiveProfile();
            List<String> lines = Files.readAllLines(configPath);
            try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
                if (value == null || value.isEmpty()) {
                    writer.newLine();
                } else {
                    writer.write(value);
                }
            }
            ConfigEditorProcessor.preventKill();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static void preventKill() throws Exception {
        DevConsoleManager.setDoingHttpInitiatedReload((boolean)true);
        try {
            DevConsoleManager.getHotReplacementContext().doScan(true);
        }
        finally {
            DevConsoleManager.setDoingHttpInitiatedReload((boolean)false);
        }
    }

    private static Path getConfigPath() throws IOException {
        List resourcesDir = DevConsoleManager.getHotReplacementContext().getResourcesDir();
        if (resourcesDir.isEmpty()) {
            throw new IllegalStateException("Unable to manage configurations - no resource directory found");
        }
        Path path = (Path)resourcesDir.get(0);
        Path configPath = path.resolve("application.properties");
        if (!Files.exists(configPath, new LinkOption[0])) {
            configPath = Files.createFile(path.resolve("application.properties"), new FileAttribute[0]);
        }
        return configPath;
    }

    private boolean isSetByDevServices(Optional<DevServicesLauncherConfigResultBuildItem> devServicesLauncherConfig, String propertyName) {
        if (devServicesLauncherConfig.isPresent()) {
            return devServicesLauncherConfig.get().getConfig().containsKey(propertyName);
        }
        return false;
    }
}

