/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.runtime.util.ClassPathUtils;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.quarkus.vertx.http.deployment.DefaultRouteBuildItem;
import io.quarkus.vertx.http.deployment.spi.AdditionalStaticResourceBuildItem;
import io.quarkus.vertx.http.deployment.spi.StaticResourcesBuildItem;
import io.quarkus.vertx.http.runtime.StaticResourcesRecorder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class StaticResourcesProcessor {
    @BuildStep
    void collectStaticResources(Capabilities capabilities, ApplicationArchivesBuildItem applicationArchivesBuildItem, List<AdditionalStaticResourceBuildItem> additionalStaticResources, BuildProducer<StaticResourcesBuildItem> staticResources) throws Exception {
        if (capabilities.isPresent("io.quarkus.servlet")) {
            return;
        }
        Set<StaticResourcesBuildItem.Entry> paths = this.getClasspathResources(applicationArchivesBuildItem);
        for (AdditionalStaticResourceBuildItem bi : additionalStaticResources) {
            paths.add(new StaticResourcesBuildItem.Entry(bi.getPath(), bi.isDirectory()));
        }
        if (!paths.isEmpty()) {
            staticResources.produce((BuildItem)new StaticResourcesBuildItem(paths));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void runtimeInit(Optional<StaticResourcesBuildItem> staticResources, StaticResourcesRecorder recorder, CoreVertxBuildItem vertx, BeanContainerBuildItem beanContainer, BuildProducer<DefaultRouteBuildItem> defaultRoutes) {
        if (staticResources.isPresent()) {
            defaultRoutes.produce((BuildItem)new DefaultRouteBuildItem(recorder.start(staticResources.get().getPaths())));
        }
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    public void nativeImageResource(Optional<StaticResourcesBuildItem> staticResources, BuildProducer<NativeImageResourceBuildItem> producer) {
        if (staticResources.isPresent()) {
            Set entries = staticResources.get().getEntries();
            ArrayList<CallSite> metaInfResources = new ArrayList<CallSite>(entries.size());
            for (StaticResourcesBuildItem.Entry entry : entries) {
                if (entry.isDirectory()) continue;
                String metaInfResourcesPath = "META-INF/resources" + entry.getPath();
                metaInfResources.add((CallSite)((Object)metaInfResourcesPath));
            }
            producer.produce((BuildItem)new NativeImageResourceBuildItem(metaInfResources));
        }
    }

    private Set<StaticResourcesBuildItem.Entry> getClasspathResources(ApplicationArchivesBuildItem applicationArchivesBuildItem) throws Exception {
        HashSet<StaticResourcesBuildItem.Entry> knownPaths = new HashSet<StaticResourcesBuildItem.Entry>();
        for (ApplicationArchive i : applicationArchivesBuildItem.getAllApplicationArchives()) {
            i.accept(tree -> {
                Path resource = tree.getPath("META-INF/resources");
                if (resource != null && Files.exists(resource, new LinkOption[0])) {
                    this.collectKnownPaths(resource, knownPaths);
                }
            });
        }
        ClassPathUtils.consumeAsPaths((String)"META-INF/resources", resource -> this.collectKnownPaths((Path)resource, (Set<StaticResourcesBuildItem.Entry>)knownPaths));
        return knownPaths;
    }

    private void collectKnownPaths(final Path resource, final Set<StaticResourcesBuildItem.Entry> knownPaths) {
        try {
            Files.walkFileTree(resource, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path p, BasicFileAttributes attrs) throws IOException {
                    Object file = resource.relativize(p).toString();
                    if (!((String)file).startsWith("/")) {
                        file = "/" + (String)file;
                    }
                    file = ((String)file).replace('\\', '/');
                    knownPaths.add(new StaticResourcesBuildItem.Entry((String)file, false));
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

