/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.devmode;

import io.quarkus.deployment.dev.remote.RemoteDevClient;
import io.quarkus.deployment.util.IoUtil;
import io.quarkus.dev.spi.RemoteDevState;
import io.vertx.core.http.HttpHeaders;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public class HttpRemoteDevClient
implements RemoteDevClient {
    private final Logger log = Logger.getLogger(HttpRemoteDevClient.class);
    private final String url;
    private final String password;

    public HttpRemoteDevClient(String url, String password) {
        this.url = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
        this.password = password;
    }

    public Closeable sendConnectRequest(RemoteDevState initialState, Function<Set<String>, Map<String, byte[]>> initialConnectFunction, Supplier<RemoteDevClient.SyncResult> changeRequestFunction) {
        try {
            return new Session(initialState, initialConnectFunction, changeRequestFunction);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String doConnect(RemoteDevState initialState, Function<Set<String>, Map<String, byte[]>> initialConnectFunction) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(this.url + "/connect").openConnection();
        connection.addRequestProperty(HttpHeaders.CONTENT_TYPE.toString(), "application/quarkus-live-reload");
        connection.addRequestProperty("X-Quarkus-Password", this.password);
        connection.setDoOutput(true);
        ObjectOutputStream out = new ObjectOutputStream(connection.getOutputStream());
        out.writeObject(initialState);
        out.close();
        String session = connection.getHeaderField("X-Quarkus-Session");
        if (session == null) {
            throw new IOException("Server did not start a remote dev session");
        }
        String result = new String(IoUtil.readBytes((InputStream)connection.getInputStream()), StandardCharsets.UTF_8);
        HashSet<String> changed = new HashSet<String>();
        changed.addAll(Arrays.asList(result.split(";")));
        LinkedHashMap<String, byte[]> data = new LinkedHashMap<String, byte[]>(initialConnectFunction.apply(changed));
        byte[] lastFile = (byte[])data.remove("quarkus/quarkus-application.dat");
        if (lastFile != null) {
            data.put("quarkus/quarkus-application.dat", lastFile);
        }
        for (Map.Entry<String, byte[]> entry : data.entrySet()) {
            this.sendData(entry, session);
        }
        if (lastFile != null) {
            session = this.waitForRestart(initialState, initialConnectFunction);
        } else {
            this.log.info((Object)"Connected to remote server");
        }
        return session;
    }

    private String waitForRestart(RemoteDevState initialState, Function<Set<String>, Map<String, byte[]>> initialConnectFunction) {
        long timeout = System.currentTimeMillis() + 30000L;
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (System.currentTimeMillis() < timeout) {
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL(this.url).openConnection();
                IoUtil.readBytes((InputStream)connection.getInputStream());
                return this.doConnect(initialState, initialConnectFunction);
            }
            catch (IOException iOException) {
            }
        }
        throw new RuntimeException("Could not connect to remote side after restart");
    }

    private void sendData(Map.Entry<String, byte[]> entry, String session) throws IOException {
        this.log.info((Object)("Sending " + entry.getKey()));
        HttpURLConnection connection = (HttpURLConnection)new URL(this.url + "/" + entry.getKey()).openConnection();
        connection.setRequestMethod("PUT");
        connection.setDoOutput(true);
        connection.addRequestProperty(HttpHeaders.CONTENT_TYPE.toString(), "application/quarkus-live-reload");
        connection.addRequestProperty("X-Quarkus-Password", this.password);
        connection.addRequestProperty("X-Quarkus-Session", session);
        connection.getOutputStream().write(entry.getValue());
        connection.getOutputStream().close();
        IoUtil.readBytes((InputStream)connection.getInputStream());
    }

    private class Session
    implements Closeable,
    Runnable {
        private String sessionId = null;
        private final RemoteDevState initialState;
        private final Function<Set<String>, Map<String, byte[]>> initialConnectFunction;
        private final Supplier<RemoteDevClient.SyncResult> changeRequestFunction;
        private volatile boolean closed;
        private final Thread httpThread;
        private final URL url;
        int errorCount;

        private Session(RemoteDevState initialState, Function<Set<String>, Map<String, byte[]>> initialConnectFunction, Supplier<RemoteDevClient.SyncResult> changeRequestFunction) throws MalformedURLException {
            this.initialState = initialState;
            this.initialConnectFunction = initialConnectFunction;
            this.changeRequestFunction = changeRequestFunction;
            this.url = new URL(HttpRemoteDevClient.this.url + "/dev");
            this.httpThread = new Thread((Runnable)this, "Remote dev client thread");
            this.httpThread.start();
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            this.httpThread.interrupt();
        }

        @Override
        public void run() {
            Throwable problem = null;
            while (!this.closed) {
                HttpURLConnection connection = null;
                try {
                    if (this.sessionId == null) {
                        this.sessionId = HttpRemoteDevClient.this.doConnect(this.initialState, this.initialConnectFunction);
                    }
                    connection = (HttpURLConnection)this.url.openConnection();
                    connection.setRequestMethod("POST");
                    connection.addRequestProperty(HttpHeaders.CONTENT_TYPE.toString(), "application/quarkus-live-reload");
                    connection.addRequestProperty("X-Quarkus-Password", HttpRemoteDevClient.this.password);
                    connection.addRequestProperty("X-Quarkus-Session", this.sessionId);
                    connection.setDoOutput(true);
                    try (ObjectOutputStream out = new ObjectOutputStream(connection.getOutputStream());){
                        out.writeObject(problem);
                    }
                    IoUtil.readBytes((InputStream)connection.getInputStream());
                    int status = connection.getResponseCode();
                    if (status == 200) {
                        RemoteDevClient.SyncResult sync = this.changeRequestFunction.get();
                        problem = sync.getProblem();
                        for (Map.Entry entry : sync.getChangedFiles().entrySet()) {
                            HttpRemoteDevClient.this.sendData(entry, this.sessionId);
                        }
                        for (String file : sync.getRemovedFiles()) {
                            HttpRemoteDevClient.this.log.info((Object)("deleting " + file));
                            connection = (HttpURLConnection)new URL(this.url + "/" + file).openConnection();
                            connection.setRequestMethod("DELETE");
                            connection.addRequestProperty(HttpHeaders.CONTENT_TYPE.toString(), "application/quarkus-live-reload");
                            connection.addRequestProperty("X-Quarkus-Password", HttpRemoteDevClient.this.password);
                            connection.addRequestProperty("X-Quarkus-Session", this.sessionId);
                            connection.getOutputStream().close();
                            IoUtil.readBytes((InputStream)connection.getInputStream());
                        }
                    } else if (status == 203) {
                        this.sessionId = HttpRemoteDevClient.this.doConnect(this.initialState, this.initialConnectFunction);
                    }
                    this.errorCount = 0;
                }
                catch (Throwable e) {
                    ++this.errorCount;
                    HttpRemoteDevClient.this.log.error((Object)"Remote dev request failed", e);
                    if (this.errorCount == 10) {
                        HttpRemoteDevClient.this.log.error((Object)"Connection failed after 10 retries, exiting");
                        return;
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

