/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.core.deployment;

import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ContextHandlerBuildItem;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.IOThreadDetectorBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.ThreadFactoryBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.netty.deployment.EventLoopSupplierBuildItem;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.quarkus.vertx.core.deployment.EventLoopCountBuildItem;
import io.quarkus.vertx.core.deployment.VertxOptionsConsumerBuildItem;
import io.quarkus.vertx.core.runtime.VertxCoreRecorder;
import io.quarkus.vertx.core.runtime.VertxLogDelegateFactory;
import io.quarkus.vertx.core.runtime.config.VertxConfiguration;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.BlockedThreadChecker;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Filter;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;
import org.jboss.logmanager.LogManager;

class VertxCoreProcessor {
    private static final Logger log = Logger.getLogger(VertxCoreProcessor.class);

    VertxCoreProcessor() {
    }

    @BuildStep
    NativeImageConfigBuildItem build(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{VertxLogDelegateFactory.class.getName()}));
        return NativeImageConfigBuildItem.builder().addRuntimeInitializedClass("io.vertx.core.net.impl.PartialPooledByteBufAllocator").addRuntimeInitializedClass("io.vertx.core.http.impl.VertxHttp2ClientUpgradeCodec").addRuntimeInitializedClass("io.vertx.core.eventbus.impl.clustered.ClusteredEventBus").addNativeImageSystemProperty("vertx.disableDnsResolver", "true").addNativeImageSystemProperty("vertx.logger-delegate-factory-class-name", VertxLogDelegateFactory.class.getName()).build();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    EventLoopCountBuildItem eventLoopCount(VertxCoreRecorder recorder, VertxConfiguration vertxConfiguration) {
        return new EventLoopCountBuildItem(recorder.calculateEventLoopThreads(vertxConfiguration));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    IOThreadDetectorBuildItem ioThreadDetector(VertxCoreRecorder recorder) {
        return new IOThreadDetectorBuildItem(recorder.detector());
    }

    @BuildStep
    @Produce(value=ServiceStartBuildItem.class)
    @Record(value=ExecutionTime.RUNTIME_INIT)
    CoreVertxBuildItem build(VertxCoreRecorder recorder, LaunchModeBuildItem launchMode, ShutdownContextBuildItem shutdown, VertxConfiguration config, List<VertxOptionsConsumerBuildItem> vertxOptionsConsumers, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<EventLoopSupplierBuildItem> eventLoops, ExecutorBuildItem executorBuildItem) {
        Collections.sort(vertxOptionsConsumers);
        ArrayList<Consumer<VertxOptions>> consumers = new ArrayList<Consumer<VertxOptions>>(vertxOptionsConsumers.size());
        for (VertxOptionsConsumerBuildItem x : vertxOptionsConsumers) {
            consumers.add(x.getConsumer());
        }
        Supplier vertx = recorder.configureVertx(config, launchMode.getLaunchMode(), (ShutdownContext)shutdown, consumers, executorBuildItem.getExecutorProxy());
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(Vertx.class).types(new Class[]{Vertx.class})).scope(Singleton.class)).unremovable()).setRuntimeInit().supplier(vertx).done());
        eventLoops.produce((BuildItem)new EventLoopSupplierBuildItem(recorder.mainSupplier(), recorder.bossSupplier()));
        if (launchMode.getLaunchMode().isDevOrTest()) {
            this.handleBlockingWarningsInDevOrTestMode();
        }
        return new CoreVertxBuildItem(vertx);
    }

    @BuildStep
    LogCleanupFilterBuildItem filterNettyHostsFileParsingWarn() {
        return new LogCleanupFilterBuildItem("io.netty.resolver.HostsFileParser", new String[]{"Failed to load and parse hosts file"});
    }

    @BuildStep
    void registerVerticleClasses(CombinedIndexBuildItem indexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        for (ClassInfo ci : indexBuildItem.getIndex().getAllKnownSubclasses(DotName.createSimple((String)AbstractVerticle.class.getName()))) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{ci.toString()}));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ThreadFactoryBuildItem createVertxThreadFactory(VertxCoreRecorder recorder) {
        return new ThreadFactoryBuildItem(recorder.createThreadFactory());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ContextHandlerBuildItem createVertxContextHandlers(VertxCoreRecorder recorder) {
        return new ContextHandlerBuildItem(recorder.executionContextHandler());
    }

    private void handleBlockingWarningsInDevOrTestMode() {
        try {
            final Filter debuggerFilter = this.createDebuggerFilter();
            LogManager logManager = (LogManager)LogManager.getLogManager();
            logManager.getLogger(BlockedThreadChecker.class.getName()).setFilter(new Filter(){
                volatile StackTraceElement last;

                @Override
                public boolean isLoggable(LogRecord record) {
                    if (debuggerFilter != null && !debuggerFilter.isLoggable(record)) {
                        return false;
                    }
                    if (record.getThrown() == null) {
                        return true;
                    }
                    StackTraceElement element = record.getThrown().getStackTrace()[0];
                    if (this.last != null && element.equals(this.last)) {
                        return false;
                    }
                    this.last = element;
                    return true;
                }
            });
        }
        catch (Throwable t) {
            log.debug((Object)"Failed to filter blocked thread checker", t);
        }
    }

    private Filter createDebuggerFilter() {
        try {
            Filter filter;
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            if (runtime == null) {
                return null;
            }
            int debugPort = -1;
            InetAddress bindAddress = null;
            boolean alwaysFilter = false;
            List<String> args = runtime.getInputArguments();
            for (String arg : args) {
                if (!arg.startsWith("-Xrunjdwp") && !arg.startsWith("-agentlib:jdwp")) continue;
                boolean client = true;
                if (!arg.contains("transport=dt_socket")) {
                    return null;
                }
                Pattern server = Pattern.compile("server=(.)");
                Matcher m = server.matcher(arg);
                if (m.find() && m.group(1).equals("y")) {
                    client = false;
                }
                if (client) {
                    alwaysFilter = true;
                    break;
                }
                Pattern port = Pattern.compile("address=(.*?):(\\d+)");
                m = port.matcher(arg);
                if (!m.find()) continue;
                debugPort = Integer.parseInt(m.group(2));
                String host = m.group(1);
                if (host.equals("*")) {
                    host.equals("localhost");
                }
                bindAddress = InetAddress.getByName(host);
            }
            if (debugPort == -1 && !alwaysFilter) {
                return null;
            }
            LogManager logManager = (LogManager)LogManager.getLogManager();
            if (alwaysFilter) {
                filter = s -> false;
            } else {
                final int port = debugPort;
                final InetAddress bind = bindAddress;
                filter = new Filter(){

                    @Override
                    public boolean isLoggable(LogRecord record) {
                        try {
                            ServerSocket s = new ServerSocket(port, 1, bind);
                            s.close();
                        }
                        catch (IOException e) {
                            return true;
                        }
                        return false;
                    }
                };
            }
            return filter;
        }
        catch (Throwable t) {
            log.debug((Object)"Failed to filter blocked thread checker", t);
            return null;
        }
    }
}

