/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.runtime;

import io.netty.buffer.ByteBuf;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.MemorySize;
import io.quarkus.undertow.runtime.DelegatingResourceManager;
import io.quarkus.undertow.runtime.KnownPathResourceManager;
import io.quarkus.undertow.runtime.QuarkusAuthMechanism;
import io.quarkus.undertow.runtime.QuarkusErrorServlet;
import io.quarkus.undertow.runtime.QuarkusExceptionHandler;
import io.quarkus.undertow.runtime.QuarkusInstanceFactory;
import io.quarkus.undertow.runtime.QuarkusUndertowAccount;
import io.quarkus.undertow.runtime.ServletHttpSecurityPolicy;
import io.quarkus.undertow.runtime.ServletRuntimeConfig;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.undertow.httpcore.BufferAllocator;
import io.undertow.httpcore.HttpExchange;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.api.SecurityNotification;
import io.undertow.server.DefaultExchangeHandler;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.resource.CachingResourceManager;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.session.SessionIdGenerator;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ErrorPage;
import io.undertow.servlet.api.ExceptionHandler;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ServletSecurityInfo;
import io.undertow.servlet.api.ThreadSetupHandler;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.handlers.DefaultServlet;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.util.AttachmentKey;
import io.undertow.util.ImmediateAuthenticationMechanismFactory;
import io.undertow.vertx.VertxHttpExchange;
import io.vertx.core.Handler;
import io.vertx.core.net.impl.PartialPooledByteBufAllocator;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.math.BigInteger;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import javax.enterprise.inject.spi.CDI;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.jboss.logging.Logger;

@Recorder
public class UndertowDeploymentRecorder {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.undertow");
    public static final HttpHandler ROOT_HANDLER = new HttpHandler(){

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            currentRoot.handleRequest(exchange);
        }
    };
    private static final List<HandlerWrapper> hotDeploymentWrappers = new CopyOnWriteArrayList<HandlerWrapper>();
    private static volatile List<Path> hotDeploymentResourcePaths;
    private static volatile HttpHandler currentRoot;
    private static volatile ServletContext servletContext;
    private static final AttachmentKey<InjectableContext.ContextState> REQUEST_CONTEXT;
    protected static final int DEFAULT_BUFFER_SIZE;
    protected static final boolean DEFAULT_DIRECT_BUFFERS;

    public static void setHotDeploymentResources(List<Path> resources) {
        hotDeploymentResourcePaths = resources;
    }

    public RuntimeValue<DeploymentInfo> createDeployment(String name, Set<String> knownFile, Set<String> knownDirectories, LaunchMode launchMode, ShutdownContext context, String contextPath, String httpRootPath) {
        Object resourceManager;
        String realMountPoint = contextPath.equals("/") ? httpRootPath : (httpRootPath.equals("/") ? contextPath : httpRootPath + contextPath);
        final DeploymentInfo d = new DeploymentInfo();
        d.setSessionIdGenerator((SessionIdGenerator)new QuarkusSessionIdGenerator());
        d.setClassLoader(this.getClass().getClassLoader());
        d.setDeploymentName(name);
        d.setContextPath(realMountPoint);
        d.setEagerFilterInit(true);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = new ClassLoader(){};
        }
        d.setClassLoader(cl);
        if (hotDeploymentResourcePaths == null) {
            resourceManager = new KnownPathResourceManager(knownFile, knownDirectories, (ResourceManager)new ClassPathResourceManager(d.getClassLoader(), "META-INF/resources"));
        } else {
            ArrayList<Object> managers = new ArrayList<Object>();
            for (Path i : hotDeploymentResourcePaths) {
                managers.add(new PathResourceManager(i));
            }
            managers.add(new ClassPathResourceManager(d.getClassLoader(), "META-INF/resources"));
            resourceManager = new DelegatingResourceManager(managers.toArray(new ResourceManager[0]));
        }
        if (launchMode == LaunchMode.NORMAL) {
            resourceManager = new CachingResourceManager(1000, 0L, null, (ResourceManager)resourceManager, 2000);
        }
        d.setResourceManager((ResourceManager)resourceManager);
        d.addWelcomePages(new String[]{"index.html", "index.htm"});
        d.addServlet(new ServletInfo("default", DefaultServlet.class).setAsyncSupported(true));
        for (HandlerWrapper i : hotDeploymentWrappers) {
            d.addOuterHandlerChainWrapper(i);
        }
        d.addAuthenticationMechanism("QUARKUS", (AuthenticationMechanismFactory)new ImmediateAuthenticationMechanismFactory((AuthenticationMechanism)QuarkusAuthMechanism.INSTANCE));
        d.setLoginConfig(new LoginConfig("QUARKUS", "QUARKUS"));
        context.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                try {
                    d.getResourceManager().close();
                }
                catch (IOException e) {
                    log.error((Object)"Failed to close Servlet ResourceManager", (Throwable)e);
                }
            }
        });
        d.addNotificationReceiver(new NotificationReceiver(){

            public void handleNotification(SecurityNotification notification) {
                if (notification.getEventType() == SecurityNotification.EventType.AUTHENTICATED) {
                    QuarkusUndertowAccount account = (QuarkusUndertowAccount)notification.getAccount();
                    CDI.current().getBeanManager().fireEvent((Object)account.getSecurityIdentity(), new Annotation[0]);
                }
            }
        });
        return new RuntimeValue((Object)d);
    }

    public static SocketAddress getHttpAddress() {
        return null;
    }

    public RuntimeValue<ServletInfo> registerServlet(RuntimeValue<DeploymentInfo> deploymentInfo, String name, Class<?> servletClass, boolean asyncSupported, int loadOnStartup, BeanContainer beanContainer, Map<String, String> initParams, InstanceFactory<? extends Servlet> instanceFactory) throws Exception {
        QuarkusInstanceFactory factory = instanceFactory != null ? instanceFactory : new QuarkusInstanceFactory(beanContainer.instanceFactory(servletClass, new Annotation[0]));
        ServletInfo servletInfo = new ServletInfo(name, servletClass, factory);
        for (Map.Entry<String, String> e : initParams.entrySet()) {
            servletInfo.addInitParam(e.getKey(), e.getValue());
        }
        ((DeploymentInfo)deploymentInfo.getValue()).addServlet(servletInfo);
        servletInfo.setAsyncSupported(asyncSupported);
        if (loadOnStartup > 0) {
            servletInfo.setLoadOnStartup(Integer.valueOf(loadOnStartup));
        }
        return new RuntimeValue((Object)servletInfo);
    }

    public void addServletInitParam(RuntimeValue<ServletInfo> info, String name, String value) {
        ((ServletInfo)info.getValue()).addInitParam(name, value);
    }

    public void addServletMapping(RuntimeValue<DeploymentInfo> info, String name, String mapping) throws Exception {
        ServletInfo sv = (ServletInfo)((DeploymentInfo)info.getValue()).getServlets().get(name);
        sv.addMapping(mapping);
    }

    public void setMultipartConfig(RuntimeValue<ServletInfo> sref, String location, long fileSize, long maxRequestSize, int fileSizeThreshold) {
        MultipartConfigElement mp = new MultipartConfigElement(location, fileSize, maxRequestSize, fileSizeThreshold);
        ((ServletInfo)sref.getValue()).setMultipartConfig(mp);
    }

    public void setSecurityInfo(RuntimeValue<ServletInfo> sref, ServletSecurityInfo securityInfo) {
        ((ServletInfo)sref.getValue()).setServletSecurityInfo(securityInfo);
    }

    public void addSecurityRoleRef(RuntimeValue<ServletInfo> sref, String roleName, String roleLink) {
        ((ServletInfo)sref.getValue()).addSecurityRoleRef(roleName, roleLink);
    }

    public RuntimeValue<FilterInfo> registerFilter(RuntimeValue<DeploymentInfo> info, String name, Class<?> filterClass, boolean asyncSupported, BeanContainer beanContainer, Map<String, String> initParams, InstanceFactory<? extends Filter> instanceFactory) throws Exception {
        QuarkusInstanceFactory factory = instanceFactory != null ? instanceFactory : new QuarkusInstanceFactory(beanContainer.instanceFactory(filterClass, new Annotation[0]));
        FilterInfo filterInfo = new FilterInfo(name, filterClass, factory);
        for (Map.Entry<String, String> e : initParams.entrySet()) {
            filterInfo.addInitParam(e.getKey(), e.getValue());
        }
        ((DeploymentInfo)info.getValue()).addFilter(filterInfo);
        filterInfo.setAsyncSupported(asyncSupported);
        return new RuntimeValue((Object)filterInfo);
    }

    public void addFilterInitParam(RuntimeValue<FilterInfo> info, String name, String value) {
        ((FilterInfo)info.getValue()).addInitParam(name, value);
    }

    public void addFilterURLMapping(RuntimeValue<DeploymentInfo> info, String name, String mapping, DispatcherType dispatcherType) throws Exception {
        ((DeploymentInfo)info.getValue()).addFilterUrlMapping(name, mapping, dispatcherType);
    }

    public void addFilterServletNameMapping(RuntimeValue<DeploymentInfo> info, String name, String mapping, DispatcherType dispatcherType) throws Exception {
        ((DeploymentInfo)info.getValue()).addFilterServletNameMapping(name, mapping, dispatcherType);
    }

    public void registerListener(RuntimeValue<DeploymentInfo> info, Class<?> listenerClass, BeanContainer factory) {
        ((DeploymentInfo)info.getValue()).addListener(new ListenerInfo(listenerClass, new QuarkusInstanceFactory(factory.instanceFactory(listenerClass, new Annotation[0]))));
    }

    public void addServletInitParameter(RuntimeValue<DeploymentInfo> info, String name, String value) {
        ((DeploymentInfo)info.getValue()).addInitParameter(name, value);
    }

    public void setupSecurity(DeploymentManager manager) {
        ((ServletHttpSecurityPolicy)CDI.current().select(ServletHttpSecurityPolicy.class, new Annotation[0]).get()).setDeployment(manager.getDeployment());
    }

    public Handler<RoutingContext> startUndertow(ShutdownContext shutdown, final ExecutorService executorService, final DeploymentManager manager, List<HandlerWrapper> wrappers, final HttpConfiguration httpConfiguration, ServletRuntimeConfig servletRuntimeConfig) throws Exception {
        shutdown.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                try {
                    manager.stop();
                }
                catch (ServletException e) {
                    log.error((Object)"Failed to stop deployment", (Throwable)e);
                }
                manager.undeploy();
            }
        });
        HttpHandler main = manager.getDeployment().getHandler();
        for (HandlerWrapper i : wrappers) {
            main = i.wrap(main);
        }
        if (!manager.getDeployment().getDeploymentInfo().getContextPath().equals("/")) {
            PathHandler pathHandler = new PathHandler().addPrefixPath(manager.getDeployment().getDeploymentInfo().getContextPath(), main);
            main = pathHandler;
        }
        currentRoot = main;
        final DefaultExchangeHandler defaultHandler = new DefaultExchangeHandler(ROOT_HANDLER);
        final UndertowBufferAllocator allocator = new UndertowBufferAllocator(servletRuntimeConfig.directBuffers.orElse(DEFAULT_DIRECT_BUFFERS), (int)servletRuntimeConfig.bufferSize.orElse(new MemorySize(BigInteger.valueOf(DEFAULT_BUFFER_SIZE))).asLongValue());
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                VertxHttpExchange exchange = new VertxHttpExchange(event.request(), (BufferAllocator)allocator, (Executor)executorService, (Object)event);
                Optional maxBodySize = httpConfiguration.limits.maxBodySize;
                if (maxBodySize.isPresent()) {
                    exchange.setMaxEntitySize(((MemorySize)maxBodySize.get()).asLongValue());
                }
                defaultHandler.handle((HttpExchange)exchange);
            }
        };
    }

    public static void addHotDeploymentWrapper(HandlerWrapper handlerWrapper) {
        hotDeploymentWrappers.add(handlerWrapper);
    }

    public Supplier<ServletContext> servletContextSupplier() {
        return new ServletContextSupplier();
    }

    public DeploymentManager bootServletContainer(RuntimeValue<DeploymentInfo> info, final BeanContainer beanContainer, LaunchMode launchMode, ShutdownContext shutdownContext) {
        if (((DeploymentInfo)info.getValue()).getExceptionHandler() == null) {
            boolean alreadyMapped = false;
            for (ErrorPage i : ((DeploymentInfo)info.getValue()).getErrorPages()) {
                if (i.getErrorCode() == null || i.getErrorCode() != 500) continue;
                alreadyMapped = true;
                break;
            }
            if (!alreadyMapped || launchMode.isDevOrTest()) {
                ((DeploymentInfo)info.getValue()).setExceptionHandler((ExceptionHandler)new QuarkusExceptionHandler());
                ((DeploymentInfo)info.getValue()).addErrorPage(new ErrorPage("/@QuarkusError", 500));
                ((DeploymentInfo)info.getValue()).addServlet(new ServletInfo("@QuarkusError", QuarkusErrorServlet.class).addMapping("/@QuarkusError").setAsyncSupported(true).addInitParam("show-stack", Boolean.toString(launchMode.isDevOrTest())));
            }
        }
        try {
            final ClassIntrospecter defaultVal = ((DeploymentInfo)info.getValue()).getClassIntrospecter();
            ((DeploymentInfo)info.getValue()).setClassIntrospecter(new ClassIntrospecter(){

                public <T> InstanceFactory<T> createInstanceFactory(Class<T> clazz) throws NoSuchMethodException {
                    final BeanContainer.Factory res = beanContainer.instanceFactory(clazz, new Annotation[0]);
                    if (res == null) {
                        return defaultVal.createInstanceFactory(clazz);
                    }
                    return new InstanceFactory<T>(){

                        public InstanceHandle<T> createInstance() throws InstantiationException {
                            final BeanContainer.Instance ih = res.create();
                            return new InstanceHandle<T>(){

                                public T getInstance() {
                                    return ih.get();
                                }

                                public void release() {
                                    ih.close();
                                }
                            };
                        }
                    };
                }
            });
            ServletContainer servletContainer = Servlets.defaultContainer();
            DeploymentManager manager = servletContainer.addDeployment((DeploymentInfo)info.getValue());
            manager.deploy();
            manager.start();
            servletContext = manager.getDeployment().getServletContext();
            shutdownContext.addShutdownTask(new Runnable(){

                @Override
                public void run() {
                    servletContext = null;
                }
            });
            return manager;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addServletContextAttribute(RuntimeValue<DeploymentInfo> deployment, String key, Object value1) {
        ((DeploymentInfo)deployment.getValue()).addServletContextAttribute(key, value1);
    }

    public void addServletExtension(RuntimeValue<DeploymentInfo> deployment, ServletExtension extension) {
        ((DeploymentInfo)deployment.getValue()).addServletExtension(extension);
    }

    public ServletExtension setupRequestScope(final BeanContainer beanContainer) {
        return new ServletExtension(){

            public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
                final CurrentVertxRequest currentVertxRequest = (CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get();
                deploymentInfo.addThreadSetupAction(new ThreadSetupHandler(){

                    public <T, C> ThreadSetupHandler.Action<T, C> create(final ThreadSetupHandler.Action<T, C> action) {
                        return new ThreadSetupHandler.Action<T, C>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public T call(HttpServerExchange exchange, C context) throws Exception {
                                Object object;
                                if (exchange == null) {
                                    return action.call(exchange, context);
                                }
                                ManagedContext requestContext = beanContainer.requestContext();
                                if (requestContext.isActive()) {
                                    return action.call(exchange, context);
                                }
                                InjectableContext.ContextState existingRequestContext = (InjectableContext.ContextState)exchange.getAttachment(REQUEST_CONTEXT);
                                try {
                                    requestContext.activate(existingRequestContext);
                                    VertxHttpExchange delegate = (VertxHttpExchange)exchange.getDelegate();
                                    RoutingContext rc = (RoutingContext)delegate.getContext();
                                    currentVertxRequest.setCurrent(rc);
                                    object = action.call(exchange, context);
                                }
                                catch (Throwable throwable) {
                                    ServletRequestContext src = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                                    HttpServletRequestImpl req = src.getOriginalRequest();
                                    if (req.isAsyncStarted()) {
                                        exchange.putAttachment(REQUEST_CONTEXT, (Object)requestContext.getState());
                                        requestContext.deactivate();
                                        if (existingRequestContext == null) {
                                            req.getAsyncContextInternal().addListener(new AsyncListener(requestContext, exchange){
                                                final /* synthetic */ ManagedContext val$requestContext;
                                                final /* synthetic */ HttpServerExchange val$exchange;
                                                {
                                                    this.val$requestContext = managedContext;
                                                    this.val$exchange = httpServerExchange;
                                                }

                                                public void onComplete(AsyncEvent event) throws IOException {
                                                    this.val$requestContext.activate((InjectableContext.ContextState)this.val$exchange.getAttachment(REQUEST_CONTEXT));
                                                    this.val$requestContext.terminate();
                                                }

                                                public void onTimeout(AsyncEvent event) throws IOException {
                                                    this.onComplete(event);
                                                }

                                                public void onError(AsyncEvent event) throws IOException {
                                                    this.onComplete(event);
                                                }

                                                public void onStartAsync(AsyncEvent event) throws IOException {
                                                }
                                            });
                                        }
                                    } else {
                                        requestContext.terminate();
                                    }
                                    throw throwable;
                                }
                                ServletRequestContext src = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                                HttpServletRequestImpl req = src.getOriginalRequest();
                                if (req.isAsyncStarted()) {
                                    exchange.putAttachment(REQUEST_CONTEXT, (Object)requestContext.getState());
                                    requestContext.deactivate();
                                    if (existingRequestContext == null) {
                                        req.getAsyncContextInternal().addListener(new /* invalid duplicate definition of identical inner class */);
                                    }
                                } else {
                                    requestContext.terminate();
                                }
                                return object;
                            }
                        };
                    }
                });
            }
        };
    }

    public void addServletContainerInitializer(RuntimeValue<DeploymentInfo> deployment, Class<? extends ServletContainerInitializer> sciClass, Set<Class<?>> handlesTypes) {
        ((DeploymentInfo)deployment.getValue()).addServletContainerInitializer(new ServletContainerInitializerInfo(sciClass, handlesTypes));
    }

    public void addContextParam(RuntimeValue<DeploymentInfo> deployment, String paramName, String paramValue) {
        ((DeploymentInfo)deployment.getValue()).addInitParameter(paramName, paramValue);
    }

    public void setDenyUncoveredHttpMethods(RuntimeValue<DeploymentInfo> deployment, boolean denyUncoveredHttpMethods) {
        ((DeploymentInfo)deployment.getValue()).setDenyUncoveredHttpMethods(denyUncoveredHttpMethods);
    }

    public void addSecurityConstraint(RuntimeValue<DeploymentInfo> deployment, SecurityConstraint securityConstraint) {
        ((DeploymentInfo)deployment.getValue()).addSecurityConstraint(securityConstraint);
    }

    public void addSecurityConstraint(RuntimeValue<DeploymentInfo> deployment, SecurityInfo.EmptyRoleSemantic emptyRoleSemantic, TransportGuaranteeType transportGuaranteeType, Set<String> rolesAllowed, Set<WebResourceCollection> webResourceCollections) {
        SecurityConstraint securityConstraint = ((SecurityConstraint)((SecurityConstraint)((SecurityConstraint)new SecurityConstraint().setEmptyRoleSemantic(emptyRoleSemantic)).addRolesAllowed(rolesAllowed)).setTransportGuaranteeType(transportGuaranteeType)).addWebResourceCollections(webResourceCollections.toArray(new WebResourceCollection[0]));
        ((DeploymentInfo)deployment.getValue()).addSecurityConstraint(securityConstraint);
    }

    static {
        currentRoot = ResponseCodeHandler.HANDLE_404;
        REQUEST_CONTEXT = AttachmentKey.create(InjectableContext.ContextState.class);
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory < 0x4000000L) {
            DEFAULT_DIRECT_BUFFERS = false;
            DEFAULT_BUFFER_SIZE = 512;
        } else if (maxMemory < 0x8000000L) {
            DEFAULT_DIRECT_BUFFERS = true;
            DEFAULT_BUFFER_SIZE = 1024;
        } else {
            DEFAULT_DIRECT_BUFFERS = true;
            DEFAULT_BUFFER_SIZE = 16364;
        }
    }

    private static class UndertowBufferAllocator
    implements BufferAllocator {
        private final boolean defaultDirectBuffers;
        private final int defaultBufferSize;

        private UndertowBufferAllocator(boolean defaultDirectBuffers, int defaultBufferSize) {
            this.defaultDirectBuffers = defaultDirectBuffers;
            this.defaultBufferSize = defaultBufferSize;
        }

        public ByteBuf allocateBuffer() {
            return this.allocateBuffer(this.defaultDirectBuffers);
        }

        public ByteBuf allocateBuffer(boolean direct) {
            if (direct) {
                return PartialPooledByteBufAllocator.DEFAULT.directBuffer(this.defaultBufferSize);
            }
            return PartialPooledByteBufAllocator.DEFAULT.heapBuffer(this.defaultBufferSize);
        }

        public ByteBuf allocateBuffer(int bufferSize) {
            return this.allocateBuffer(this.defaultDirectBuffers, bufferSize);
        }

        public ByteBuf allocateBuffer(boolean direct, int bufferSize) {
            if (direct) {
                return PartialPooledByteBufAllocator.DEFAULT.directBuffer(bufferSize);
            }
            return PartialPooledByteBufAllocator.DEFAULT.heapBuffer(bufferSize);
        }

        public int getBufferSize() {
            return this.defaultBufferSize;
        }
    }

    public static class ServletContextSupplier
    implements Supplier<ServletContext> {
        @Override
        public ServletContext get() {
            return servletContext;
        }
    }

    private static class QuarkusSessionIdGenerator
    implements SessionIdGenerator {
        private volatile SecureRandom random;
        private volatile int length = 30;
        private static final char[] SESSION_ID_ALPHABET;
        private static final String ALPHABET_PROPERTY = "io.undertow.server.session.SecureRandomSessionIdGenerator.ALPHABET";

        private QuarkusSessionIdGenerator() {
        }

        public String createSessionId() {
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            byte[] bytes = new byte[this.length];
            this.random.nextBytes(bytes);
            return new String(this.encode(bytes));
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        private char[] encode(byte[] data) {
            char[] out = new char[(data.length + 2) / 3 * 4];
            char[] alphabet = SESSION_ID_ALPHABET;
            int i = 0;
            int index = 0;
            while (i < data.length) {
                boolean quad = false;
                boolean trip = false;
                int val = 0xFF & data[i];
                val <<= 8;
                if (i + 1 < data.length) {
                    val |= 0xFF & data[i + 1];
                    trip = true;
                }
                val <<= 8;
                if (i + 2 < data.length) {
                    val |= 0xFF & data[i + 2];
                    quad = true;
                }
                out[index + 3] = alphabet[quad ? val & 0x3F : 63];
                out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 63];
                out[index + 1] = alphabet[(val >>= 6) & 0x3F];
                out[index] = alphabet[(val >>= 6) & 0x3F];
                i += 3;
                index += 4;
            }
            return out;
        }

        static {
            String alphabet = System.getProperty(ALPHABET_PROPERTY, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_");
            if (alphabet.length() != 64) {
                throw new RuntimeException("io.undertow.server.session.SecureRandomSessionIdGenerator must be exactly 64 characters long");
            }
            SESSION_ID_ALPHABET = alphabet.toCharArray();
        }
    }
}

