/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.websockets.runtime;

import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.undertow.websockets.runtime.ExecutorSupplier;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpointConfig;
import org.jboss.logging.Logger;

@Recorder
public class UndertowWebsocketRecorder {
    private static final Logger log = Logger.getLogger(UndertowWebsocketRecorder.class);

    public void setupWorker(Executor executor) {
        ExecutorSupplier.executor = executor;
    }

    public WebSocketDeploymentInfo createDeploymentInfo(Set<String> annotatedEndpoints, Set<String> endpoints, Set<String> serverApplicationConfigClasses) {
        WebSocketDeploymentInfo container = new WebSocketDeploymentInfo();
        container.setDispatchToWorkerThread(false);
        container.setExecutor((Supplier)new ExecutorSupplier());
        HashSet allScannedEndpointImplementations = new HashSet();
        for (String string : endpoints) {
            try {
                allScannedEndpointImplementations.add(Class.forName(string, true, Thread.currentThread().getContextClassLoader()));
            }
            catch (Exception e) {
                log.error((Object)("Could not initialize websocket class " + string), (Throwable)e);
            }
        }
        HashSet allScannedAnnotatedEndpoints = new HashSet();
        for (String i : annotatedEndpoints) {
            try {
                allScannedAnnotatedEndpoints.add(Class.forName(i, true, Thread.currentThread().getContextClassLoader()));
            }
            catch (Exception e) {
                log.error((Object)("Could not initialize websocket class " + i), (Throwable)e);
            }
        }
        HashSet hashSet = new HashSet();
        HashSet serverEndpointConfigurations = new HashSet();
        HashSet<ServerApplicationConfig> configInstances = new HashSet<ServerApplicationConfig>();
        for (String string : serverApplicationConfigClasses) {
            try {
                configInstances.add((ServerApplicationConfig)Class.forName(string, true, Thread.currentThread().getContextClassLoader()).newInstance());
            }
            catch (Exception e) {
                log.error((Object)("Could not initialize websocket config class " + string), (Throwable)e);
            }
        }
        if (!configInstances.isEmpty()) {
            for (ServerApplicationConfig serverApplicationConfig : configInstances) {
                Set endpointConfigs;
                Set returnedEndpoints = serverApplicationConfig.getAnnotatedEndpointClasses(allScannedAnnotatedEndpoints);
                if (returnedEndpoints != null) {
                    hashSet.addAll(returnedEndpoints);
                }
                if ((endpointConfigs = serverApplicationConfig.getEndpointConfigs(allScannedEndpointImplementations)) == null) continue;
                serverEndpointConfigurations.addAll(endpointConfigs);
            }
        } else {
            hashSet.addAll(allScannedAnnotatedEndpoints);
        }
        for (Class clazz : hashSet) {
            if (clazz == null) continue;
            container.addEndpoint(clazz);
        }
        for (ServerEndpointConfig serverEndpointConfig : serverEndpointConfigurations) {
            if (serverEndpointConfig == null) continue;
            container.addEndpoint(serverEndpointConfig);
        }
        return container;
    }
}

