/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.commons.classloading.ClassLoaderHelper;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathVisit;
import io.quarkus.runtime.util.ClassPathUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public final class PathTestHelper {
    private static final String TARGET = "target";
    private static final Map<String, String> TEST_TO_MAIN_DIR_FRAGMENTS = new HashMap<String, String>();
    private static final List<String> TEST_DIRS;

    private PathTestHelper() {
    }

    public static Path getTestClassesLocation(Class<?> testClass) {
        String classFileName = ClassLoaderHelper.fromClassNameToResourceName((String)testClass.getName());
        URL resource = testClass.getClassLoader().getResource(classFileName);
        if (resource == null) {
            throw new IllegalStateException("Could not find resource " + classFileName + " using class loader " + String.valueOf(testClass.getClassLoader()));
        }
        if (resource.getProtocol().equals("jar")) {
            try {
                resource = URI.create(resource.getFile().substring(0, resource.getFile().indexOf(33))).toURL();
                return PathTestHelper.toPath(resource);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to resolve the location of the JAR containing " + classFileName, e);
            }
        }
        if (resource.getProtocol().equals("quarkus")) {
            ApplicationModel appModel = ((QuarkusClassLoader)testClass.getClassLoader()).getCuratedApplication().getApplicationModel();
            Path testLocation = PathTestHelper.getTestClassesDirOrNull(classFileName, appModel.getApplicationModule());
            if (testLocation != null) {
                return testLocation;
            }
            testLocation = PathTestHelper.getTestClassLocationFromDepsOrNull(classFileName, appModel, 6);
            if (testLocation != null) {
                return testLocation;
            }
            testLocation = PathTestHelper.getTestClassLocationFromDepsOrNull(classFileName, appModel, 4);
            if (testLocation != null) {
                return testLocation;
            }
            throw new RuntimeException("Failed to locate " + classFileName + " among the application dependencies");
        }
        Path path = PathTestHelper.toPath(resource);
        if (!PathTestHelper.isInTestDir(path = path.getRoot().resolve(path.subpath(0, path.getNameCount() - Path.of(classFileName, new String[0]).getNameCount()))) && !path.getParent().getFileName().toString().equals(TARGET)) {
            StringBuilder msg = new StringBuilder();
            msg.append("The test class ").append(testClass.getName()).append(" is not located in any of the directories ");
            Iterator<String> i = TEST_DIRS.iterator();
            msg.append(i.next());
            while (i.hasNext()) {
                msg.append(", ").append(i.next());
            }
            throw new RuntimeException(msg.toString());
        }
        return path;
    }

    private static Path getTestClassLocationFromDepsOrNull(String classFileName, ApplicationModel appModel, int depFlags) {
        for (ResolvedDependency d : appModel.getDependencies(depFlags)) {
            Path root = (Path)d.getContentTree().apply(classFileName, PathTestHelper::getRootOrNull);
            if (root == null) continue;
            return root;
        }
        return null;
    }

    public static Path getTestClassesLocation(Class<?> requiredTestClass, CuratedApplication curatedApplication) {
        Path testClassesDir = PathTestHelper.getTestClassesDirOrNull(ClassLoaderHelper.fromClassNameToResourceName((String)requiredTestClass.getName()), curatedApplication.getApplicationModel().getApplicationModule());
        return testClassesDir != null ? testClassesDir : PathTestHelper.getTestClassesLocation(requiredTestClass);
    }

    private static Path getTestClassesDirOrNull(String testClassFileName, WorkspaceModule module) {
        Path classLocation;
        ArtifactSources testSources = module.getTestSources();
        if (testSources != null && (classLocation = PathTestHelper.getContainingRootIgnoringFiltersOrNull(testSources, testClassFileName)) != null) {
            return classLocation;
        }
        for (String classifier : module.getSourceClassifiers()) {
            Path classLocation2;
            ArtifactSources sources = module.getSources(classifier);
            if (!sources.isOutputAvailable() || (classLocation2 = PathTestHelper.getContainingRootIgnoringFiltersOrNull(sources, testClassFileName)) == null) continue;
            return classLocation2;
        }
        return null;
    }

    private static Path getContainingRootIgnoringFiltersOrNull(ArtifactSources artifactSources, String testClassFileResource) {
        for (Path rootDir : artifactSources.getOutputTree().getRoots()) {
            if (!Files.exists(rootDir.resolve(testClassFileResource), new LinkOption[0])) continue;
            return rootDir;
        }
        return null;
    }

    private static Path getRootOrNull(PathVisit visit) {
        if (visit == null) {
            return null;
        }
        return visit.getRoot();
    }

    public static void validateTestDir(Class<?> requiredTestClass, Path testClassesDir, WorkspaceModule module) {
        if (testClassesDir == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Failed to locate ").append(requiredTestClass.getName()).append(" in ");
            for (String classifier : module.getSourceClassifiers()) {
                ArtifactSources sources = module.getSources(classifier);
                if (!sources.isOutputAvailable()) continue;
                for (SourceDir d : sources.getSourceDirs()) {
                    if (!Files.exists(d.getOutputDir(), new LinkOption[0])) continue;
                    sb.append(System.lineSeparator()).append(d.getOutputDir());
                }
            }
            throw new RuntimeException(sb.toString());
        }
    }

    public static Path getAppClassLocationForTestLocation(Path testClassLocationPath) {
        String testClassLocation = testClassLocationPath.toString();
        if (testClassLocation.endsWith(".jar")) {
            if (testClassLocation.endsWith("-tests.jar")) {
                return Path.of(new StringBuilder().append(testClassLocation, 0, testClassLocation.length() - "-tests.jar".length()).append(".jar").toString(), new String[0]);
            }
            return testClassLocationPath;
        }
        Optional<Path> mainClassesDir = TEST_TO_MAIN_DIR_FRAGMENTS.entrySet().stream().filter(e -> testClassLocation.contains((CharSequence)e.getKey())).map(e -> {
            int i = testClassLocation.lastIndexOf((String)e.getKey());
            StringBuilder buf = new StringBuilder(testClassLocation.length());
            buf.append(testClassLocation, 0, i).append((String)e.getValue());
            if (i + ((String)e.getKey()).length() + 1 < testClassLocation.length()) {
                buf.append(testClassLocation.substring(i + ((String)e.getKey()).length()));
            }
            return Path.of(buf.toString(), new String[0]);
        }).findFirst();
        Path p = null;
        if (mainClassesDir.isPresent() && Files.exists(p = mainClassesDir.get(), new LinkOption[0])) {
            return p;
        }
        p = testClassLocationPath.getParent();
        if (p != null && p.getFileName().toString().equals(TARGET) && Files.exists(p = p.resolve("classes"), new LinkOption[0])) {
            return p;
        }
        if (mainClassesDir.isPresent()) {
            return mainClassesDir.get();
        }
        throw new IllegalStateException("Unable to translate path for " + testClassLocation);
    }

    public static Path getResourcesForClassesDirOrNull(Path classesDir, String name) {
        if (!Files.isDirectory(classesDir, new LinkOption[0])) {
            return null;
        }
        Path p = classesDir.getParent();
        if (p == null) {
            return null;
        }
        if ((p = p.getParent()) == null) {
            return null;
        }
        if ((p = p.getParent()) == null) {
            return null;
        }
        if (Files.exists(p = p.resolve("resources").resolve(name), new LinkOption[0])) {
            return p;
        }
        return null;
    }

    public static boolean isTestClass(String className, ClassLoader classLoader, Path testLocation) {
        if (classLoader instanceof QuarkusClassLoader) {
            QuarkusClassLoader qcl = (QuarkusClassLoader)classLoader;
            List cpeList = qcl.getElementsWithResource(ClassLoaderHelper.fromClassNameToResourceName((String)className), false);
            if (!cpeList.isEmpty()) {
                if (cpeList.size() == 1) {
                    ClassPathElement cpe = (ClassPathElement)cpeList.get(0);
                    return cpe.isRuntime() && testLocation.equals(cpe.getRoot());
                }
                for (ClassPathElement cpe : cpeList) {
                    if (!cpe.isRuntime()) continue;
                    return cpe.getRoot().equals(testLocation);
                }
            }
            return false;
        }
        URL resource = classLoader.getResource(ClassLoaderHelper.fromClassNameToResourceName((String)className));
        if (resource == null) {
            return false;
        }
        if (Files.isDirectory(testLocation, new LinkOption[0])) {
            return resource.getProtocol().startsWith("file") && PathTestHelper.toPath(resource).startsWith(testLocation);
        }
        if (!resource.getProtocol().equals("jar")) {
            return false;
        }
        String path = resource.getPath();
        if (!path.startsWith("file:")) {
            return false;
        }
        path = path.substring(5, path.lastIndexOf(33));
        return testLocation.equals(Path.of(path, new String[0]));
    }

    private static boolean isInTestDir(Path resource) {
        String path = resource.toString();
        return TEST_DIRS.stream().anyMatch(path::contains);
    }

    private static Path toPath(URL resource) {
        return ClassPathUtils.toLocalPath((URL)resource);
    }

    public static Path getProjectBuildDir(Path projectRoot, Path testClassLocation) {
        if (!testClassLocation.startsWith(projectRoot)) {
            return projectRoot.resolve(TARGET);
        }
        return projectRoot.resolve(projectRoot.relativize(testClassLocation).getName(0));
    }

    static {
        TEST_TO_MAIN_DIR_FRAGMENTS.put("bin" + File.separator + "test", "bin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("out" + File.separator + "test", "out" + File.separator + "production");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "java" + File.separator + "native-test", "classes" + File.separator + "java" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "java" + File.separator + "test", "classes" + File.separator + "java" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "java" + File.separator + "integration-test", "classes" + File.separator + "java" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "java" + File.separator + "integrationTest", "classes" + File.separator + "java" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "java" + File.separator + "native-integrationTest", "classes" + File.separator + "java" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "java" + File.separator + "native-integration-test", "classes" + File.separator + "java" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("quarkus-app-classes-test", "quarkus-app-classes");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "kotlin" + File.separator + "native-test", "classes" + File.separator + "kotlin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "kotlin" + File.separator + "test", "classes" + File.separator + "kotlin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "kotlin" + File.separator + "integration-test", "classes" + File.separator + "kotlin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "kotlin" + File.separator + "integrationTest", "classes" + File.separator + "kotlin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "kotlin" + File.separator + "native-integrationTest", "classes" + File.separator + "kotlin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "kotlin" + File.separator + "native-integration-test", "classes" + File.separator + "kotlin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "scala" + File.separator + "native-test", "classes" + File.separator + "scala" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "scala" + File.separator + "test", "classes" + File.separator + "scala" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "scala" + File.separator + "integration-test", "classes" + File.separator + "scala" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "scala" + File.separator + "integrationTest", "classes" + File.separator + "scala" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "scala" + File.separator + "native-integrationTest", "classes" + File.separator + "scala" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "scala" + File.separator + "native-integration-test", "classes" + File.separator + "scala" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put(File.separator + "test-classes", File.separator + "classes");
        String mappings = System.getenv("TEST_TO_MAIN_MAPPINGS");
        if (mappings != null) {
            Stream.of(mappings.split(",")).filter(s -> !s.isEmpty()).forEach(s -> {
                String[] entry = s.split(":");
                if (entry.length != 2) {
                    throw new IllegalStateException("Unable to parse additional test-to-main mapping: " + s);
                }
                TEST_TO_MAIN_DIR_FRAGMENTS.put(entry[0], entry[1]);
            });
        }
        TEST_DIRS = List.of(TEST_TO_MAIN_DIR_FRAGMENTS.keySet().toArray(new String[0]));
    }
}

