/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.common.deployment;

import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Set;

@ConfigRoot(name="smallrye-openapi")
public final class SmallRyeOpenApiConfig {
    @ConfigItem(defaultValue="openapi")
    public String path;
    @ConfigItem
    public Optional<Path> storeSchemaDirectory;
    @ConfigItem(defaultValue="false")
    public boolean alwaysRunFilter;
    @ConfigItem(defaultValue="false")
    public boolean ignoreStaticDocument;
    @ConfigItem
    public Optional<List<Path>> additionalDocsDirectory;
    public Optional<SecurityScheme> securityScheme;
    @ConfigItem(defaultValue="SecurityScheme")
    public String securitySchemeName;
    @ConfigItem(defaultValue="Authentication")
    public String securitySchemeDescription;
    @ConfigItem(defaultValue="true")
    public boolean autoAddSecurityRequirement;
    @ConfigItem(defaultValue="true")
    public boolean autoAddTags;
    @ConfigItem(defaultValue="true")
    public boolean autoAddSecurity;
    @ConfigItem(defaultValue="basic")
    public String basicSecuritySchemeValue;
    @ConfigItem(defaultValue="bearer")
    public String jwtSecuritySchemeValue;
    @ConfigItem(defaultValue="JWT")
    public String jwtBearerFormat;
    @ConfigItem
    public Optional<String> oidcOpenIdConnectUrl;
    @ConfigItem
    public Optional<String> oauth2ImplicitRefreshUrl;
    @ConfigItem
    public Optional<String> oauth2ImplicitAuthorizationUrl;
    @ConfigItem
    public Optional<String> oauth2ImplicitTokenUrl;
    @ConfigItem
    public Optional<String> openApiVersion;
    @ConfigItem
    public Optional<Set<String>> servers;
    @ConfigItem
    public Optional<String> infoTitle;
    @ConfigItem
    public Optional<String> infoVersion;
    @ConfigItem
    public Optional<String> infoDescription;
    @ConfigItem
    public Optional<String> infoTermsOfService;
    @ConfigItem
    public Optional<String> infoContactEmail;
    @ConfigItem
    public Optional<String> infoContactName;
    @ConfigItem
    public Optional<String> infoContactUrl;
    @ConfigItem
    public Optional<String> infoLicenseName;
    @ConfigItem
    public Optional<String> infoLicenseUrl;
    @ConfigItem
    public Optional<OperationIdStrategy> operationIdStrategy;

    public static enum OperationIdStrategy {
        METHOD,
        CLASS_METHOD,
        PACKAGE_CLASS_METHOD;

    }

    public static enum SecurityScheme {
        basic,
        jwt,
        oidc,
        oauth2Implicit;

    }
}

