/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.faulttolerance.runtime;

import io.smallrye.faulttolerance.FaultToleranceOperationProvider;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.config.FaultToleranceMethods;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.inject.Singleton;
import org.jboss.logging.Logger;

@Singleton
@Alternative
@Priority(value=1)
public class QuarkusFaultToleranceOperationProvider
implements FaultToleranceOperationProvider {
    private static final Logger LOG = Logger.getLogger(QuarkusFaultToleranceOperationProvider.class);
    private final Map<CacheKey, FaultToleranceOperation> operationCache = new ConcurrentHashMap<CacheKey, FaultToleranceOperation>();
    private final Function<CacheKey, FaultToleranceOperation> cacheFunction = new Function<CacheKey, FaultToleranceOperation>(){

        @Override
        public FaultToleranceOperation apply(CacheKey key) {
            return QuarkusFaultToleranceOperationProvider.this.createAtRuntime(key);
        }
    };

    void init(Map<CacheKey, FaultToleranceOperation> operationCache) {
        this.operationCache.putAll(operationCache);
    }

    public FaultToleranceOperation get(Class<?> beanClass, Method method) {
        CacheKey key = new CacheKey(beanClass, method);
        FaultToleranceOperation existing = this.operationCache.get(key);
        return existing != null ? existing : this.operationCache.computeIfAbsent(key, this.cacheFunction);
    }

    private FaultToleranceOperation createAtRuntime(CacheKey key) {
        LOG.debugf("FaultToleranceOperation not found in the cache for %s creating it at runtime", (Object)key);
        return FaultToleranceOperation.create((FaultToleranceMethod)FaultToleranceMethods.create(key.beanClass, (Method)key.method));
    }

    static class CacheKey {
        private Class<?> beanClass;
        private Method method;
        private int hashCode;

        public CacheKey(Class<?> beanClass, Method method) {
            this.beanClass = beanClass;
            this.method = method;
            this.hashCode = Objects.hash(beanClass, method);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.beanClass, cacheKey.beanClass) && Objects.equals(this.method, cacheKey.method);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

