/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.faulttolerance.deployment;

import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.deployment.builditem.AnnotationProxyBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.smallrye.faulttolerance.deployment.DotNames;
import io.smallrye.common.annotation.Blocking;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.faulttolerance.api.CircuitBreakerName;
import io.smallrye.faulttolerance.api.CustomBackoff;
import io.smallrye.faulttolerance.api.ExponentialBackoff;
import io.smallrye.faulttolerance.api.FibonacciBackoff;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

final class FaultToleranceScanner {
    private final IndexView index;
    private final AnnotationStore annotationStore;
    private final AnnotationProxyBuildItem proxy;
    private final ClassOutput output;
    private final RecorderContext recorderContext;

    FaultToleranceScanner(IndexView index, AnnotationStore annotationStore, AnnotationProxyBuildItem proxy, ClassOutput output, RecorderContext recorderContext) {
        this.index = index;
        this.annotationStore = annotationStore;
        this.proxy = proxy;
        this.output = output;
        this.recorderContext = recorderContext;
    }

    boolean hasFTAnnotations(ClassInfo clazz) {
        if (this.annotationStore.hasAnyAnnotation((AnnotationTarget)clazz, DotNames.FT_ANNOTATIONS)) {
            return true;
        }
        for (MethodInfo method : clazz.methods()) {
            if (!this.annotationStore.hasAnyAnnotation((AnnotationTarget)method, DotNames.FT_ANNOTATIONS)) continue;
            return true;
        }
        DotName parentClassName = clazz.superName();
        if (parentClassName == null || parentClassName.equals((Object)DotNames.OBJECT)) {
            return false;
        }
        ClassInfo parentClass = this.index.getClassByName(parentClassName);
        if (parentClass == null) {
            return false;
        }
        return this.hasFTAnnotations(parentClass);
    }

    void forEachMethod(ClassInfo clazz, Consumer<MethodInfo> action) {
        for (MethodInfo method : clazz.methods()) {
            if (method.name().startsWith("<") || method.isSynthetic() || this.annotationStore.hasAnnotation((AnnotationTarget)method, io.quarkus.arc.processor.DotNames.NO_CLASS_INTERCEPTORS) && !this.annotationStore.hasAnyAnnotation((AnnotationTarget)method, DotNames.FT_ANNOTATIONS)) continue;
            action.accept(method);
        }
        DotName parentClassName = clazz.superName();
        if (parentClassName == null || parentClassName.equals((Object)DotNames.OBJECT)) {
            return;
        }
        ClassInfo parentClass = this.index.getClassByName(parentClassName);
        if (parentClass == null) {
            return;
        }
        this.forEachMethod(parentClass, action);
    }

    FaultToleranceMethod createFaultToleranceMethod(ClassInfo beanClass, MethodInfo method) {
        HashSet<Class<? extends Annotation>> annotationsPresentDirectly = new HashSet<Class<? extends Annotation>>();
        FaultToleranceMethod result = new FaultToleranceMethod();
        result.beanClass = this.getClassProxy(beanClass);
        result.method = this.createMethodDescriptor(method);
        result.asynchronous = this.getAnnotation(Asynchronous.class, method, beanClass, annotationsPresentDirectly);
        result.bulkhead = this.getAnnotation(Bulkhead.class, method, beanClass, annotationsPresentDirectly);
        result.circuitBreaker = this.getAnnotation(CircuitBreaker.class, method, beanClass, annotationsPresentDirectly);
        result.fallback = this.getAnnotation(Fallback.class, method, beanClass, annotationsPresentDirectly);
        result.retry = this.getAnnotation(Retry.class, method, beanClass, annotationsPresentDirectly);
        result.timeout = this.getAnnotation(Timeout.class, method, beanClass, annotationsPresentDirectly);
        result.circuitBreakerName = this.getAnnotation(CircuitBreakerName.class, method, beanClass, annotationsPresentDirectly);
        result.customBackoff = this.getAnnotation(CustomBackoff.class, method, beanClass, annotationsPresentDirectly);
        result.exponentialBackoff = this.getAnnotation(ExponentialBackoff.class, method, beanClass, annotationsPresentDirectly);
        result.fibonacciBackoff = this.getAnnotation(FibonacciBackoff.class, method, beanClass, annotationsPresentDirectly);
        result.blocking = this.getAnnotation(Blocking.class, method, beanClass, annotationsPresentDirectly);
        result.nonBlocking = this.getAnnotation(NonBlocking.class, method, beanClass, annotationsPresentDirectly);
        result.annotationsPresentDirectly = annotationsPresentDirectly;
        return result;
    }

    private MethodDescriptor createMethodDescriptor(MethodInfo method) {
        MethodDescriptor result = new MethodDescriptor();
        result.declaringClass = this.getClassProxy(method.declaringClass());
        result.name = method.name();
        result.parameterTypes = (Class[])method.parameters().stream().map(this::getClassProxy).toArray(Class[]::new);
        result.returnType = this.getClassProxy(method.returnType());
        return result;
    }

    private <A extends Annotation> A getAnnotation(Class<A> annotationType, MethodInfo method, ClassInfo beanClass, Set<Class<? extends Annotation>> directlyPresent) {
        DotName annotationName = DotName.createSimple((String)annotationType.getName());
        if (this.annotationStore.hasAnnotation((AnnotationTarget)method, annotationName)) {
            directlyPresent.add(annotationType);
            AnnotationInstance annotation = this.annotationStore.getAnnotation((AnnotationTarget)method, annotationName);
            return this.createAnnotation(annotationType, annotation);
        }
        return this.getAnnotationFromClass(annotationType, beanClass);
    }

    private <A extends Annotation> A getAnnotationFromClass(Class<A> annotationType, ClassInfo clazz) {
        DotName annotationName = DotName.createSimple((String)annotationType.getName());
        if (this.annotationStore.hasAnnotation((AnnotationTarget)clazz, annotationName)) {
            AnnotationInstance annotation = this.annotationStore.getAnnotation((AnnotationTarget)clazz, annotationName);
            return this.createAnnotation(annotationType, annotation);
        }
        DotName parentClassName = clazz.superName();
        if (parentClassName == null || parentClassName.equals((Object)DotNames.OBJECT)) {
            return null;
        }
        ClassInfo parentClass = this.index.getClassByName(parentClassName);
        if (parentClass == null) {
            return null;
        }
        return this.getAnnotationFromClass(annotationType, parentClass);
    }

    private <A extends Annotation> A createAnnotation(Class<A> annotationType, AnnotationInstance instance) {
        return (A)((Annotation)this.proxy.builder(instance, annotationType).build(this.output));
    }

    private Class<?> getClassProxy(ClassInfo clazz) {
        return this.recorderContext.classProxy(clazz.name().toString());
    }

    private Class<?> getClassProxy(Type type) {
        return this.recorderContext.classProxy(type.name().toString());
    }
}

