/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime.interceptor;

import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.RunAsUser;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusPrincipal;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.smallrye.mutiny.Uni;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.util.Set;
import java.util.concurrent.CompletionStage;

@Interceptor
@Priority(value=150)
public final class RunAsUserInterceptor {
    @Inject
    CurrentIdentityAssociation identityAssociation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    Object intercept(InvocationContext ic) throws Exception {
        Class<?> returnType = ic.getMethod().getReturnType();
        if (Uni.class.isAssignableFrom(returnType)) {
            this.configureIdentityFromAnnotation(ic);
            try {
                return ((Uni)ic.proceed()).onTermination().invoke(this::cleanIdentity);
            }
            catch (Throwable throwable) {
                this.cleanIdentity();
                throw throwable;
            }
        }
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            this.configureIdentityFromAnnotation(ic);
            try {
                return ((CompletionStage)ic.proceed()).whenComplete((item, failure) -> this.cleanIdentity());
            }
            catch (Throwable throwable) {
                this.cleanIdentity();
                throw throwable;
            }
        }
        this.configureIdentityFromAnnotation(ic);
        try {
            Object object = ic.proceed();
            return object;
        }
        finally {
            this.cleanIdentity();
        }
    }

    private void cleanIdentity() {
        try {
            this.identityAssociation.setIdentity((SecurityIdentity)null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void configureIdentityFromAnnotation(InvocationContext ic) {
        this.identityAssociation.setIdentity(RunAsUserInterceptor.createIdentity(ic));
    }

    private static SecurityIdentity createIdentity(InvocationContext ic) {
        RunAsUser runAsUser = (RunAsUser)ic.getInterceptorBinding(RunAsUser.class);
        QuarkusSecurityIdentity.Builder identityBuilder = QuarkusSecurityIdentity.builder().setPrincipal(new QuarkusPrincipal(runAsUser.user()));
        if (runAsUser.roles() != null && runAsUser.roles().length > 0) {
            identityBuilder.addRoles(Set.of(runAsUser.roles()));
        }
        return identityBuilder.build();
    }
}

