/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.runtime.devconsole;

import io.quarkus.arc.Arc;
import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.quarkus.devconsole.runtime.spi.FlashScopeUtil;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.Scheduler;
import io.quarkus.scheduler.Trigger;
import io.quarkus.scheduler.runtime.ScheduledInvoker;
import io.quarkus.scheduler.runtime.ScheduledMethodMetadata;
import io.quarkus.scheduler.runtime.SchedulerContext;
import io.quarkus.scheduler.runtime.util.SchedulerUtils;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.time.Instant;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class SchedulerDevConsoleRecorder {
    private static final Logger LOG = Logger.getLogger(SchedulerDevConsoleRecorder.class);

    public Supplier<Function<String, String>> getConfigLookup() {
        return new Supplier<Function<String, String>>(){

            @Override
            public Function<String, String> get() {
                return SchedulerUtils::lookUpPropertyValue;
            }
        };
    }

    public Handler<RoutingContext> invokeHandler() {
        final ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
        return new DevConsolePostHandler(){

            protected void handlePost(RoutingContext ctx, MultiMap form) throws Exception {
                String action = form.get("action");
                if ("pause".equals(action)) {
                    Scheduler scheduler = (Scheduler)Arc.container().instance(Scheduler.class, new Annotation[0]).get();
                    if (scheduler.isRunning()) {
                        scheduler.pause();
                        LOG.info((Object)"Scheduler paused via Dev UI");
                        this.flashMessage(ctx, "Scheduler paused");
                    }
                } else if ("resume".equals(action)) {
                    Scheduler scheduler = (Scheduler)Arc.container().instance(Scheduler.class, new Annotation[0]).get();
                    if (!scheduler.isRunning()) {
                        scheduler.resume();
                        LOG.info((Object)"Scheduler resumed via Dev UI");
                        this.flashMessage(ctx, "Scheduler resumed");
                    }
                } else if ("pauseJob".equals(action)) {
                    Scheduler scheduler = (Scheduler)Arc.container().instance(Scheduler.class, new Annotation[0]).get();
                    String identity = form.get("identity");
                    if (identity != null && !scheduler.isPaused(identity)) {
                        scheduler.pause(identity);
                        LOG.infof("Scheduler paused job with identity '%s' via Dev UI", (Object)identity);
                        this.flashMessage(ctx, "Job with identity " + identity + " paused");
                    }
                } else if ("resumeJob".equals(action)) {
                    Scheduler scheduler = (Scheduler)Arc.container().instance(Scheduler.class, new Annotation[0]).get();
                    String identity = form.get("identity");
                    if (identity != null && scheduler.isPaused(identity)) {
                        scheduler.resume(identity);
                        LOG.infof("Scheduler resumed job with identity '%s'via Dev UI", (Object)identity);
                        this.flashMessage(ctx, "Job with identity " + identity + " resumed");
                    }
                } else {
                    final String name = form.get("name");
                    final SchedulerContext context = (SchedulerContext)Arc.container().instance(SchedulerContext.class, new Annotation[0]).get();
                    for (final ScheduledMethodMetadata metadata : context.getScheduledMethods()) {
                        if (!metadata.getMethodDescription().equals(name)) continue;
                        context.getExecutor().execute(new Runnable(){

                            @Override
                            public void run() {
                                ClassLoader previousCl = Thread.currentThread().getContextClassLoader();
                                try {
                                    Thread.currentThread().setContextClassLoader(currentCl);
                                    ScheduledInvoker invoker = context.createInvoker(metadata.getInvokerClassName());
                                    invoker.invoke(new DevModeScheduledExecution());
                                    LOG.infof("Invoked scheduled method %s via Dev UI", (Object)name);
                                }
                                catch (Exception e) {
                                    LOG.error((Object)("Unable to invoke a @Scheduled method: " + metadata.getMethodDescription()), (Throwable)e);
                                }
                                finally {
                                    Thread.currentThread().setContextClassLoader(previousCl);
                                }
                            }
                        });
                        this.flashMessage(ctx, "Action invoked");
                        return;
                    }
                    this.flashMessage(ctx, "Action not found: " + name, FlashScopeUtil.FlashMessageStatus.ERROR);
                }
            }
        };
    }

    private static class DevModeScheduledExecution
    implements ScheduledExecution {
        private final Instant now = Instant.now();

        DevModeScheduledExecution() {
        }

        @Override
        public Trigger getTrigger() {
            return new Trigger(){

                @Override
                public String getId() {
                    return "dev-console";
                }

                @Override
                public Instant getNextFireTime() {
                    return null;
                }

                @Override
                public Instant getPreviousFireTime() {
                    return now;
                }
            };
        }

        @Override
        public Instant getFireTime() {
            return this.now;
        }

        @Override
        public Instant getScheduledFireTime() {
            return this.now;
        }
    }
}

