/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.runtime;

import io.quarkus.scheduler.Scheduled;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.SkippedExecution;
import io.quarkus.scheduler.runtime.ScheduledInvoker;
import javax.enterprise.event.Event;
import org.jboss.logging.Logger;

public final class SkipPredicateInvoker
implements ScheduledInvoker {
    private static final Logger LOGGER = Logger.getLogger(SkipPredicateInvoker.class);
    private final ScheduledInvoker delegate;
    private final Scheduled.SkipPredicate predicate;
    private final Event<SkippedExecution> event;

    public SkipPredicateInvoker(ScheduledInvoker delegate, Scheduled.SkipPredicate predicate, Event<SkippedExecution> event) {
        this.delegate = delegate;
        this.predicate = predicate;
        this.event = event;
    }

    public void invoke(ScheduledExecution execution) throws Exception {
        if (this.predicate.test(execution)) {
            LOGGER.debugf("Skipped scheduled invoker execution: %s", (Object)this.delegate.getClass().getName());
            SkippedExecution payload = new SkippedExecution(execution, this.predicate.getClass().getName());
            this.event.fire((Object)payload);
            this.event.fireAsync((Object)payload);
        } else {
            this.delegate.invoke(execution);
        }
    }

    public void invokeBean(ScheduledExecution param) {
        throw new UnsupportedOperationException();
    }
}

