/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler;

import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.StartupEvent;
import io.quarkus.scheduler.ScheduledExecution;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Singleton;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.TimeUnit;

@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Repeatable(value=Schedules.class)
public @interface Scheduled {
    public static final String DEFAULT_TIMEZONE = "<<default timezone>>";
    public static final String AUTO = "<<auto>>";
    public static final String SIMPLE = "SIMPLE";
    public static final String QUARTZ = "QUARTZ";

    public String identity() default "";

    public String cron() default "";

    public String every() default "";

    public long delay() default 0L;

    public TimeUnit delayUnit() default TimeUnit.MINUTES;

    public String delayed() default "";

    public ConcurrentExecution concurrentExecution() default ConcurrentExecution.PROCEED;

    public Class<? extends SkipPredicate> skipExecutionIf() default Never.class;

    public String overdueGracePeriod() default "";

    public String timeZone() default "<<default timezone>>";

    public String executeWith() default "<<auto>>";

    public String executionMaxDelay() default "";

    @Singleton
    public static class ApplicationNotRunning
    implements SkipPredicate {
        private volatile boolean running;

        void started(@Observes StartupEvent event) {
            this.running = true;
        }

        void shutdown(@Observes ShutdownEvent event) {
            this.running = false;
        }

        @Override
        public boolean test(ScheduledExecution execution) {
            return !this.running;
        }
    }

    public static class Never
    implements SkipPredicate {
        @Override
        public boolean test(ScheduledExecution execution) {
            return false;
        }
    }

    public static interface SkipPredicate {
        public boolean test(ScheduledExecution var1);
    }

    public static enum ConcurrentExecution {
        PROCEED,
        SKIP;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Schedules {
        public Scheduled[] value();
    }
}

