/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime.standalone;

import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.resteasy.runtime.standalone.BufferAllocator;
import io.quarkus.resteasy.runtime.standalone.QuarkusResteasySecurityContext;
import io.quarkus.resteasy.runtime.standalone.RequestDispatcher;
import io.quarkus.resteasy.runtime.standalone.VertxBlockingOutput;
import io.quarkus.resteasy.runtime.standalone.VertxHttpRequest;
import io.quarkus.resteasy.runtime.standalone.VertxHttpResponse;
import io.quarkus.resteasy.runtime.standalone.VertxInputStream;
import io.quarkus.resteasy.runtime.standalone.VertxOutput;
import io.quarkus.resteasy.runtime.standalone.VertxUtil;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.ws.rs.core.SecurityContext;
import org.jboss.logging.Logger;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class VertxRequestHandler
implements Handler<RoutingContext> {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.resteasy");
    protected final Vertx vertx;
    protected final RequestDispatcher dispatcher;
    protected final String rootPath;
    protected final BufferAllocator allocator;
    protected final BeanContainer beanContainer;
    protected final CurrentIdentityAssociation association;

    public VertxRequestHandler(Vertx vertx, BeanContainer beanContainer, ResteasyDeployment deployment, String rootPath, BufferAllocator allocator) {
        this.vertx = vertx;
        this.beanContainer = beanContainer;
        this.dispatcher = new RequestDispatcher((SynchronousDispatcher)deployment.getDispatcher(), deployment.getProviderFactory(), null, Thread.currentThread().getContextClassLoader());
        this.rootPath = rootPath;
        this.allocator = allocator;
        Instance association = CDI.current().select(CurrentIdentityAssociation.class, new Annotation[0]);
        this.association = association.isResolvable() ? (CurrentIdentityAssociation)association.get() : null;
    }

    public void handle(RoutingContext request) {
        VertxInputStream is;
        try {
            is = new VertxInputStream(request.request());
        }
        catch (IOException e) {
            request.fail((Throwable)e);
            return;
        }
        this.vertx.executeBlocking(event -> this.dispatchRequestContext(request, is, new VertxBlockingOutput(request.request())), false, event -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchRequestContext(RoutingContext request, InputStream is, VertxOutput output) {
        ManagedContext requestContext = this.beanContainer.requestContext();
        requestContext.activate();
        QuarkusHttpUser user = (QuarkusHttpUser)request.user();
        if (user != null && this.association != null) {
            this.association.setIdentity(user.getSecurityIdentity());
        }
        try {
            this.dispatch(request, is, output);
        }
        finally {
            requestContext.terminate();
        }
    }

    private void dispatch(RoutingContext routingContext, InputStream is, VertxOutput output) {
        try {
            Context ctx = this.vertx.getOrCreateContext();
            HttpServerRequest request = routingContext.request();
            ResteasyUriInfo uriInfo = VertxUtil.extractUriInfo(request, this.rootPath);
            ResteasyHttpHeaders headers = VertxUtil.extractHttpHeaders(request);
            HttpServerResponse response = request.response();
            VertxHttpResponse vertxResponse = new VertxHttpResponse(request, this.dispatcher.getProviderFactory(), request.method(), this.allocator, output);
            SocketAddress socketAddress = request.remoteAddress();
            String host = socketAddress != null ? socketAddress.host() : null;
            VertxHttpRequest vertxRequest = new VertxHttpRequest(ctx, headers, uriInfo, request.rawMethod(), host, this.dispatcher.getDispatcher(), vertxResponse, false);
            vertxRequest.setInputStream(is);
            try {
                ResteasyContext.pushContext(SecurityContext.class, (Object)new QuarkusResteasySecurityContext(request));
                ResteasyContext.pushContext(RoutingContext.class, (Object)routingContext);
                this.dispatcher.service(ctx, request, response, (HttpRequest)vertxRequest, vertxResponse, true);
            }
            catch (Failure e1) {
                vertxResponse.setStatus(e1.getErrorCode());
                if (e1.isLoggable()) {
                    log.error((Object)e1);
                }
            }
            catch (Throwable ex) {
                routingContext.fail(ex);
            }
            if (!vertxRequest.getAsyncContext().isSuspended()) {
                try {
                    vertxResponse.finish();
                }
                catch (IOException e) {
                    log.error((Object)"Unexpected failure", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            routingContext.fail(t);
        }
    }
}

