/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.server.common.deployment;

import io.quarkus.arc.ArcUndeclaredThrowableException;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.AutoInjectAnnotationBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.resteasy.common.deployment.JaxrsProvidersToRegisterBuildItem;
import io.quarkus.resteasy.common.deployment.ResteasyCommonProcessor;
import io.quarkus.resteasy.common.deployment.ResteasyDotNames;
import io.quarkus.resteasy.common.runtime.QuarkusInjectorFactory;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.server.common.deployment.ResteasyDeploymentBuildItem;
import io.quarkus.resteasy.server.common.deployment.ResteasyDeploymentCustomizerBuildItem;
import io.quarkus.resteasy.server.common.deployment.ResteasyServerConfigBuildItem;
import io.quarkus.resteasy.server.common.deployment.ResteasyServletMappingBuildItem;
import io.quarkus.resteasy.server.common.runtime.QuarkusResteasyDeployment;
import io.quarkus.resteasy.server.common.spi.AdditionalJaxRsResourceDefiningAnnotationBuildItem;
import io.quarkus.resteasy.server.common.spi.AdditionalJaxRsResourceMethodAnnotationsBuildItem;
import io.quarkus.resteasy.server.common.spi.AdditionalJaxRsResourceMethodParamAnnotations;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.undertow.deployment.FilterBuildItem;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.resteasy.api.validation.ResteasyConstraintViolation;
import org.jboss.resteasy.api.validation.ViolationReport;
import org.jboss.resteasy.microprofile.config.FilterConfigSource;
import org.jboss.resteasy.microprofile.config.ServletConfigSource;
import org.jboss.resteasy.microprofile.config.ServletContextConfigSource;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class ResteasyServerCommonProcessor {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.resteasy");
    private static final String JAX_RS_APPLICATION_PARAMETER_NAME = "javax.ws.rs.Application";
    private static final DotName JSONB_ANNOTATION = DotName.createSimple((String)"javax.json.bind.annotation.JsonbAnnotation");
    private static final DotName[] METHOD_ANNOTATIONS = new DotName[]{ResteasyDotNames.GET, ResteasyDotNames.HEAD, ResteasyDotNames.DELETE, ResteasyDotNames.OPTIONS, ResteasyDotNames.PATCH, ResteasyDotNames.POST, ResteasyDotNames.PUT};
    private static final DotName[] RESTEASY_PARAM_ANNOTATIONS = new DotName[]{ResteasyDotNames.RESTEASY_QUERY_PARAM, ResteasyDotNames.RESTEASY_FORM_PARAM, ResteasyDotNames.RESTEASY_COOKIE_PARAM, ResteasyDotNames.RESTEASY_PATH_PARAM, ResteasyDotNames.RESTEASY_HEADER_PARAM, ResteasyDotNames.RESTEASY_MATRIX_PARAM};
    ResteasyConfig resteasyConfig;
    ResteasyCommonProcessor.ResteasyCommonConfig commonConfig;

    @BuildStep
    NativeImageConfigBuildItem config() {
        return NativeImageConfigBuildItem.builder().addResourceBundle("messages").build();
    }

    @BuildStep
    public void build(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, BuildProducer<NativeImageProxyDefinitionBuildItem> proxyDefinition, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<RuntimeInitializedClassBuildItem> runtimeClasses, BuildProducer<BytecodeTransformerBuildItem> transformers, BuildProducer<ResteasyServerConfigBuildItem> resteasyServerConfig, BuildProducer<ResteasyDeploymentBuildItem> resteasyDeployment, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer, List<AutoInjectAnnotationBuildItem> autoInjectAnnotations, List<AdditionalJaxRsResourceDefiningAnnotationBuildItem> additionalJaxRsResourceDefiningAnnotations, List<AdditionalJaxRsResourceMethodAnnotationsBuildItem> additionalJaxRsResourceMethodAnnotations, List<AdditionalJaxRsResourceMethodParamAnnotations> additionalJaxRsResourceMethodParamAnnotations, List<ResteasyDeploymentCustomizerBuildItem> deploymentCustomizers, JaxrsProvidersToRegisterBuildItem jaxrsProvidersToRegisterBuildItem, CombinedIndexBuildItem combinedIndexBuildItem, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, Optional<ResteasyServletMappingBuildItem> resteasyServletMappingBuildItem, final CustomScopeAnnotationsBuildItem scopes) throws Exception {
        String appClass;
        String path;
        String rootPath;
        IndexView index = combinedIndexBuildItem.getIndex();
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/javax.ws.rs.client.ClientBuilder"}));
        Collection applicationPaths = index.getAnnotations(ResteasyDotNames.APPLICATION_PATH);
        if (applicationPaths.size() > 1) {
            throw ResteasyServerCommonProcessor.createMultipleApplicationsException(applicationPaths);
        }
        Collection paths = beanArchiveIndexBuildItem.getIndex().getAnnotations(ResteasyDotNames.PATH);
        HashSet additionalPaths = new HashSet();
        for (AdditionalJaxRsResourceDefiningAnnotationBuildItem annotation : additionalJaxRsResourceDefiningAnnotations) {
            additionalPaths.addAll(beanArchiveIndexBuildItem.getIndex().getAnnotations(annotation.getAnnotationClass()));
        }
        ArrayList allPaths = new ArrayList(paths);
        allPaths.addAll(additionalPaths);
        if (allPaths.isEmpty()) {
            return;
        }
        if (!applicationPaths.isEmpty()) {
            AnnotationInstance applicationPath = (AnnotationInstance)applicationPaths.iterator().next();
            rootPath = "/";
            path = applicationPath.value().asString();
            appClass = applicationPath.target().asClass().name().toString();
        } else if (resteasyServletMappingBuildItem.isPresent()) {
            rootPath = resteasyServletMappingBuildItem.get().getPath().endsWith("/*") ? resteasyServletMappingBuildItem.get().getPath().substring(0, resteasyServletMappingBuildItem.get().getPath().length() - 1) : resteasyServletMappingBuildItem.get().getPath();
            path = rootPath;
            appClass = null;
        } else {
            rootPath = this.resteasyConfig.path;
            path = this.resteasyConfig.path;
            appClass = null;
        }
        HashMap<DotName, ClassInfo> scannedResources = new HashMap<DotName, ClassInfo>();
        HashSet<DotName> pathInterfaces = new HashSet<DotName>();
        HashMap<DotName, ClassInfo> withoutDefaultCtor = new HashMap<DotName, ClassInfo>();
        for (AnnotationInstance annotationInstance : allPaths) {
            if (annotationInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            ClassInfo clazz = annotationInstance.target().asClass();
            if (!Modifier.isInterface(clazz.flags())) {
                if (withoutDefaultCtor.containsKey(clazz.name())) continue;
                Iterator<ResteasyDeploymentCustomizerBuildItem> className = clazz.name().toString();
                if (!additionalPaths.contains(annotationInstance)) {
                    scannedResources.putIfAbsent(clazz.name(), clazz);
                }
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{className}));
                if (clazz.hasNoArgsConstructor()) continue;
                withoutDefaultCtor.put(clazz.name(), clazz);
                continue;
            }
            pathInterfaces.add(clazz.name());
        }
        for (DotName dotName : pathInterfaces) {
            Collection implementors = index.getAllKnownImplementors(dotName);
            for (ClassInfo implementor : implementors) {
                String className = implementor.name().toString();
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{className}));
                scannedResources.putIfAbsent(implementor.name(), implementor);
                if (implementor.hasNoArgsConstructor()) continue;
                withoutDefaultCtor.put(implementor.name(), implementor);
            }
        }
        final Set<DotName> subresources = this.findSubresources(beanArchiveIndexBuildItem.getIndex(), scannedResources);
        if (!subresources.isEmpty()) {
            for (DotName locator : subresources) {
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{locator.toString()}));
            }
            unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassNamesExclusion(subresources.stream().map(Object::toString).collect(Collectors.toSet()))));
        }
        ResteasyServerCommonProcessor.generateDefaultConstructors(transformers, withoutDefaultCtor, additionalJaxRsResourceDefiningAnnotations);
        ResteasyServerCommonProcessor.checkParameterNames(beanArchiveIndexBuildItem.getIndex(), additionalJaxRsResourceMethodParamAnnotations);
        ResteasyServerCommonProcessor.registerContextProxyDefinitions(beanArchiveIndexBuildItem.getIndex(), proxyDefinition);
        ResteasyServerCommonProcessor.registerReflectionForSerialization(reflectiveClass, reflectiveHierarchy, combinedIndexBuildItem, beanArchiveIndexBuildItem, additionalJaxRsResourceMethodAnnotations);
        for (ClassInfo implementation : index.getAllKnownImplementors(ResteasyDotNames.DYNAMIC_FEATURE)) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{implementation.name().toString()}));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        QuarkusResteasyDeployment deployment = new QuarkusResteasyDeployment();
        ResteasyServerCommonProcessor.registerProviders((ResteasyDeployment)deployment, hashMap, reflectiveClass, unremovableBeans, jaxrsProvidersToRegisterBuildItem);
        if (!scannedResources.isEmpty()) {
            deployment.getScannedResourceClasses().addAll(scannedResources.keySet().stream().map(Object::toString).collect(Collectors.toList()));
            hashMap.put("resteasy.scanned.resources", scannedResources.keySet().stream().map(Object::toString).collect(Collectors.joining(",")));
        }
        hashMap.put("resteasy.servlet.mapping.prefix", path);
        if (appClass != null) {
            deployment.setApplicationClass(appClass);
            hashMap.put(JAX_RS_APPLICATION_PARAMETER_NAME, appClass);
        }
        hashMap.put("resteasy.injector.factory", QuarkusInjectorFactory.class.getName());
        deployment.setInjectorFactoryClass(QuarkusInjectorFactory.class.getName());
        for (ResteasyDeploymentCustomizerBuildItem deploymentCustomizer : deploymentCustomizers) {
            deploymentCustomizer.getConsumer().accept((ResteasyDeployment)deployment);
        }
        if (this.commonConfig.gzip.enabled) {
            hashMap.put("resteasy.gzip.max.input", Long.toString(this.commonConfig.gzip.maxInput.asLongValue()));
        }
        hashMap.put("resteasy.unwrapped.exceptions", ArcUndeclaredThrowableException.class.getName());
        resteasyServerConfig.produce((BuildItem)new ResteasyServerConfigBuildItem(rootPath, path, hashMap));
        final Set autoInjectAnnotationNames = autoInjectAnnotations.stream().flatMap(a -> a.getAnnotationNames().stream()).collect(Collectors.toSet());
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                ClassInfo clazz = context.getTarget().asClass();
                if (clazz.classAnnotation(ResteasyDotNames.PATH) != null) {
                    if (clazz.classAnnotation(DotNames.TYPED) == null) {
                        ((Transformation)context.transform().add(ResteasyServerCommonProcessor.this.createTypedAnnotationInstance(clazz))).done();
                    }
                    return;
                }
                if (scopes.isScopeIn(context.getAnnotations())) {
                    return;
                }
                if (clazz.classAnnotation(ResteasyDotNames.PROVIDER) != null) {
                    Transformation transformation = null;
                    if (clazz.annotations().containsKey(DotNames.INJECT) || ResteasyServerCommonProcessor.this.hasAutoInjectAnnotation(autoInjectAnnotationNames, clazz)) {
                        transformation = (Transformation)context.transform().add(BuiltinScope.SINGLETON.getName(), new AnnotationValue[0]);
                    }
                    if (clazz.classAnnotation(DotNames.TYPED) == null) {
                        if (transformation == null) {
                            transformation = context.transform();
                        }
                        transformation.add(ResteasyServerCommonProcessor.this.createTypedAnnotationInstance(clazz));
                    }
                    if (transformation != null) {
                        transformation.done();
                    }
                } else if (subresources.contains(clazz.name())) {
                    Transformation transformation = (Transformation)context.transform().add(ResteasyServerCommonProcessor.this.resteasyConfig.singletonResources ? BuiltinScope.SINGLETON.getName() : BuiltinScope.DEPENDENT.getName(), new AnnotationValue[0]);
                    if (clazz.classAnnotation(DotNames.TYPED) == null) {
                        transformation.add(ResteasyServerCommonProcessor.this.createTypedAnnotationInstance(clazz));
                    }
                    transformation.done();
                }
            }
        }));
        resteasyDeployment.produce((BuildItem)new ResteasyDeploymentBuildItem(path, (ResteasyDeployment)deployment));
    }

    @BuildStep
    void processPathInterfaceImplementors(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, BuildProducer<AdditionalBeanBuildItem> additionalBeans, CustomScopeAnnotationsBuildItem scopes) {
        IndexView index = combinedIndexBuildItem.getIndex();
        HashSet<DotName> pathInterfaces = new HashSet<DotName>();
        for (Object annotation : index.getAnnotations(ResteasyDotNames.PATH)) {
            if (annotation.target().kind() != AnnotationTarget.Kind.CLASS || !Modifier.isInterface(annotation.target().asClass().flags())) continue;
            pathInterfaces.add(annotation.target().asClass().name());
        }
        if (pathInterfaces.isEmpty()) {
            return;
        }
        HashMap<DotName, ClassInfo> pathInterfaceImplementors = new HashMap<DotName, ClassInfo>();
        for (DotName iface : pathInterfaces) {
            for (ClassInfo implementor : index.getAllKnownImplementors(iface)) {
                if (pathInterfaceImplementors.containsKey(implementor.name())) continue;
                pathInterfaceImplementors.put(implementor.name(), implementor);
            }
        }
        if (!pathInterfaceImplementors.isEmpty()) {
            AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder().setDefaultScope(this.resteasyConfig.singletonResources ? BuiltinScope.SINGLETON.getName() : null).setUnremovable();
            for (Map.Entry implementor : pathInterfaceImplementors.entrySet()) {
                if (scopes.isScopeDeclaredOn((ClassInfo)implementor.getValue())) {
                    unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassNameExclusion(((DotName)implementor.getKey()).toString())));
                    continue;
                }
                builder.addBeanClass(((DotName)implementor.getKey()).toString());
            }
            additionalBeans.produce((BuildItem)builder.build());
        }
    }

    @BuildStep
    void beanDefiningAnnotations(BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotations) {
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(ResteasyDotNames.PATH, this.resteasyConfig.singletonResources ? BuiltinScope.SINGLETON.getName() : null));
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(ResteasyDotNames.APPLICATION_PATH, BuiltinScope.SINGLETON.getName()));
    }

    @BuildStep
    void enableMetrics(ResteasyConfig buildConfig, BuildProducer<ResteasyJaxrsProviderBuildItem> jaxRsProviders, BuildProducer<FilterBuildItem> servletFilters, Capabilities capabilities) {
        if (buildConfig.metricsEnabled && capabilities.isPresent(Capability.METRICS)) {
            if (capabilities.isPresent(Capability.SERVLET)) {
                jaxRsProviders.produce((BuildItem)new ResteasyJaxrsProviderBuildItem("io.smallrye.metrics.jaxrs.JaxRsMetricsFilter"));
                servletFilters.produce((BuildItem)FilterBuildItem.builder((String)"metricsFilter", (String)"io.smallrye.metrics.jaxrs.JaxRsMetricsServletFilter").setAsyncSupported(true).addFilterUrlMapping("*", DispatcherType.FORWARD).addFilterUrlMapping("*", DispatcherType.INCLUDE).addFilterUrlMapping("*", DispatcherType.REQUEST).addFilterUrlMapping("*", DispatcherType.ASYNC).addFilterUrlMapping("*", DispatcherType.ERROR).build());
            } else {
                jaxRsProviders.produce((BuildItem)new ResteasyJaxrsProviderBuildItem("io.quarkus.smallrye.metrics.runtime.QuarkusJaxRsMetricsFilter"));
            }
        }
    }

    private boolean hasAutoInjectAnnotation(Set<DotName> autoInjectAnnotationNames, ClassInfo clazz) {
        for (DotName name : autoInjectAnnotationNames) {
            List instances = (List)clazz.annotations().get(name);
            if (instances == null) continue;
            for (AnnotationInstance instance : instances) {
                if (instance.target().kind() != AnnotationTarget.Kind.FIELD) continue;
                return true;
            }
        }
        return false;
    }

    private AnnotationInstance createTypedAnnotationInstance(ClassInfo clazz) {
        return AnnotationInstance.create((DotName)DotNames.TYPED, (AnnotationTarget)clazz, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createArrayValue((String)"value", (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createClassValue((String)"value", (Type)Type.create((DotName)clazz.name(), (Type.Kind)Type.Kind.CLASS))})});
    }

    private Set<DotName> findSubresources(IndexView index, Map<DotName, ClassInfo> scannedResources) {
        HashSet<DotName> subresources = new HashSet<DotName>();
        for (DotName annotation : METHOD_ANNOTATIONS) {
            Collection annotationInstances = index.getAnnotations(annotation);
            Iterator iterator = annotationInstances.iterator();
            while (iterator.hasNext()) {
                AnnotationInstance annotationInstance = (AnnotationInstance)iterator.next();
                DotName declaringClassName = annotationInstance.target().asMethod().declaringClass().name();
                if (scannedResources.containsKey(declaringClassName)) continue;
                subresources.add(declaringClassName);
            }
        }
        if (!subresources.isEmpty()) {
            HashSet<DotName> subresourceLocatorTypes = new HashSet<DotName>();
            Iterator<ClassInfo> iterator = scannedResources.values().iterator();
            while (iterator.hasNext()) {
                ClassInfo resourceClass;
                ClassInfo clazz = resourceClass = iterator.next();
                while (clazz != null) {
                    for (MethodInfo method : clazz.methods()) {
                        if (!method.hasAnnotation(ResteasyDotNames.PATH)) continue;
                        subresourceLocatorTypes.add(method.returnType().name());
                    }
                    if (clazz.superName().equals((Object)DotNames.OBJECT)) {
                        clazz = null;
                        continue;
                    }
                    clazz = index.getClassByName(clazz.superName());
                }
            }
            Iterator iterator2 = subresources.iterator();
            block5: while (iterator2.hasNext()) {
                DotName subresource = (DotName)iterator2.next();
                for (DotName type : subresourceLocatorTypes) {
                    if (subresource.equals((Object)type) || !index.getAllKnownSubclasses(type).stream().noneMatch(c -> c.name().equals((Object)subresource))) continue;
                    iterator2.remove();
                    continue block5;
                }
            }
        }
        log.trace((Object)("Sub-resources found: " + subresources));
        return subresources;
    }

    private static void registerProviders(ResteasyDeployment deployment, Map<String, String> resteasyInitParameters, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, JaxrsProvidersToRegisterBuildItem jaxrsProvidersToRegisterBuildItem) {
        if (jaxrsProvidersToRegisterBuildItem.useBuiltIn()) {
            resteasyInitParameters.put("resteasy.use.builtin.providers", "true");
            deployment.setRegisterBuiltin(true);
            if (!jaxrsProvidersToRegisterBuildItem.getContributedProviders().isEmpty()) {
                deployment.getProviderClasses().addAll(jaxrsProvidersToRegisterBuildItem.getContributedProviders());
                resteasyInitParameters.put("resteasy.providers", String.join((CharSequence)",", jaxrsProvidersToRegisterBuildItem.getContributedProviders()));
            }
        } else {
            deployment.setRegisterBuiltin(false);
            deployment.getProviderClasses().addAll(jaxrsProvidersToRegisterBuildItem.getProviders());
            resteasyInitParameters.put("resteasy.use.builtin.providers", "false");
            resteasyInitParameters.put("resteasy.providers", String.join((CharSequence)",", jaxrsProvidersToRegisterBuildItem.getProviders()));
        }
        for (String providerToRegister : jaxrsProvidersToRegisterBuildItem.getProviders()) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{providerToRegister}));
        }
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{ServletConfigSource.class, ServletContextConfigSource.class, FilterConfigSource.class}));
        unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem(b -> jaxrsProvidersToRegisterBuildItem.getProviders().contains(b.getBeanClass().toString())));
    }

    private static void generateDefaultConstructors(BuildProducer<BytecodeTransformerBuildItem> transformers, Map<DotName, ClassInfo> withoutDefaultCtor, List<AdditionalJaxRsResourceDefiningAnnotationBuildItem> additionalJaxRsResourceDefiningAnnotations) {
        HashSet<String> allowedAnnotationPrefixes = new HashSet<String>(1 + additionalJaxRsResourceDefiningAnnotations.size());
        allowedAnnotationPrefixes.add(ResteasyServerCommonProcessor.packageName(ResteasyDotNames.PATH));
        allowedAnnotationPrefixes.add("kotlin");
        allowedAnnotationPrefixes.add("lombok");
        allowedAnnotationPrefixes.add("io.quarkus.security");
        allowedAnnotationPrefixes.add("javax.annotation.security");
        allowedAnnotationPrefixes.add("jakarta.annotation.security");
        for (AdditionalJaxRsResourceDefiningAnnotationBuildItem additionalJaxRsResourceDefiningAnnotationBuildItem : additionalJaxRsResourceDefiningAnnotations) {
            String packageName = ResteasyServerCommonProcessor.packageName(additionalJaxRsResourceDefiningAnnotationBuildItem.getAnnotationClass());
            if (packageName == null) continue;
            allowedAnnotationPrefixes.add(packageName);
        }
        for (Map.Entry entry : withoutDefaultCtor.entrySet()) {
            ClassInfo classInfo = (ClassInfo)entry.getValue();
            if (classInfo.superClassType() == null || !classInfo.superClassType().name().equals((Object)DotNames.OBJECT)) {
                return;
            }
            boolean hasNonJaxRSAnnotations = false;
            for (AnnotationInstance instance : classInfo.classAnnotations()) {
                String packageName = ResteasyServerCommonProcessor.packageName(instance.name());
                if (packageName != null && allowedAnnotationPrefixes.contains(packageName)) continue;
                hasNonJaxRSAnnotations = true;
                break;
            }
            if (hasNonJaxRSAnnotations) continue;
            String name = classInfo.name().toString();
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(true, name, (BiFunction)new BiFunction<String, ClassVisitor, ClassVisitor>(){

                @Override
                public ClassVisitor apply(String className, ClassVisitor classVisitor) {
                    ClassVisitor cv = new ClassVisitor(524288, classVisitor){

                        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                            super.visit(version, access, name, signature, superName, interfaces);
                            MethodVisitor ctor = this.visitMethod(1, "<init>", "()V", null, null);
                            ctor.visitCode();
                            ctor.visitVarInsn(25, 0);
                            ctor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
                            ctor.visitInsn(177);
                            ctor.visitMaxs(1, 1);
                            ctor.visitEnd();
                        }
                    };
                    return cv;
                }
            }));
        }
    }

    private static String packageName(DotName dotName) {
        String className = dotName.toString();
        int index = className.lastIndexOf(46);
        if (index > 0 && index < className.length() - 1) {
            return className.substring(0, index);
        }
        return null;
    }

    private static void checkParameterNames(IndexView index, List<AdditionalJaxRsResourceMethodParamAnnotations> additionalJaxRsResourceMethodParamAnnotations) {
        ArrayList<DotName> methodParameterAnnotations = new ArrayList<DotName>(RESTEASY_PARAM_ANNOTATIONS.length);
        methodParameterAnnotations.addAll(Arrays.asList(RESTEASY_PARAM_ANNOTATIONS));
        for (AdditionalJaxRsResourceMethodParamAnnotations annotations : additionalJaxRsResourceMethodParamAnnotations) {
            methodParameterAnnotations.addAll(annotations.getAnnotationClasses());
        }
        block1: for (DotName annotationType : methodParameterAnnotations) {
            Collection instances = index.getAnnotations(annotationType);
            for (AnnotationInstance instance : instances) {
                MethodParameterInfo param;
                if (instance.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER || (param = instance.target().asMethodParameter()).name() != null) continue;
                log.warnv("Detected RESTEasy annotation {0} on method parameter {1}.{2} with no name. Either specify its name, or tell your compiler to enable debug info (-g) or parameter names (-parameters). This message is only logged for the first such parameter.", (Object)instance.name(), (Object)param.method().declaringClass(), (Object)param.method().name());
                break block1;
            }
        }
    }

    private static void registerContextProxyDefinitions(IndexView index, BuildProducer<NativeImageProxyDefinitionBuildItem> proxyDefinition) {
        for (AnnotationInstance annotation : index.getAnnotations(ResteasyDotNames.CONTEXT)) {
            Type annotatedType = null;
            if (annotation.target().kind() == AnnotationTarget.Kind.METHOD) {
                MethodInfo method = annotation.target().asMethod();
                if (method.parameters().size() == 1) {
                    annotatedType = (Type)method.parameters().get(0);
                }
            } else if (annotation.target().kind() == AnnotationTarget.Kind.FIELD) {
                annotatedType = annotation.target().asField().type();
            } else if (annotation.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
                short pos = annotation.target().asMethodParameter().position();
                annotatedType = (Type)annotation.target().asMethodParameter().method().parameters().get(pos);
            }
            if (annotatedType == null || annotatedType.kind() == Type.Kind.PRIMITIVE) continue;
            ClassInfo type = index.getClassByName(annotatedType.name());
            if (type != null) {
                if (!Modifier.isInterface(type.flags())) continue;
                proxyDefinition.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{type.toString()}));
                continue;
            }
            try {
                Class<?> typeClass = Class.forName(annotatedType.name().toString());
                if (!typeClass.isInterface()) continue;
                proxyDefinition.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{annotatedType.name().toString()}));
            }
            catch (Exception exception) {}
        }
    }

    private static void registerReflectionForSerialization(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, CombinedIndexBuildItem combinedIndexBuildItem, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, List<AdditionalJaxRsResourceMethodAnnotationsBuildItem> additionalJaxRsResourceMethodAnnotations) {
        IndexView index = combinedIndexBuildItem.getIndex();
        IndexView beanArchiveIndex = beanArchiveIndexBuildItem.getIndex();
        for (AnnotationInstance annotation : index.getAnnotations(JSONB_ANNOTATION)) {
            if (annotation.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{annotation.target().asClass().name().toString()}));
        }
        ArrayList<DotName> annotations = new ArrayList<DotName>(METHOD_ANNOTATIONS.length);
        annotations.addAll(Arrays.asList(METHOD_ANNOTATIONS));
        for (AdditionalJaxRsResourceMethodAnnotationsBuildItem additionalJaxRsResourceMethodAnnotation : additionalJaxRsResourceMethodAnnotations) {
            annotations.addAll(additionalJaxRsResourceMethodAnnotation.getAnnotationClasses());
        }
        for (DotName annotationType : annotations) {
            HashSet<AnnotationInstance> processedAnnotations = new HashSet<AnnotationInstance>();
            ResteasyServerCommonProcessor.scanMethods(annotationType, reflectiveHierarchy, beanArchiveIndex, processedAnnotations);
            ResteasyServerCommonProcessor.scanMethods(annotationType, reflectiveHierarchy, index, processedAnnotations);
        }
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{ViolationReport.class.getName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{ResteasyConstraintViolation.class.getName()}));
    }

    private static void scanMethods(DotName annotationType, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, IndexView index, Set<AnnotationInstance> processedAnnotations) {
        Collection instances = index.getAnnotations(annotationType);
        for (AnnotationInstance instance : instances) {
            if (instance.target().kind() != AnnotationTarget.Kind.METHOD || processedAnnotations.contains(instance)) continue;
            processedAnnotations.add(instance);
            MethodInfo method = instance.target().asMethod();
            String source = method.declaringClass() + "[" + method + "]";
            reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem(method.returnType(), index, (Predicate)ResteasyDotNames.IGNORE_FOR_REFLECTION_PREDICATE, source));
            for (short i = 0; i < method.parameters().size(); i = (short)(i + 1)) {
                Type parameterType = (Type)method.parameters().get(i);
                if (ResteasyServerCommonProcessor.hasAnnotation(method, i, ResteasyDotNames.CONTEXT)) continue;
                reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem(parameterType, index, (Predicate)ResteasyDotNames.IGNORE_FOR_REFLECTION_PREDICATE, source));
            }
        }
    }

    private static boolean hasAnnotation(MethodInfo method, short paramPosition, DotName annotation) {
        for (AnnotationInstance annotationInstance : method.annotations()) {
            AnnotationTarget target = annotationInstance.target();
            if (target == null || target.kind() != AnnotationTarget.Kind.METHOD_PARAMETER || target.asMethodParameter().position() != paramPosition || !annotationInstance.name().equals((Object)annotation)) continue;
            return true;
        }
        return false;
    }

    private static RuntimeException createMultipleApplicationsException(Collection<AnnotationInstance> applicationPaths) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (AnnotationInstance annotationInstance : applicationPaths) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(annotationInstance.target().asClass().name().toString());
        }
        return new RuntimeException("Multiple classes ( " + sb.toString() + ") have been annotated with @ApplicationPath which is currently not supported");
    }

    @ConfigRoot(phase=ConfigPhase.BUILD_TIME)
    static final class ResteasyConfig {
        @ConfigItem(defaultValue="true")
        boolean singletonResources;
        @ConfigItem(defaultValue="/")
        String path;
        @ConfigItem(name="metrics.enabled", defaultValue="false")
        public boolean metricsEnabled;

        ResteasyConfig() {
        }
    }
}

