/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime;

import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.ext.web.RoutingContext;
import java.security.Principal;
import javax.ws.rs.core.SecurityContext;

public class ResteasyReactiveSecurityContext
implements SecurityContext {
    private final RoutingContext routingContext;

    public ResteasyReactiveSecurityContext(RoutingContext routingContext) {
        this.routingContext = routingContext;
    }

    public Principal getUserPrincipal() {
        QuarkusHttpUser user = (QuarkusHttpUser)this.routingContext.user();
        if (user == null || user.getSecurityIdentity().isAnonymous()) {
            return null;
        }
        return user.getSecurityIdentity().getPrincipal();
    }

    public boolean isUserInRole(String role) {
        SecurityIdentity user = CurrentIdentityAssociation.current();
        if (role.equals("**")) {
            return !user.isAnonymous();
        }
        return user.hasRole(role);
    }

    public boolean isSecure() {
        return this.routingContext.request().isSSL();
    }

    public String getAuthenticationScheme() {
        String authorizationValue = this.routingContext.request().getHeader("Authorization");
        if (authorizationValue == null) {
            return null;
        }
        return authorizationValue.split(" ")[0].trim();
    }
}

