/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime.exceptionmappers;

import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.ws.rs.core.Response;
import java.util.function.Function;
import org.jboss.resteasy.reactive.server.exceptionmappers.AsyncExceptionMappingUtil;

final class SecurityExceptionMapperUtil {
    private SecurityExceptionMapperUtil() {
    }

    static Uni<Response> handleWithAuthenticator(RoutingContext routingContext, final String exceptionMessage) {
        HttpAuthenticator authenticator = (HttpAuthenticator)routingContext.get(HttpAuthenticator.class.getName());
        if (authenticator != null) {
            Uni challenge = authenticator.getChallenge(routingContext);
            return challenge.map((Function)new Function<ChallengeData, Response>(){

                @Override
                public Response apply(ChallengeData challengeData) {
                    if (challengeData == null) {
                        return exceptionMessage != null ? SecurityExceptionMapperUtil.createResponse(exceptionMessage) : AsyncExceptionMappingUtil.DEFAULT_UNAUTHORIZED_RESPONSE;
                    }
                    Response.ResponseBuilder responseBuilder = Response.status((int)challengeData.status);
                    if (challengeData.headerName != null) {
                        responseBuilder.header(challengeData.headerName.toString(), (Object)challengeData.headerContent);
                    }
                    if (exceptionMessage != null && challengeData.status == 401) {
                        responseBuilder.entity((Object)exceptionMessage);
                    }
                    return responseBuilder.build();
                }
            }).onFailure().recoverWithItem((Object)(exceptionMessage != null ? SecurityExceptionMapperUtil.createResponse(exceptionMessage) : AsyncExceptionMappingUtil.DEFAULT_UNAUTHORIZED_RESPONSE));
        }
        return Uni.createFrom().item((Object)(exceptionMessage != null ? SecurityExceptionMapperUtil.createResponse(exceptionMessage) : AsyncExceptionMappingUtil.DEFAULT_UNAUTHORIZED_RESPONSE));
    }

    private static Response createResponse(String responseBody) {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)responseBody).build();
    }
}

