/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.restclient.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.restclient.config.RestClientConfig;
import io.quarkus.restclient.config.RestClientsConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.ext.QueryParamStyle;

public class RestClientBase {
    public static final String QUARKUS_CONFIG_REST_URL_FORMAT = "quarkus.rest-config.\"%s\".url";
    public static final String QUARKUS_CONFIG_REST_URI_FORMAT = "quarkus.rest-config.\"%s\".uri";
    private final Class<?> proxyType;
    private final String baseUriFromAnnotation;
    private final Class<?>[] annotationProviders;
    private final RestClientsConfig configRoot;
    private final String configKey;

    public RestClientBase(Class<?> proxyType, String baseUriFromAnnotation, String configKey, Class<?>[] annotationProviders) {
        this(proxyType, baseUriFromAnnotation, configKey, annotationProviders, RestClientBase.getConfigRoot());
    }

    RestClientBase(Class<?> proxyType, String baseUriFromAnnotation, String configKey, Class<?>[] annotationProviders, RestClientsConfig configRoot) {
        this.proxyType = proxyType;
        this.baseUriFromAnnotation = baseUriFromAnnotation;
        this.configKey = configKey;
        this.annotationProviders = annotationProviders;
        this.configRoot = configRoot;
    }

    public Object create() {
        RestClientBuilder builder = RestClientBuilder.newBuilder();
        this.configureBaseUrl(builder);
        this.configureTimeouts(builder);
        this.configureProviders(builder);
        this.configureSsl(builder);
        this.configureProxy(builder);
        this.configureRedirects(builder);
        this.configureQueryParamStyle(builder);
        this.configureCustomProperties(builder);
        InstanceHandle managedExecutor = Arc.container().instance(ManagedExecutor.class, new Annotation[0]);
        if (managedExecutor.isAvailable()) {
            builder.executorService((ExecutorService)managedExecutor.get());
        }
        return builder.build(this.proxyType);
    }

    void configureCustomProperties(RestClientBuilder builder) {
        Optional connectionTTL;
        Optional connectionPoolSize = RestClientBase.oneOf(this.clientConfigByClassName().connectionPoolSize, this.clientConfigByConfigKey().connectionPoolSize);
        if (connectionPoolSize.isPresent()) {
            builder.property("resteasy.connectionPoolSize", connectionPoolSize.get());
        }
        if ((connectionTTL = RestClientBase.oneOf(this.clientConfigByClassName().connectionTTL, this.clientConfigByConfigKey().connectionTTL)).isPresent()) {
            builder.property("resteasy.connectionTTL", Arrays.asList(new Serializable[]{(Serializable)connectionTTL.get(), TimeUnit.MILLISECONDS}));
        }
    }

    void configureProxy(RestClientBuilder builder) {
        Optional proxyAddress = RestClientBase.oneOf(this.clientConfigByClassName().proxyAddress, this.clientConfigByConfigKey().proxyAddress);
        if (proxyAddress.isPresent()) {
            int port;
            String proxyString = (String)proxyAddress.get();
            int lastColonIndex = proxyString.lastIndexOf(58);
            if (lastColonIndex <= 0 || lastColonIndex == proxyString.length() - 1) {
                throw new RuntimeException("Invalid proxy string. Expected <hostname>:<port>, found '" + proxyString + "'");
            }
            String host = proxyString.substring(0, lastColonIndex);
            try {
                port = Integer.parseInt(proxyString.substring(lastColonIndex + 1));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Invalid proxy setting. The port is not a number in '" + proxyString + "'", e);
            }
            builder.proxyAddress(host, port);
        }
    }

    void configureRedirects(RestClientBuilder builder) {
        Optional followRedirects = RestClientBase.oneOf(this.clientConfigByClassName().followRedirects, this.clientConfigByConfigKey().followRedirects);
        if (followRedirects.isPresent()) {
            builder.followRedirects(((Boolean)followRedirects.get()).booleanValue());
        }
    }

    void configureQueryParamStyle(RestClientBuilder builder) {
        Optional queryParamStyle = RestClientBase.oneOf(this.clientConfigByClassName().queryParamStyle, this.clientConfigByConfigKey().queryParamStyle);
        if (queryParamStyle.isPresent()) {
            builder.queryParamStyle((QueryParamStyle)queryParamStyle.get());
        }
    }

    void configureSsl(RestClientBuilder builder) {
        Optional hostnameVerifier;
        Optional keyStore;
        Optional trustStore = RestClientBase.oneOf(this.clientConfigByClassName().trustStore, this.clientConfigByConfigKey().trustStore);
        if (trustStore.isPresent()) {
            this.registerTrustStore((String)trustStore.get(), builder);
        }
        if ((keyStore = RestClientBase.oneOf(this.clientConfigByClassName().keyStore, this.clientConfigByConfigKey().keyStore)).isPresent()) {
            this.registerKeyStore((String)keyStore.get(), builder);
        }
        if ((hostnameVerifier = RestClientBase.oneOf(this.clientConfigByClassName().hostnameVerifier, this.clientConfigByConfigKey().hostnameVerifier)).isPresent()) {
            this.registerHostnameVerifier((String)hostnameVerifier.get(), builder);
        }
    }

    private void registerHostnameVerifier(String verifier, RestClientBuilder builder) {
        try {
            Class<?> verifierClass = Thread.currentThread().getContextClassLoader().loadClass(verifier);
            builder.hostnameVerifier((HostnameVerifier)verifierClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not find a public, no-argument constructor for the hostname verifier class " + verifier, e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find hostname verifier class " + verifier, e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate hostname verifier class " + verifier + ". Make sure it has a public, no-argument constructor", e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("The provided hostname verifier " + verifier + " is not an instance of HostnameVerifier", e);
        }
    }

    private void registerKeyStore(String keyStorePath, RestClientBuilder builder) {
        try {
            Optional<String> keyStoreType = RestClientBase.oneOf(this.clientConfigByClassName().keyStoreType, this.clientConfigByConfigKey().keyStoreType);
            KeyStore keyStore = KeyStore.getInstance(keyStoreType.orElse("JKS"));
            Optional keyStorePassword = RestClientBase.oneOf(this.clientConfigByClassName().keyStorePassword, this.clientConfigByConfigKey().keyStorePassword);
            if (keyStorePassword.isEmpty()) {
                throw new IllegalArgumentException("No password provided for keystore");
            }
            String password = (String)keyStorePassword.get();
            try (InputStream input = this.locateStream(keyStorePath);){
                keyStore.load(input, password.toCharArray());
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                throw new IllegalArgumentException("Failed to initialize trust store from classpath resource " + keyStorePath, e);
            }
            builder.keyStore(keyStore, password);
        }
        catch (KeyStoreException e) {
            throw new IllegalArgumentException("Failed to initialize trust store from " + keyStorePath, e);
        }
    }

    private void registerTrustStore(String trustStorePath, RestClientBuilder builder) {
        try {
            Optional<String> trustStoreType = RestClientBase.oneOf(this.clientConfigByClassName().trustStoreType, this.clientConfigByConfigKey().trustStoreType);
            KeyStore trustStore = KeyStore.getInstance(trustStoreType.orElse("JKS"));
            Optional trustStorePassword = RestClientBase.oneOf(this.clientConfigByClassName().trustStorePassword, this.clientConfigByConfigKey().trustStorePassword);
            if (trustStorePassword.isEmpty()) {
                throw new IllegalArgumentException("No password provided for truststore");
            }
            String password = (String)trustStorePassword.get();
            try (InputStream input = this.locateStream(trustStorePath);){
                trustStore.load(input, password.toCharArray());
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                throw new IllegalArgumentException("Failed to initialize trust store from classpath resource " + trustStorePath, e);
            }
            builder.trustStore(trustStore);
        }
        catch (KeyStoreException e) {
            throw new IllegalArgumentException("Failed to initialize trust store from " + trustStorePath, e);
        }
    }

    private InputStream locateStream(String path) throws FileNotFoundException {
        File certificateFile;
        if (path.startsWith("classpath:")) {
            path = path.replaceFirst("classpath:", "");
            InputStream resultStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            if (resultStream == null) {
                resultStream = this.getClass().getResourceAsStream(path);
            }
            if (resultStream == null) {
                throw new IllegalArgumentException("Classpath resource " + path + " not found for MicroProfile Rest Client SSL configuration");
            }
            return resultStream;
        }
        if (path.startsWith("file:")) {
            path = path.replaceFirst("file:", "");
        }
        if (!(certificateFile = new File(path)).isFile()) {
            throw new IllegalArgumentException("Certificate file: " + path + " not found for MicroProfile Rest Client SSL configuration");
        }
        return new FileInputStream(certificateFile);
    }

    void configureProviders(RestClientBuilder builder) {
        Optional providers = RestClientBase.oneOf(this.clientConfigByClassName().providers, this.clientConfigByConfigKey().providers);
        if (providers.isPresent()) {
            this.registerProviders(builder, (String)providers.get());
        }
        if (this.annotationProviders != null) {
            for (Class<?> annotationProvider : this.annotationProviders) {
                builder.register(annotationProvider);
            }
        }
    }

    private void registerProviders(RestClientBuilder builder, String providersAsString) {
        for (String s : providersAsString.split(",")) {
            builder.register(this.providerClassForName(s.trim()));
        }
    }

    private Class<?> providerClassForName(String name) {
        try {
            return Class.forName(name, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find provider class: " + name);
        }
    }

    void configureTimeouts(RestClientBuilder builder) {
        Optional readTimeout;
        Optional connectTimeout = RestClientBase.oneOf(this.clientConfigByClassName().connectTimeout, this.clientConfigByConfigKey().connectTimeout);
        if (connectTimeout.isPresent()) {
            builder.connectTimeout(((Long)connectTimeout.get()).longValue(), TimeUnit.MILLISECONDS);
        }
        if ((readTimeout = RestClientBase.oneOf(this.clientConfigByClassName().readTimeout, this.clientConfigByConfigKey().readTimeout)).isPresent()) {
            builder.readTimeout(((Long)readTimeout.get()).longValue(), TimeUnit.MILLISECONDS);
        }
    }

    void configureBaseUrl(RestClientBuilder builder) {
        Optional<String> baseUrlOptional = RestClientBase.oneOf(this.clientConfigByClassName().uri, this.clientConfigByConfigKey().uri);
        if (baseUrlOptional.isEmpty()) {
            baseUrlOptional = RestClientBase.oneOf(this.clientConfigByClassName().url, this.clientConfigByConfigKey().url);
        }
        if ((this.baseUriFromAnnotation == null || this.baseUriFromAnnotation.isEmpty()) && baseUrlOptional.isEmpty()) {
            String propertyPrefix = this.configKey != null ? this.configKey : this.proxyType.getName();
            throw new IllegalArgumentException(String.format("Unable to determine the proper baseUrl/baseUri. Consider registering using @RegisterRestClient(baseUri=\"someuri\"), @RegisterRestClient(configKey=\"orkey\"), or by adding '%s' or '%s' to your Quarkus configuration", String.format(QUARKUS_CONFIG_REST_URL_FORMAT, propertyPrefix), String.format(QUARKUS_CONFIG_REST_URI_FORMAT, propertyPrefix)));
        }
        String baseUrl = baseUrlOptional.orElse(this.baseUriFromAnnotation);
        try {
            builder.baseUrl(new URL(baseUrl));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The value of URL was invalid " + baseUrl, e);
        }
        catch (Exception e) {
            if ("com.oracle.svm.core.jdk.UnsupportedFeatureError".equals(e.getClass().getCanonicalName())) {
                throw new IllegalArgumentException(baseUrl + " requires SSL support but it is disabled. You probably have set quarkus.ssl.native to false.");
            }
            throw e;
        }
    }

    private static RestClientsConfig getConfigRoot() {
        InstanceHandle configHandle = Arc.container().instance(RestClientsConfig.class, new Annotation[0]);
        if (!configHandle.isAvailable()) {
            throw new IllegalStateException("Unable to find the RestClientConfigs");
        }
        return (RestClientsConfig)configHandle.get();
    }

    private RestClientConfig clientConfigByConfigKey() {
        if (this.configKey != null) {
            return this.configRoot.configs.getOrDefault(this.configKey, RestClientConfig.EMPTY);
        }
        return RestClientConfig.EMPTY;
    }

    private RestClientConfig clientConfigByClassName() {
        if (this.configRoot.configs.containsKey(this.proxyType.getName())) {
            return (RestClientConfig)this.configRoot.configs.get(this.proxyType.getName());
        }
        if (this.configRoot.configs.containsKey(this.proxyType.getSimpleName())) {
            return (RestClientConfig)this.configRoot.configs.get(this.proxyType.getSimpleName());
        }
        return RestClientConfig.EMPTY;
    }

    private static <T> Optional<T> oneOf(Optional<T> o1, Optional<T> o2) {
        if (o1.isPresent()) {
            return o1;
        }
        return o2;
    }
}

