/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.restclient.config;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.restclient.config.RestClientConfig;
import io.quarkus.restclient.config.RestClientLoggingConfig;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.CreationException;

@ConfigRoot(name="rest-client", phase=ConfigPhase.RUN_TIME)
public class RestClientsConfig {
    @ConfigItem(name="<<parent>>")
    Map<String, RestClientConfig> configKey;
    @Deprecated
    private final Map<String, RestClientConfig> configs = new ConcurrentHashMap<String, RestClientConfig>();
    @ConfigItem(defaultValue="false")
    public Optional<Boolean> disableSmartProduces;
    @ConfigItem
    public Optional<String> multipartPostEncoderMode;
    @ConfigItem
    public Optional<String> proxyAddress;
    @ConfigItem
    public Optional<String> proxyUser;
    @ConfigItem
    public Optional<String> proxyPassword;
    @ConfigItem
    public Optional<String> nonProxyHosts;
    public RestClientLoggingConfig logging;
    @ConfigItem(defaultValue="15000", defaultValueDocumentation="15000 ms")
    public Long connectTimeout;
    @ConfigItem(defaultValue="30000", defaultValueDocumentation="30000 ms")
    public Long readTimeout;
    @ConfigItem(defaultValue="false")
    public boolean disableContextualErrorMessages;

    public RestClientConfig getClientConfig(String configKey) {
        if (configKey == null) {
            return RestClientConfig.EMPTY;
        }
        return this.configs.computeIfAbsent(configKey, RestClientConfig::load);
    }

    public RestClientConfig getClientConfig(Class<?> clientInterface) {
        return this.configs.computeIfAbsent(clientInterface.getName(), name -> RestClientConfig.load(clientInterface));
    }

    public void putClientConfig(String configKey, RestClientConfig clientConfig) {
        this.configs.put(configKey, clientConfig);
    }

    public void putClientConfig(Class<?> clientInterface, RestClientConfig clientConfig) {
        this.configs.put(clientInterface.getName(), clientConfig);
    }

    public static RestClientsConfig getInstance() {
        InstanceHandle configHandle;
        try {
            configHandle = Arc.container().instance(RestClientsConfig.class, new Annotation[0]);
        }
        catch (CreationException e) {
            String message = "The Rest Client configuration cannot be initialized at this stage. Try to wrap your Rest Client injection in the Provider<> interface:\n\n  @Inject\n  @RestClient\n  Provider<MyRestClientInterface> myRestClient;\n";
            throw new RuntimeException(message, e);
        }
        if (!configHandle.isAvailable()) {
            throw new IllegalStateException("Unable to find the RestClientConfigs");
        }
        return (RestClientsConfig)configHandle.get();
    }
}

