/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;

final class TemplateDataBuildItem
extends MultiBuildItem {
    private final ClassInfo targetClass;
    private final String namespace;
    private final String[] ignore;
    private final Pattern[] ignorePatterns;
    private final boolean ignoreSuperclasses;
    private final boolean properties;

    public TemplateDataBuildItem(ClassInfo targetClass, String namespace, String[] ignore, boolean ignoreSuperclasses, boolean properties) {
        this.targetClass = targetClass;
        this.namespace = namespace;
        this.ignore = ignore;
        this.ignoreSuperclasses = ignoreSuperclasses;
        this.properties = properties;
        if (ignore.length > 0) {
            this.ignorePatterns = new Pattern[ignore.length];
            for (int i = 0; i < ignore.length; ++i) {
                this.ignorePatterns[i] = Pattern.compile(ignore[i]);
            }
        } else {
            this.ignorePatterns = null;
        }
    }

    public ClassInfo getTargetClass() {
        return this.targetClass;
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String[] getIgnore() {
        return this.ignore;
    }

    public boolean isIgnoreSuperclasses() {
        return this.ignoreSuperclasses;
    }

    public boolean isProperties() {
        return this.properties;
    }

    boolean filter(AnnotationTarget target) {
        String name = null;
        if (target.kind() == AnnotationTarget.Kind.METHOD) {
            MethodInfo method = target.asMethod();
            if (this.properties && !method.parameters().isEmpty()) {
                return false;
            }
            name = method.name();
        } else if (target.kind() == AnnotationTarget.Kind.FIELD) {
            FieldInfo field = target.asField();
            name = field.name();
        }
        if (this.ignorePatterns != null) {
            for (int i = 0; i < this.ignorePatterns.length; ++i) {
                if (!this.ignorePatterns[i].matcher(name).matches()) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "TemplateDataBuildItem [targetClass=" + this.targetClass + ", namespace=" + this.namespace + ", ignore=" + Arrays.toString(this.ignore) + ", ignorePatterns=" + Arrays.toString(this.ignorePatterns) + ", ignoreSuperclasses=" + this.ignoreSuperclasses + ", properties=" + this.properties + "]";
    }
}

