/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment.devconsole;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleTemplateInfoBuildItem;
import io.quarkus.qute.deployment.CheckedTemplateBuildItem;
import io.quarkus.qute.deployment.TemplatePathBuildItem;
import io.quarkus.qute.deployment.TemplateVariantsBuildItem;
import io.quarkus.qute.deployment.devconsole.DevQuteInfos;
import io.quarkus.qute.deployment.devconsole.DevQuteTemplateInfo;
import io.quarkus.qute.runtime.devmode.QuteDevConsoleRecorder;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.jboss.logging.Logger;

public class QuteDevConsoleProcessor {
    private static final Logger LOG = Logger.getLogger(QuteDevConsoleProcessor.class);

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT, optional=true)
    DevConsoleRouteBuildItem invokeEndpoint(QuteDevConsoleRecorder recorder) {
        recorder.setupRenderer();
        return new DevConsoleRouteBuildItem("preview", "POST", (Handler)new Handler<RoutingContext>(){

            public void handle(final RoutingContext context) {
                context.request().setExpectMultipart(true);
                context.request().endHandler((Handler)new Handler<Void>(){

                    public void handle(Void ignore) {
                        int dotIdx;
                        MultiMap form = context.request().formAttributes();
                        String templatePath = form.get("template-select");
                        String testJsonData = form.get("template-data");
                        String contentType = null;
                        String fileName = templatePath;
                        int slashIdx = fileName.lastIndexOf(47);
                        if (slashIdx != -1) {
                            fileName = fileName.substring(slashIdx, fileName.length());
                        }
                        if ((dotIdx = fileName.lastIndexOf(46)) != -1) {
                            String suffix = fileName.substring(dotIdx + 1, fileName.length());
                            contentType = suffix.equalsIgnoreCase("json") ? "application/json" : URLConnection.getFileNameMap().getContentTypeFor(fileName);
                        }
                        try {
                            BiFunction renderer = (BiFunction)DevConsoleManager.getGlobal((String)QuteDevConsoleRecorder.RENDER_HANDLER);
                            Object testData = Json.decodeValue((String)testJsonData);
                            testData = QuteDevConsoleProcessor.this.translate(testData);
                            context.response().setStatusCode(200).putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)contentType).end((String)renderer.apply(templatePath, testData));
                        }
                        catch (DecodeException e) {
                            context.response().setStatusCode(500).putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/plain; charset=UTF-8").end("Failed to parse JSON: " + e.getMessage());
                        }
                        catch (Throwable e) {
                            context.fail(e);
                        }
                    }
                });
            }
        });
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public DevConsoleTemplateInfoBuildItem collectTemplateInfo(List<TemplatePathBuildItem> templatePaths, List<CheckedTemplateBuildItem> checkedTemplates, TemplateVariantsBuildItem variants) {
        DevQuteInfos quteInfos = new DevQuteInfos();
        for (Map.Entry<String, List<String>> entry : variants.getVariants().entrySet()) {
            CheckedTemplateBuildItem checkedTemplate = this.findCheckedTemplate(entry.getKey(), checkedTemplates);
            if (checkedTemplate != null) {
                quteInfos.addQuteTemplateInfo(new DevQuteTemplateInfo(checkedTemplate.templateId, this.processVariants(templatePaths, entry.getValue()), checkedTemplate.method.declaringClass().name() + "." + checkedTemplate.method.name() + "()", checkedTemplate.bindings));
                continue;
            }
            quteInfos.addQuteTemplateInfo(new DevQuteTemplateInfo(entry.getKey(), this.processVariants(templatePaths, entry.getValue()), null, null));
        }
        return new DevConsoleTemplateInfoBuildItem("devQuteInfos", (Object)quteInfos);
    }

    private CheckedTemplateBuildItem findCheckedTemplate(String basePath, List<CheckedTemplateBuildItem> checkedTemplates) {
        for (CheckedTemplateBuildItem checkedTemplate : checkedTemplates) {
            if (!checkedTemplate.templateId.equals(basePath)) continue;
            return checkedTemplate;
        }
        return null;
    }

    private Map<String, String> processVariants(List<TemplatePathBuildItem> templatePaths, List<String> variants) {
        HashMap<String, String> variantsMap = new HashMap<String, String>();
        for (String variant : variants) {
            String source = "";
            Path sourcePath = templatePaths.stream().filter(p -> p.getPath().equals(variant)).map(TemplatePathBuildItem::getFullPath).findFirst().orElse(null);
            if (sourcePath != null) {
                try {
                    byte[] content = Files.readAllBytes(sourcePath);
                    source = new String(content, StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    LOG.warn((Object)("Unable to read the template from path: " + sourcePath), (Throwable)e);
                }
            }
            source = source.replace("\n", "\\n");
            variantsMap.put(variant, source);
        }
        return variantsMap;
    }

    private Object translate(Object testData) {
        if (testData instanceof JsonArray) {
            return this.translate((JsonArray)testData);
        }
        if (testData instanceof JsonObject) {
            return this.translate((JsonObject)testData);
        }
        return testData;
    }

    private Object translate(JsonArray testData) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object i : testData.getList()) {
            ret.add(this.translate(i));
        }
        return ret;
    }

    private Object translate(JsonObject testData) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map data = testData.getMap();
        for (String i : testData.fieldNames()) {
            map.put(i, this.translate(data.get(i)));
        }
        return map;
    }
}

