/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.quartz.runtime;

import io.quarkus.arc.Subclass;
import io.quarkus.quartz.QuartzScheduler;
import io.quarkus.quartz.runtime.CdiAwareJob;
import io.quarkus.quartz.runtime.InstrumentedJob;
import io.quarkus.quartz.runtime.QuarkusQuartzConnectionPoolProvider;
import io.quarkus.quartz.runtime.QuartzBuildTimeConfig;
import io.quarkus.quartz.runtime.QuartzExtensionPointConfig;
import io.quarkus.quartz.runtime.QuartzMisfirePolicy;
import io.quarkus.quartz.runtime.QuartzRuntimeConfig;
import io.quarkus.quartz.runtime.QuartzSupport;
import io.quarkus.quartz.runtime.StoreType;
import io.quarkus.runtime.StartupEvent;
import io.quarkus.scheduler.DelayedExecution;
import io.quarkus.scheduler.FailedExecution;
import io.quarkus.scheduler.Scheduled;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.ScheduledJobPaused;
import io.quarkus.scheduler.ScheduledJobResumed;
import io.quarkus.scheduler.SchedulerPaused;
import io.quarkus.scheduler.SchedulerResumed;
import io.quarkus.scheduler.SkippedExecution;
import io.quarkus.scheduler.SuccessfulExecution;
import io.quarkus.scheduler.Trigger;
import io.quarkus.scheduler.common.runtime.AbstractJobDefinition;
import io.quarkus.scheduler.common.runtime.BaseScheduler;
import io.quarkus.scheduler.common.runtime.CronParser;
import io.quarkus.scheduler.common.runtime.DefaultInvoker;
import io.quarkus.scheduler.common.runtime.Events;
import io.quarkus.scheduler.common.runtime.ScheduledInvoker;
import io.quarkus.scheduler.common.runtime.ScheduledMethod;
import io.quarkus.scheduler.common.runtime.SchedulerContext;
import io.quarkus.scheduler.common.runtime.SyntheticScheduled;
import io.quarkus.scheduler.common.runtime.util.SchedulerUtils;
import io.quarkus.scheduler.runtime.SchedulerConfig;
import io.quarkus.scheduler.runtime.SchedulerRuntimeConfig;
import io.quarkus.scheduler.spi.JobInstrumenter;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.Reception;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.Typed;
import jakarta.inject.Singleton;
import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.simpl.InitThreadContextClassLoadHelper;
import org.quartz.simpl.SimpleJobFactory;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;

@Typed(value={QuartzScheduler.class, io.quarkus.scheduler.Scheduler.class})
@Singleton
public class QuartzSchedulerImpl
extends BaseScheduler
implements QuartzScheduler {
    private static final Logger LOGGER = Logger.getLogger((String)QuartzSchedulerImpl.class.getName());
    private static final String INVOKER_KEY = "invoker";
    private final Scheduler scheduler;
    private final boolean startHalted;
    private final Duration shutdownWaitTime;
    private final Map<String, QuartzTrigger> scheduledTasks = new ConcurrentHashMap<String, QuartzTrigger>();
    private final QuartzRuntimeConfig runtimeConfig;
    private final SchedulerConfig schedulerConfig;
    private final StoreType storeType;
    static final String SCHEDULED_METADATA = "scheduled_metadata";
    static final String EXECUTION_METADATA_TASK_CLASS = "execution_metadata_task_class";
    static final String EXECUTION_METADATA_ASYNC_TASK_CLASS = "execution_metadata_async_task_class";
    static final String EXECUTION_METADATA_RUN_ON_VIRTUAL_THREAD = "execution_metadata_run_on_virtual_thread";
    static final String EXECUTION_METADATA_NONCONCURRENT = "execution_metadata_nonconcurrent";
    static final String EXECUTION_METADATA_SKIP_PREDICATE_CLASS = "execution_metadata_skip_predicate_class";

    public QuartzSchedulerImpl(SchedulerContext context, QuartzSupport quartzSupport, SchedulerRuntimeConfig schedulerRuntimeConfig, Event<SkippedExecution> skippedExecutionEvent, Event<SuccessfulExecution> successExecutionEvent, Event<FailedExecution> failedExecutionEvent, Event<DelayedExecution> delayedExecutionEvent, Event<SchedulerPaused> schedulerPausedEvent, Event<SchedulerResumed> schedulerResumedEvent, Event<ScheduledJobPaused> scheduledJobPausedEvent, Event<ScheduledJobResumed> scheduledJobResumedEvent, Instance<Job> jobs, Instance<UserTransaction> userTransaction, Vertx vertx, SchedulerConfig schedulerConfig, Instance<JobInstrumenter> jobInstrumenter, ScheduledExecutorService blockingExecutor) {
        super(vertx, new CronParser(context.getCronType()), schedulerRuntimeConfig.overdueGracePeriod(), new Events(skippedExecutionEvent, successExecutionEvent, failedExecutionEvent, delayedExecutionEvent, schedulerPausedEvent, schedulerResumedEvent, scheduledJobPausedEvent, scheduledJobResumedEvent), jobInstrumenter, blockingExecutor);
        boolean forceStart;
        this.shutdownWaitTime = quartzSupport.getRuntimeConfig().shutdownWaitTime();
        this.runtimeConfig = quartzSupport.getRuntimeConfig();
        this.schedulerConfig = schedulerConfig;
        this.storeType = quartzSupport.getBuildTimeConfig().storeType();
        SchedulerRuntimeConfig.StartMode startMode = schedulerRuntimeConfig.startMode();
        if (startMode != SchedulerRuntimeConfig.StartMode.NORMAL) {
            this.startHalted = startMode == SchedulerRuntimeConfig.StartMode.HALTED;
            forceStart = this.startHalted || startMode == SchedulerRuntimeConfig.StartMode.FORCED;
        } else {
            this.startHalted = false;
            forceStart = false;
        }
        QuartzRuntimeConfig.TriggerConfig simpleTriggerConfig = this.runtimeConfig.simpleTriggerConfig();
        QuartzRuntimeConfig.TriggerConfig cronTriggerConfig = this.runtimeConfig.cronTriggerConfig();
        if (!QuartzMisfirePolicy.validCronValues().contains((Object)cronTriggerConfig.misfirePolicyConfig().misfirePolicy())) {
            throw new IllegalArgumentException("Global cron trigger misfire policy configured with invalid option. Valid options are: " + QuartzMisfirePolicy.validCronValues().stream().map(QuartzMisfirePolicy::dashedName).collect(Collectors.joining(", ")));
        }
        if (!QuartzMisfirePolicy.validSimpleValues().contains((Object)simpleTriggerConfig.misfirePolicyConfig().misfirePolicy())) {
            throw new IllegalArgumentException("Global simple trigger misfire policy configured with invalid option. Valid options are: " + QuartzMisfirePolicy.validSimpleValues().stream().map(QuartzMisfirePolicy::dashedName).collect(Collectors.joining(", ")));
        }
        JobInstrumenter instrumenter = null;
        if (schedulerConfig.tracingEnabled() && jobInstrumenter.isResolvable()) {
            instrumenter = (JobInstrumenter)jobInstrumenter.get();
        }
        if (!schedulerRuntimeConfig.enabled()) {
            LOGGER.info((Object)"Quartz scheduler is disabled by config property and will not be started");
            this.scheduler = null;
        } else if (!forceStart && context.getScheduledMethods("QUARTZ").isEmpty() && !context.forceSchedulerStart()) {
            LOGGER.info((Object)"No scheduled business methods found - Quartz scheduler will not be started");
            this.scheduler = null;
        } else {
            UserTransaction transaction = null;
            try {
                boolean manageTx = quartzSupport.getBuildTimeConfig().storeType().isNonManagedTxJobStore();
                if (manageTx && userTransaction.isResolvable()) {
                    transaction = (UserTransaction)userTransaction.get();
                }
                Properties props = this.getSchedulerConfigurationProperties(quartzSupport);
                StdSchedulerFactory schedulerFactory = new StdSchedulerFactory(props);
                this.scheduler = schedulerFactory.getScheduler();
                this.scheduler.setJobFactory((JobFactory)new InvokerJobFactory(this.scheduledTasks, jobs, vertx, instrumenter));
                if (transaction != null) {
                    transaction.begin();
                }
                Function<TriggerKey, org.quartz.Trigger> triggerFun = new Function<TriggerKey, org.quartz.Trigger>(){

                    @Override
                    public org.quartz.Trigger apply(TriggerKey triggerKey) {
                        try {
                            return QuartzSchedulerImpl.this.scheduler.getTrigger(triggerKey);
                        }
                        catch (SchedulerException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                };
                for (ScheduledMethod method : context.getScheduledMethods("QUARTZ")) {
                    int nameSequence = 0;
                    for (Scheduled scheduled : method.getSchedules()) {
                        if (!context.matchesImplementation(scheduled, "QUARTZ")) continue;
                        Object identity = SchedulerUtils.lookUpPropertyValue((String)scheduled.identity());
                        if (((String)identity).isEmpty()) {
                            identity = ++nameSequence + "_" + method.getInvokerClassName();
                        }
                        ScheduledInvoker invoker = context.createInvoker(method.getInvokerClassName());
                        invoker = this.initInvoker(invoker, this.events, scheduled.concurrentExecution(), this.initSkipPredicate(scheduled.skipExecutionIf()), instrumenter, vertx, invoker.isBlocking() && this.runtimeConfig.runBlockingScheduledMethodOnQuartzThread(), SchedulerUtils.parseExecutionMaxDelayAsMillis((Scheduled)scheduled), blockingExecutor);
                        JobDetail jobDetail = this.createJobBuilder((String)identity, method.getInvokerClassName(), quartzSupport.isNonconcurrent(method)).build();
                        Optional<TriggerBuilder<?>> triggerBuilder = this.createTrigger((String)identity, scheduled, this.runtimeConfig, jobDetail);
                        if (triggerBuilder.isPresent()) {
                            org.quartz.Trigger trigger = triggerBuilder.get().build();
                            org.quartz.Trigger oldTrigger = this.scheduler.getTrigger(trigger.getKey());
                            if (oldTrigger != null) {
                                trigger = triggerBuilder.get().startAt(oldTrigger.getNextFireTime()).build();
                                this.scheduler.rescheduleJob(trigger.getKey(), trigger);
                                LOGGER.debugf("Rescheduled business method %s with config %s", (Object)method.getMethodDescription(), (Object)scheduled);
                            } else if (!this.scheduler.checkExists(trigger.getKey())) {
                                this.scheduler.scheduleJob(jobDetail, trigger);
                                LOGGER.debugf("Scheduled business method %s with config %s", (Object)method.getMethodDescription(), (Object)scheduled);
                            } else {
                                oldTrigger = this.scheduler.getTrigger(new TriggerKey((String)identity + "_trigger", io.quarkus.scheduler.Scheduler.class.getName()));
                                if (oldTrigger != null) {
                                    this.scheduler.deleteJob(jobDetail.getKey());
                                    trigger = triggerBuilder.get().startAt(oldTrigger.getNextFireTime()).build();
                                    this.scheduler.scheduleJob(jobDetail, trigger);
                                    LOGGER.debugf("Rescheduled business method %s with config %s due to Trigger '%s' record being renamed after removal of '_trigger' suffix", (Object)method.getMethodDescription(), (Object)scheduled, (Object)oldTrigger.getKey().getName());
                                }
                            }
                            this.scheduledTasks.put((String)identity, new QuartzTrigger(trigger.getKey(), triggerFun, invoker, SchedulerUtils.parseOverdueGracePeriod((Scheduled)scheduled, (Duration)this.defaultOverdueGracePeriod), quartzSupport.getRuntimeConfig().runBlockingScheduledMethodOnQuartzThread(), false, method.getMethodDescription()));
                            continue;
                        }
                        this.scheduler.deleteJob(new JobKey((String)identity, io.quarkus.scheduler.Scheduler.class.getName()));
                    }
                }
                if (this.storeType.isDbStore()) {
                    Set triggers = this.scheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)io.quarkus.scheduler.Scheduler.class.getName()));
                    for (TriggerKey triggerKey : triggers) {
                        JobDetail jobDetail = this.scheduler.getJobDetail(new JobKey(triggerKey.getName(), triggerKey.getGroup()));
                        if (jobDetail == null) {
                            throw new IllegalStateException("Unable to obtain the job detail for " + String.valueOf(triggerKey));
                        }
                        String scheduledJson = jobDetail.getJobDataMap().getString(SCHEDULED_METADATA);
                        if (scheduledJson == null) continue;
                        SyntheticScheduled scheduled = SyntheticScheduled.fromJson((String)scheduledJson);
                        org.quartz.Trigger oldTrigger = this.scheduler.getTrigger(triggerKey);
                        if (oldTrigger == null) {
                            throw new IllegalStateException("Unable to obtain the trigger for " + String.valueOf(triggerKey));
                        }
                        this.createJobDefinitionQuartzTrigger(new SerializedExecutionMetadata(jobDetail), scheduled, oldTrigger);
                    }
                }
                if (transaction != null) {
                    transaction.commit();
                }
            }
            catch (Throwable e) {
                if (transaction != null) {
                    try {
                        transaction.rollback();
                    }
                    catch (SystemException ex) {
                        LOGGER.error((Object)"Unable to rollback transaction", (Throwable)ex);
                    }
                }
                throw new IllegalStateException("Unable to create Scheduler", e);
            }
        }
    }

    @Produces
    @Singleton
    Scheduler produceQuartzScheduler() {
        if (this.scheduler == null) {
            throw new IllegalStateException("Quartz scheduler is either explicitly disabled through quarkus.scheduler.enabled=false or no @Scheduled methods were found. If you only need to schedule a job programmatically you can force the start of the scheduler by setting 'quarkus.scheduler.start-mode=forced'.");
        }
        return this.scheduler;
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public boolean isStarted() {
        return this.scheduler != null;
    }

    public String implementation() {
        return "QUARTZ";
    }

    public void pause() {
        if (!this.isStarted()) {
            throw this.notStarted();
        }
        try {
            if (this.scheduler != null) {
                this.scheduler.standby();
                this.events.fireSchedulerPaused();
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Unable to pause scheduler", e);
        }
    }

    public void pause(String identity) {
        if (!this.isStarted()) {
            throw this.notStarted();
        }
        Objects.requireNonNull(identity, "Cannot pause - identity is null");
        if (identity.isEmpty()) {
            LOGGER.warn((Object)"Cannot pause - identity is empty");
            return;
        }
        try {
            String parsedIdentity = SchedulerUtils.lookUpPropertyValue((String)identity);
            QuartzTrigger trigger = this.scheduledTasks.get(parsedIdentity);
            if (trigger != null) {
                this.scheduler.pauseJob(new JobKey(parsedIdentity, io.quarkus.scheduler.Scheduler.class.getName()));
                this.events.fireScheduledJobPaused(new ScheduledJobPaused((Trigger)trigger));
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Unable to pause job", e);
        }
    }

    public boolean isPaused(String identity) {
        if (!this.isStarted()) {
            throw this.notStarted();
        }
        Objects.requireNonNull(identity);
        if (identity.isEmpty()) {
            return false;
        }
        try {
            List triggers = this.scheduler.getTriggersOfJob(new JobKey(SchedulerUtils.lookUpPropertyValue((String)identity), io.quarkus.scheduler.Scheduler.class.getName()));
            if (triggers.isEmpty()) {
                return false;
            }
            for (org.quartz.Trigger trigger : triggers) {
                try {
                    if (this.scheduler.getTriggerState(trigger.getKey()) == Trigger.TriggerState.PAUSED) continue;
                    return false;
                }
                catch (SchedulerException e) {
                    LOGGER.warnf("Cannot obtain the trigger state for %s", (Object)trigger.getKey());
                    return false;
                }
            }
            return true;
        }
        catch (SchedulerException e1) {
            LOGGER.warnf((Throwable)e1, "Cannot obtain triggers for job with identity %s", (Object)identity);
            return false;
        }
    }

    public void resume() {
        if (!this.isStarted()) {
            throw this.notStarted();
        }
        try {
            if (this.scheduler != null) {
                this.scheduler.start();
                this.events.fireSchedulerResumed();
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Unable to resume scheduler", e);
        }
    }

    public void resume(String identity) {
        if (!this.isStarted()) {
            throw this.notStarted();
        }
        Objects.requireNonNull(identity, "Cannot resume - identity is null");
        if (identity.isEmpty()) {
            LOGGER.warn((Object)"Cannot resume - identity is empty");
            return;
        }
        try {
            String parsedIdentity = SchedulerUtils.lookUpPropertyValue((String)identity);
            QuartzTrigger trigger = this.scheduledTasks.get(parsedIdentity);
            if (trigger != null) {
                this.scheduler.resumeJob(new JobKey(SchedulerUtils.lookUpPropertyValue((String)parsedIdentity), io.quarkus.scheduler.Scheduler.class.getName()));
                this.events.fireScheduledJobResumed(new ScheduledJobResumed((Trigger)trigger));
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Unable to resume job", e);
        }
    }

    public boolean isRunning() {
        if (!this.isStarted()) {
            return false;
        }
        try {
            return !this.scheduler.isInStandbyMode();
        }
        catch (SchedulerException e) {
            throw new IllegalStateException("Could not evaluate standby mode", e);
        }
    }

    public List<Trigger> getScheduledJobs() {
        if (!this.isStarted()) {
            throw this.notStarted();
        }
        return List.copyOf(this.scheduledTasks.values());
    }

    public Trigger getScheduledJob(String identity) {
        if (!this.isStarted()) {
            throw this.notStarted();
        }
        Objects.requireNonNull(identity);
        if (identity.isEmpty()) {
            return null;
        }
        return this.scheduledTasks.get(SchedulerUtils.lookUpPropertyValue((String)identity));
    }

    @Override
    public QuartzScheduler.QuartzJobDefinition newJob(String identity) {
        if (!this.isStarted()) {
            throw this.notStarted();
        }
        Objects.requireNonNull(identity);
        if (this.scheduledTasks.containsKey(identity)) {
            throw new IllegalStateException("A job with this identity is already scheduled: " + identity);
        }
        return new QuartzJobDefinitionImpl(identity);
    }

    public Trigger unscheduleJob(String identity) {
        String parsedIdentity;
        QuartzTrigger trigger;
        if (!this.isStarted()) {
            throw this.notStarted();
        }
        Objects.requireNonNull(identity);
        if (!identity.isEmpty() && (trigger = this.scheduledTasks.get(parsedIdentity = SchedulerUtils.lookUpPropertyValue((String)identity))) != null && trigger.isProgrammatic && this.scheduledTasks.remove(identity) != null) {
            try {
                this.scheduler.unscheduleJob(trigger.triggerKey);
            }
            catch (SchedulerException e) {
                throw new IllegalStateException("Unable to unschedule job with identity: " + identity);
            }
            return trigger;
        }
        return null;
    }

    void start(@Observes @Priority(value=0) StartupEvent startupEvent) {
        if (this.scheduler == null || this.startHalted) {
            return;
        }
        try {
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            throw new IllegalStateException("Unable to start Scheduler", e);
        }
    }

    void destroy(@Observes(notifyObserver=Reception.IF_EXISTS) @BeforeDestroyed(value=ApplicationScoped.class) Object event) {
        if (this.scheduler != null) {
            try {
                if (this.shutdownWaitTime.isZero()) {
                    this.scheduler.shutdown(false);
                } else {
                    CompletableFuture.supplyAsync(new Supplier<Object>(){

                        @Override
                        public Void get() {
                            try {
                                QuartzSchedulerImpl.this.scheduler.shutdown(true);
                            }
                            catch (SchedulerException e) {
                                throw new RuntimeException(e);
                            }
                            return null;
                        }
                    }).get(this.shutdownWaitTime.toMillis(), TimeUnit.MILLISECONDS);
                }
            }
            catch (Exception e) {
                LOGGER.warnf("Unable to gracefully shutdown the scheduler", (Object)e);
            }
        }
    }

    @PreDestroy
    void destroy() {
        if (this.scheduler != null) {
            try {
                if (!this.scheduler.isShutdown()) {
                    this.scheduler.shutdown(false);
                }
            }
            catch (SchedulerException e) {
                LOGGER.warnf("Unable to shutdown the scheduler", (Object)e);
            }
        }
    }

    private Properties getSchedulerConfigurationProperties(QuartzSupport quartzSupport) {
        Properties props = new Properties();
        QuartzBuildTimeConfig buildTimeConfig = quartzSupport.getBuildTimeConfig();
        QuartzRuntimeConfig runtimeConfig = quartzSupport.getRuntimeConfig();
        props.put("org.quartz.scheduler.skipUpdateCheck", "true");
        props.put("org.quartz.scheduler.instanceName", runtimeConfig.instanceName());
        props.put("org.quartz.scheduler.batchTriggerAcquisitionFireAheadTimeWindow", "" + runtimeConfig.batchTriggerAcquisitionFireAheadTimeWindow());
        props.put("org.quartz.scheduler.batchTriggerAcquisitionMaxCount", "" + runtimeConfig.batchTriggerAcquisitionMaxCount());
        props.put("org.quartz.scheduler.wrapJobExecutionInUserTransaction", "false");
        props.put("org.quartz.scheduler.threadsInheritContextClassLoaderOfInitializer", "true");
        props.put("org.quartz.threadPool.class", buildTimeConfig.threadPoolClass());
        props.put("org.quartz.scheduler.classLoadHelper.class", InitThreadContextClassLoadHelper.class.getName());
        props.put("org.quartz.threadPool.threadCount", "" + runtimeConfig.threadCount());
        props.put("org.quartz.threadPool.threadPriority", "" + runtimeConfig.threadPriority());
        props.put("org.quartz.scheduler.rmi.export", "false");
        props.put("org.quartz.scheduler.rmi.proxy", "false");
        props.put("org.quartz.jobStore.class", buildTimeConfig.storeType().clazz);
        props.put("org.quartz.jobStore.misfireThreshold", "" + runtimeConfig.misfireThreshold().toMillis());
        if (buildTimeConfig.storeType().isDbStore()) {
            String dataSource = buildTimeConfig.dataSourceName().isEmpty() && buildTimeConfig.deferDatasourceCheck() ? runtimeConfig.deferredDatasourceName().orElse("QUARKUS_QUARTZ_DEFAULT_DATASOURCE") : buildTimeConfig.dataSourceName().orElse("QUARKUS_QUARTZ_DEFAULT_DATASOURCE");
            QuarkusQuartzConnectionPoolProvider.setDataSourceName(dataSource);
            boolean serializeJobData = buildTimeConfig.serializeJobData();
            props.put("org.quartz.jobStore.useProperties", serializeJobData ? "false" : "true");
            props.put("org.quartz.jobStore.tablePrefix", buildTimeConfig.tablePrefix());
            props.put("org.quartz.jobStore.dataSource", dataSource);
            props.put("org.quartz.jobStore.driverDelegateClass", quartzSupport.getDriverDialect().get());
            props.put("org.quartz.dataSource." + dataSource + ".connectionProvider.class", QuarkusQuartzConnectionPoolProvider.class.getName());
            props.put("org.quartz.jobStore.acquireTriggersWithinLock", "true");
            if (buildTimeConfig.clustered()) {
                props.put("org.quartz.jobStore.isClustered", "true");
                props.put("org.quartz.jobStore.clusterCheckinInterval", "" + buildTimeConfig.clusterCheckinInterval());
                if (buildTimeConfig.selectWithLockSql().isPresent()) {
                    props.put("org.quartz.jobStore.selectWithLockSQL", buildTimeConfig.selectWithLockSql().get());
                }
            }
            if (buildTimeConfig.storeType().isNonManagedTxJobStore()) {
                props.put("org.quartz.jobStore.nonManagedTXDataSource", dataSource);
            }
        }
        QuartzExtensionPointConfig instanceIdGenerator = buildTimeConfig.instanceIdGenerators().get(runtimeConfig.instanceId());
        if (runtimeConfig.instanceId().equals("AUTO") || instanceIdGenerator != null) {
            props.put("org.quartz.scheduler.instanceId", "AUTO");
        } else {
            if (runtimeConfig.instanceId().equals("SYS_PROP")) {
                LOGGER.warn((Object)"Prefer to configure the 'SystemPropertyInstanceIdGenerator' within the instance ID generators, so the system property name can be changed and the application can be native.");
            }
            props.put("org.quartz.scheduler.instanceId", runtimeConfig.instanceId());
        }
        if (instanceIdGenerator != null) {
            this.putExtensionConfigurationProperties(props, "org.quartz.scheduler.instanceIdGenerator", instanceIdGenerator);
        }
        this.putExtensionConfigurationProperties(props, "org.quartz.plugin", buildTimeConfig.plugins());
        this.putExtensionConfigurationProperties(props, "org.quartz.jobListener", buildTimeConfig.jobListeners());
        this.putExtensionConfigurationProperties(props, "org.quartz.triggerListener", buildTimeConfig.triggerListeners());
        for (Map.Entry<String, String> entry : quartzSupport.getRuntimeConfig().unsupportedProperties().entrySet()) {
            props.putIfAbsent(entry.getKey(), entry.getValue());
        }
        return props;
    }

    private void putExtensionConfigurationProperties(Properties props, String prefix, Map<String, QuartzExtensionPointConfig> configs) {
        configs.forEach((configKey, config) -> this.putExtensionConfigurationProperties(props, String.format("%s.%s", prefix, configKey), (QuartzExtensionPointConfig)config));
    }

    private void putExtensionConfigurationProperties(Properties props, String prefix, QuartzExtensionPointConfig config) {
        props.put(String.format("%s.class", prefix), config.clazz());
        config.properties().forEach((propName, propValue) -> props.put(String.format("%s.%s", prefix, propName), propValue));
    }

    private JobBuilder createJobBuilder(String identity, String invokerClassName, boolean noncurrent) {
        Class jobClass = noncurrent ? NonconcurrentInvokerJob.class : InvokerJob.class;
        return JobBuilder.newJob(jobClass).withIdentity(identity, io.quarkus.scheduler.Scheduler.class.getName()).usingJobData(INVOKER_KEY, invokerClassName).requestRecovery();
    }

    private Optional<TriggerBuilder<?>> createTrigger(String identity, Scheduled scheduled, QuartzRuntimeConfig runtimeConfig, JobDetail jobDetail) {
        SimpleScheduleBuilder scheduleBuilder;
        if (!scheduled.cron().isEmpty()) {
            String cron = SchedulerUtils.lookUpPropertyValue((String)scheduled.cron());
            if (SchedulerUtils.isOff((String)cron)) {
                return Optional.empty();
            }
            cron = this.cronParser.mapToQuartz(this.cronParser.parse(cron)).asString();
            CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)cron);
            ZoneId timeZone = SchedulerUtils.parseCronTimeZone((Scheduled)scheduled);
            if (timeZone != null) {
                cronScheduleBuilder.inTimeZone(TimeZone.getTimeZone(timeZone));
            }
            QuartzRuntimeConfig.QuartzMisfirePolicyConfig perJobConfig = runtimeConfig.misfirePolicyPerJobs().getOrDefault(identity, runtimeConfig.cronTriggerConfig().misfirePolicyConfig());
            switch (perJobConfig.misfirePolicy()) {
                case SMART_POLICY: {
                    break;
                }
                case IGNORE_MISFIRE_POLICY: {
                    cronScheduleBuilder.withMisfireHandlingInstructionIgnoreMisfires();
                    break;
                }
                case FIRE_NOW: {
                    cronScheduleBuilder.withMisfireHandlingInstructionFireAndProceed();
                    break;
                }
                case CRON_TRIGGER_DO_NOTHING: {
                    cronScheduleBuilder.withMisfireHandlingInstructionDoNothing();
                    break;
                }
                case SIMPLE_TRIGGER_RESCHEDULE_NOW_WITH_EXISTING_REPEAT_COUNT: 
                case SIMPLE_TRIGGER_RESCHEDULE_NOW_WITH_REMAINING_REPEAT_COUNT: 
                case SIMPLE_TRIGGER_RESCHEDULE_NEXT_WITH_EXISTING_COUNT: 
                case SIMPLE_TRIGGER_RESCHEDULE_NEXT_WITH_REMAINING_COUNT: {
                    throw new IllegalArgumentException("Cron job " + identity + " configured with invalid misfire policy " + perJobConfig.misfirePolicy().dashedName() + "\nValid options are: " + QuartzMisfirePolicy.validCronValues().stream().map(QuartzMisfirePolicy::dashedName).collect(Collectors.joining(", ")));
                }
            }
            scheduleBuilder = cronScheduleBuilder;
        } else if (!scheduled.every().isEmpty()) {
            OptionalLong everyMillis = SchedulerUtils.parseEveryAsMillis((Scheduled)scheduled);
            if (!everyMillis.isPresent()) {
                return Optional.empty();
            }
            SimpleScheduleBuilder simpleScheduleBuilder = SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(everyMillis.getAsLong()).repeatForever();
            QuartzRuntimeConfig.QuartzMisfirePolicyConfig perJobConfig = runtimeConfig.misfirePolicyPerJobs().getOrDefault(identity, runtimeConfig.simpleTriggerConfig().misfirePolicyConfig());
            switch (perJobConfig.misfirePolicy()) {
                case SMART_POLICY: {
                    break;
                }
                case IGNORE_MISFIRE_POLICY: {
                    simpleScheduleBuilder.withMisfireHandlingInstructionIgnoreMisfires();
                    break;
                }
                case FIRE_NOW: {
                    simpleScheduleBuilder.withMisfireHandlingInstructionFireNow();
                    break;
                }
                case SIMPLE_TRIGGER_RESCHEDULE_NOW_WITH_EXISTING_REPEAT_COUNT: {
                    simpleScheduleBuilder.withMisfireHandlingInstructionNowWithExistingCount();
                    break;
                }
                case SIMPLE_TRIGGER_RESCHEDULE_NOW_WITH_REMAINING_REPEAT_COUNT: {
                    simpleScheduleBuilder.withMisfireHandlingInstructionNowWithRemainingCount();
                    break;
                }
                case SIMPLE_TRIGGER_RESCHEDULE_NEXT_WITH_EXISTING_COUNT: {
                    simpleScheduleBuilder.withMisfireHandlingInstructionNextWithExistingCount();
                    break;
                }
                case SIMPLE_TRIGGER_RESCHEDULE_NEXT_WITH_REMAINING_COUNT: {
                    simpleScheduleBuilder.withMisfireHandlingInstructionNextWithRemainingCount();
                    break;
                }
                case CRON_TRIGGER_DO_NOTHING: {
                    throw new IllegalArgumentException("Simple job " + identity + " configured with invalid misfire policy " + perJobConfig.misfirePolicy().dashedName() + "\nValid options are: " + QuartzMisfirePolicy.validSimpleValues().stream().map(QuartzMisfirePolicy::dashedName).collect(Collectors.joining(", ")));
                }
            }
            scheduleBuilder = simpleScheduleBuilder;
        } else {
            throw new IllegalArgumentException("Invalid schedule configuration: " + String.valueOf(scheduled));
        }
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(identity, io.quarkus.scheduler.Scheduler.class.getName()).forJob(jobDetail).withSchedule((ScheduleBuilder)scheduleBuilder);
        Long millisToAdd = null;
        if (scheduled.delay() > 0L) {
            millisToAdd = scheduled.delayUnit().toMillis(scheduled.delay());
        } else if (!scheduled.delayed().isEmpty()) {
            millisToAdd = SchedulerUtils.parseDelayedAsMillis((Scheduled)scheduled);
        }
        if (millisToAdd != null) {
            triggerBuilder.startAt(new Date(Instant.now().plusMillis(millisToAdd).toEpochMilli()));
        }
        return Optional.of(triggerBuilder);
    }

    QuartzTrigger createJobDefinitionQuartzTrigger(ExecutionMetadata executionMetadata, SyntheticScheduled scheduled, org.quartz.Trigger oldTrigger) {
        org.quartz.Trigger trigger;
        final Consumer<ScheduledExecution> task = executionMetadata.task();
        final Function<ScheduledExecution, Uni<Void>> asyncTask = executionMetadata.asyncTask();
        final boolean runOnVirtualThread = executionMetadata.isRunOnVirtualThread();
        Scheduled.SkipPredicate skipPredicate = executionMetadata.skipPredicate();
        DefaultInvoker invoker = task != null ? new DefaultInvoker(){

            public CompletionStage<Void> invokeBean(ScheduledExecution execution) {
                try {
                    task.accept(execution);
                    return CompletableFuture.completedStage(null);
                }
                catch (Exception e) {
                    return CompletableFuture.failedStage(e);
                }
            }

            public boolean isRunningOnVirtualThread() {
                return runOnVirtualThread;
            }
        } : new DefaultInvoker(){

            public CompletionStage<Void> invokeBean(ScheduledExecution execution) {
                try {
                    return ((Uni)asyncTask.apply(execution)).subscribeAsCompletionStage();
                }
                catch (Exception e) {
                    return CompletableFuture.failedStage(e);
                }
            }

            public boolean isBlocking() {
                return false;
            }
        };
        JobBuilder jobBuilder = this.createJobBuilder(scheduled.identity(), QuartzSchedulerImpl.class.getName(), executionMetadata.nonconcurrent());
        if (this.storeType.isDbStore()) {
            jobBuilder.usingJobData(SCHEDULED_METADATA, scheduled.toJson()).usingJobData(EXECUTION_METADATA_RUN_ON_VIRTUAL_THREAD, Boolean.toString(runOnVirtualThread));
            if (executionMetadata.taskClass() != null) {
                jobBuilder.usingJobData(EXECUTION_METADATA_TASK_CLASS, executionMetadata.taskClass().getName());
            } else if (executionMetadata.asyncTaskClass() != null) {
                jobBuilder.usingJobData(EXECUTION_METADATA_ASYNC_TASK_CLASS, executionMetadata.asyncTaskClass().getName());
            }
            if (executionMetadata.skipPredicateClass() != null) {
                jobBuilder.usingJobData(EXECUTION_METADATA_SKIP_PREDICATE_CLASS, executionMetadata.skipPredicateClass().getName());
            }
        }
        JobDetail jobDetail = jobBuilder.requestRecovery().build();
        Optional<TriggerBuilder<?>> triggerBuilder = this.createTrigger(scheduled.identity(), (Scheduled)scheduled, this.runtimeConfig, jobDetail);
        if (triggerBuilder.isPresent()) {
            trigger = oldTrigger != null ? triggerBuilder.get().startAt(oldTrigger.getNextFireTime()).build() : triggerBuilder.get().build();
        } else {
            if (oldTrigger != null) {
                throw new IllegalStateException("Job [" + scheduled.identity() + "] that was previously scheduled programmatically cannot be disabled");
            }
            return null;
        }
        JobInstrumenter instrumenter = null;
        if (this.schedulerConfig.tracingEnabled() && this.jobInstrumenter.isResolvable()) {
            instrumenter = (JobInstrumenter)this.jobInstrumenter.get();
        }
        invoker = this.initInvoker((ScheduledInvoker)invoker, this.events, scheduled.concurrentExecution(), skipPredicate, instrumenter, this.vertx, task != null && this.runtimeConfig.runBlockingScheduledMethodOnQuartzThread(), SchedulerUtils.parseExecutionMaxDelayAsMillis((Scheduled)scheduled), this.blockingExecutor);
        QuartzTrigger quartzTrigger = new QuartzTrigger(trigger.getKey(), new Function<TriggerKey, org.quartz.Trigger>(){

            @Override
            public org.quartz.Trigger apply(TriggerKey triggerKey) {
                try {
                    return QuartzSchedulerImpl.this.scheduler.getTrigger(triggerKey);
                }
                catch (SchedulerException e) {
                    throw new IllegalStateException(e);
                }
            }
        }, (ScheduledInvoker)invoker, SchedulerUtils.parseOverdueGracePeriod((Scheduled)scheduled, (Duration)this.defaultOverdueGracePeriod), this.runtimeConfig.runBlockingScheduledMethodOnQuartzThread(), true, null);
        QuartzTrigger existing = this.scheduledTasks.putIfAbsent(scheduled.identity(), quartzTrigger);
        if (existing != null) {
            throw new IllegalStateException("A job with this identity is already scheduled: " + scheduled.identity());
        }
        try {
            if (oldTrigger != null) {
                this.scheduler.rescheduleJob(trigger.getKey(), trigger);
                LOGGER.debugf("Rescheduled job definition with config %s", (Object)scheduled);
            } else {
                this.scheduler.scheduleJob(jobDetail, trigger);
                LOGGER.debugf("Scheduled job definition with config %s", (Object)scheduled);
            }
        }
        catch (SchedulerException e) {
            throw new IllegalStateException(e);
        }
        return quartzTrigger;
    }

    static class InvokerJobFactory
    extends SimpleJobFactory {
        final Map<String, QuartzTrigger> scheduledTasks;
        final Instance<Job> jobs;
        final Vertx vertx;
        final JobInstrumenter instrumenter;

        InvokerJobFactory(Map<String, QuartzTrigger> scheduledTasks, Instance<Job> jobs, Vertx vertx, JobInstrumenter instrumenter) {
            this.scheduledTasks = scheduledTasks;
            this.jobs = jobs;
            this.vertx = vertx;
            this.instrumenter = instrumenter;
        }

        public Job newJob(TriggerFiredBundle bundle, Scheduler Scheduler2) throws SchedulerException {
            Instance instance;
            Class jobClass = bundle.getJobDetail().getJobClass();
            if (jobClass.equals(InvokerJob.class)) {
                return new InvokerJob(this.scheduledTasks.get(bundle.getJobDetail().getKey().getName()), this.vertx);
            }
            if (jobClass.equals(NonconcurrentInvokerJob.class)) {
                return new NonconcurrentInvokerJob(this.scheduledTasks.get(bundle.getJobDetail().getKey().getName()), this.vertx);
            }
            if (Subclass.class.isAssignableFrom(jobClass)) {
                jobClass = jobClass.getSuperclass();
            }
            if ((instance = this.jobs.select(jobClass, new Annotation[0])).isResolvable()) {
                return this.jobWithSpanWrapper((Job)new CdiAwareJob((Instance.Handle<? extends Job>)instance.getHandle()));
            }
            return this.jobWithSpanWrapper(super.newJob(bundle, Scheduler2));
        }

        private Job jobWithSpanWrapper(Job job) {
            if (this.instrumenter != null) {
                return new InstrumentedJob(job, this.instrumenter);
            }
            return job;
        }
    }

    static class QuartzTrigger
    implements Trigger {
        private final TriggerKey triggerKey;
        private final Function<TriggerKey, org.quartz.Trigger> triggerFunction;
        private final ScheduledInvoker invoker;
        private final Duration gracePeriod;
        private final boolean isProgrammatic;
        private final String methodDescription;
        final boolean runBlockingMethodOnQuartzThread;

        QuartzTrigger(TriggerKey triggerKey, Function<TriggerKey, org.quartz.Trigger> triggerFunction, ScheduledInvoker invoker, Duration gracePeriod, boolean runBlockingMethodOnQuartzThread, boolean isProgrammatic, String methodDescription) {
            this.triggerKey = triggerKey;
            this.triggerFunction = triggerFunction;
            this.invoker = invoker;
            this.gracePeriod = gracePeriod;
            this.runBlockingMethodOnQuartzThread = runBlockingMethodOnQuartzThread;
            this.isProgrammatic = isProgrammatic;
            this.methodDescription = methodDescription;
        }

        public Instant getNextFireTime() {
            Date nextFireTime = this.trigger().getNextFireTime();
            return nextFireTime != null ? nextFireTime.toInstant() : null;
        }

        public Instant getPreviousFireTime() {
            Date previousFireTime = this.trigger().getPreviousFireTime();
            return previousFireTime != null ? previousFireTime.toInstant() : null;
        }

        public boolean isOverdue() {
            Instant nextFireTime = this.getNextFireTime();
            if (nextFireTime == null) {
                return false;
            }
            return LocalDateTime.ofInstant(nextFireTime, ZoneId.systemDefault()).plus(this.gracePeriod).isBefore(LocalDateTime.now());
        }

        public String getId() {
            return this.trigger().getKey().getName();
        }

        public String getMethodDescription() {
            return this.methodDescription;
        }

        private org.quartz.Trigger trigger() {
            return this.triggerFunction.apply(this.triggerKey);
        }
    }

    static class SerializedExecutionMetadata
    implements ExecutionMetadata {
        private final Class<? extends Consumer<ScheduledExecution>> taskClass;
        private final Class<? extends Function<ScheduledExecution, Uni<Void>>> asyncTaskClass;
        private final boolean runOnVirtualThread;
        private final Class<? extends Scheduled.SkipPredicate> skipPredicateClass;
        private final boolean nonconcurrent;

        public SerializedExecutionMetadata(JobDetail jobDetail) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            String taskClassStr = jobDetail.getJobDataMap().getString(QuartzSchedulerImpl.EXECUTION_METADATA_TASK_CLASS);
            try {
                this.taskClass = taskClassStr != null ? tccl.loadClass(taskClassStr) : null;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Cannot load task class: " + taskClassStr);
            }
            String asyncTaskClassStr = jobDetail.getJobDataMap().getString(QuartzSchedulerImpl.EXECUTION_METADATA_ASYNC_TASK_CLASS);
            try {
                this.asyncTaskClass = asyncTaskClassStr != null ? tccl.loadClass(asyncTaskClassStr) : null;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Cannot load async task class: " + taskClassStr);
            }
            String skipPredicateClassStr = jobDetail.getJobDataMap().getString(QuartzSchedulerImpl.EXECUTION_METADATA_SKIP_PREDICATE_CLASS);
            try {
                this.skipPredicateClass = skipPredicateClassStr != null ? tccl.loadClass(skipPredicateClassStr) : null;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Cannot load skip predicate class: " + taskClassStr);
            }
            this.runOnVirtualThread = Boolean.parseBoolean(jobDetail.getJobDataMap().getString(QuartzSchedulerImpl.EXECUTION_METADATA_RUN_ON_VIRTUAL_THREAD));
            this.nonconcurrent = Boolean.parseBoolean(jobDetail.getJobDataMap().getString(QuartzSchedulerImpl.EXECUTION_METADATA_NONCONCURRENT));
        }

        @Override
        public Consumer<ScheduledExecution> task() {
            return this.taskClass != null ? (Consumer)SchedulerUtils.instantiateBeanOrClass(this.taskClass) : null;
        }

        @Override
        public Class<? extends Consumer<ScheduledExecution>> taskClass() {
            return this.taskClass;
        }

        @Override
        public Function<ScheduledExecution, Uni<Void>> asyncTask() {
            return this.asyncTaskClass != null ? (Function)SchedulerUtils.instantiateBeanOrClass(this.asyncTaskClass) : null;
        }

        @Override
        public Class<? extends Function<ScheduledExecution, Uni<Void>>> asyncTaskClass() {
            return this.asyncTaskClass;
        }

        @Override
        public boolean nonconcurrent() {
            return this.nonconcurrent;
        }

        @Override
        public boolean isRunOnVirtualThread() {
            return this.runOnVirtualThread;
        }

        @Override
        public Scheduled.SkipPredicate skipPredicate() {
            return this.skipPredicateClass != null ? (Scheduled.SkipPredicate)SchedulerUtils.instantiateBeanOrClass(this.skipPredicateClass) : null;
        }

        @Override
        public Class<? extends Scheduled.SkipPredicate> skipPredicateClass() {
            return this.skipPredicateClass;
        }
    }

    static interface ExecutionMetadata {
        public Consumer<ScheduledExecution> task();

        public Class<? extends Consumer<ScheduledExecution>> taskClass();

        public Function<ScheduledExecution, Uni<Void>> asyncTask();

        public Class<? extends Function<ScheduledExecution, Uni<Void>>> asyncTaskClass();

        public boolean isRunOnVirtualThread();

        public Scheduled.SkipPredicate skipPredicate();

        public Class<? extends Scheduled.SkipPredicate> skipPredicateClass();

        public boolean nonconcurrent();
    }

    class QuartzJobDefinitionImpl
    extends AbstractJobDefinition<QuartzScheduler.QuartzJobDefinition>
    implements ExecutionMetadata,
    QuartzScheduler.QuartzJobDefinition {
        private boolean nonconcurrent;

        QuartzJobDefinitionImpl(String id) {
            super(id);
        }

        @Override
        public QuartzScheduler.QuartzJobDefinition setNonconcurrent() {
            this.nonconcurrent = true;
            return (QuartzScheduler.QuartzJobDefinition)this.self();
        }

        @Override
        public boolean nonconcurrent() {
            return this.nonconcurrent;
        }

        @Override
        public boolean isRunOnVirtualThread() {
            return this.runOnVirtualThread;
        }

        @Override
        public Consumer<ScheduledExecution> task() {
            return this.task;
        }

        @Override
        public Function<ScheduledExecution, Uni<Void>> asyncTask() {
            return this.asyncTask;
        }

        @Override
        public Scheduled.SkipPredicate skipPredicate() {
            return this.skipPredicate;
        }

        @Override
        public Class<? extends Consumer<ScheduledExecution>> taskClass() {
            return this.taskClass;
        }

        @Override
        public Class<? extends Function<ScheduledExecution, Uni<Void>>> asyncTaskClass() {
            return this.asyncTaskClass;
        }

        @Override
        public Class<? extends Scheduled.SkipPredicate> skipPredicateClass() {
            return this.skipPredicateClass;
        }

        public QuartzScheduler.QuartzJobDefinition setSkipPredicate(Scheduled.SkipPredicate skipPredicate) {
            if (QuartzSchedulerImpl.this.storeType.isDbStore() && this.skipPredicateClass == null) {
                throw new IllegalStateException("A skip predicate instance cannot be scheduled programmatically if DB store type is used; register a skip predicate class instead");
            }
            return (QuartzScheduler.QuartzJobDefinition)super.setSkipPredicate(skipPredicate);
        }

        public QuartzScheduler.QuartzJobDefinition setTask(Consumer<ScheduledExecution> task, boolean runOnVirtualThread) {
            if (QuartzSchedulerImpl.this.storeType.isDbStore() && this.taskClass == null) {
                throw new IllegalStateException("A task instance cannot be scheduled programmatically if DB store type is used; register a task class instead");
            }
            return (QuartzScheduler.QuartzJobDefinition)super.setTask(task, runOnVirtualThread);
        }

        public QuartzScheduler.QuartzJobDefinition setAsyncTask(Function<ScheduledExecution, Uni<Void>> asyncTask) {
            if (QuartzSchedulerImpl.this.storeType.isDbStore() && this.asyncTaskClass == null) {
                throw new IllegalStateException("An async task instance cannot be scheduled programmatically if DB store type is used; register an async task class instead");
            }
            return (QuartzScheduler.QuartzJobDefinition)super.setAsyncTask(asyncTask);
        }

        public Trigger schedule() {
            this.checkScheduled();
            if (this.task == null && this.asyncTask == null) {
                throw new IllegalStateException("Either sync or async task must be set");
            }
            this.scheduled = true;
            SyntheticScheduled scheduled = new SyntheticScheduled(this.identity, this.cron, this.every, 0L, TimeUnit.MINUTES, this.delayed, this.overdueGracePeriod, this.concurrentExecution, this.skipPredicate, this.timeZone, this.implementation, this.executionMaxDelay);
            return QuartzSchedulerImpl.this.createJobDefinitionQuartzTrigger(this, scheduled, null);
        }
    }

    @DisallowConcurrentExecution
    static class NonconcurrentInvokerJob
    extends InvokerJob {
        NonconcurrentInvokerJob(QuartzTrigger trigger, Vertx vertx) {
            super(trigger, vertx);
        }

        @Override
        boolean awaitResult() {
            return true;
        }
    }

    static class InvokerJob
    implements Job {
        final QuartzTrigger trigger;
        final Vertx vertx;

        InvokerJob(QuartzTrigger trigger, Vertx vertx) {
            this.trigger = trigger;
            this.vertx = vertx;
        }

        boolean awaitResult() {
            return false;
        }

        public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
            block6: {
                if (this.trigger != null && this.trigger.invoker != null) {
                    try {
                        CompletionStage ret = this.trigger.invoker.invoke((ScheduledExecution)new QuartzScheduledExecution(this.trigger, jobExecutionContext));
                        if (!this.awaitResult()) break block6;
                        try {
                            ret.toCompletableFuture().get();
                        }
                        catch (CancellationException | ExecutionException e) {
                            LOGGER.warnf("Unable to retrieve result for job %s: %s", (Object)jobExecutionContext.getJobDetail().getKey().getName(), (Object)e.toString());
                        }
                    }
                    catch (Exception ret) {}
                } else {
                    String jobName = jobExecutionContext.getJobDetail().getKey().getName();
                    LOGGER.warnf("Unable to find corresponding Quartz trigger for job %s. Update your Quartz table by removing all phantom jobs or make sure that there is a Scheduled method with the identity matching the job's name", (Object)jobName);
                }
            }
        }
    }

    static class QuartzScheduledExecution
    implements ScheduledExecution {
        final JobExecutionContext context;
        final QuartzTrigger trigger;

        QuartzScheduledExecution(QuartzTrigger trigger, JobExecutionContext context) {
            this.trigger = trigger;
            this.context = context;
        }

        public Trigger getTrigger() {
            return this.trigger;
        }

        public Instant getFireTime() {
            return this.context.getFireTime().toInstant();
        }

        public Instant getScheduledFireTime() {
            return this.context.getScheduledFireTime().toInstant();
        }
    }
}

