/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.IdTokenCredential;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.OidcTokenCredential;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.oidc.runtime.TokenAutoRefreshException;
import io.quarkus.oidc.runtime.TokenVerificationResult;
import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.security.Principal;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class OidcIdentityProvider
implements IdentityProvider<TokenAuthenticationRequest> {
    static final String CODE_FLOW_ACCESS_TOKEN = "access_token";
    static final String REFRESH_TOKEN_GRANT_RESPONSE = "refresh_token_grant_response";
    static final String NEW_AUTHENTICATION = "new_authentication";
    private static final Uni<TokenVerificationResult> NULL_CODE_ACCESS_TOKEN_UNI = Uni.createFrom().nullItem();
    private static final Uni<JsonObject> NULL_USER_INFO_UNI = Uni.createFrom().nullItem();
    private static final String CODE_ACCESS_TOKEN_RESULT = "code_flow_access_token_result";
    @Inject
    DefaultTenantConfigResolver tenantResolver;

    public Class<TokenAuthenticationRequest> getRequestType() {
        return TokenAuthenticationRequest.class;
    }

    public Uni<SecurityIdentity> authenticate(final TokenAuthenticationRequest request, AuthenticationRequestContext context) {
        OidcTokenCredential credential = (OidcTokenCredential)request.getToken();
        final RoutingContext vertxContext = credential.getRoutingContext();
        vertxContext.put(AuthenticationRequestContext.class.getName(), (Object)context);
        Uni<TenantConfigContext> tenantConfigContext = this.tenantResolver.resolveContext(vertxContext);
        return tenantConfigContext.onItem().transformToUni((Function)new Function<TenantConfigContext, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(final TenantConfigContext tenantConfigContext) {
                return Uni.createFrom().deferred((Supplier)new Supplier<Uni<? extends SecurityIdentity>>(){

                    @Override
                    public Uni<SecurityIdentity> get() {
                        return OidcIdentityProvider.this.authenticate(request, vertxContext, tenantConfigContext);
                    }
                });
            }
        });
    }

    private Uni<SecurityIdentity> authenticate(TokenAuthenticationRequest request, RoutingContext vertxContext, TenantConfigContext resolvedContext) {
        if (resolvedContext.oidcConfig.publicKey.isPresent()) {
            return OidcIdentityProvider.validateTokenWithoutOidcServer(request, resolvedContext);
        }
        return this.validateAllTokensWithOidcServer(vertxContext, request, resolvedContext);
    }

    private Uni<SecurityIdentity> validateAllTokensWithOidcServer(final RoutingContext vertxContext, final TokenAuthenticationRequest request, final TenantConfigContext resolvedContext) {
        Uni<TokenVerificationResult> codeAccessTokenUni = this.verifyCodeFlowAccessTokenUni(vertxContext, request, resolvedContext);
        return codeAccessTokenUni.onItem().transformToUni((Function)new Function<TokenVerificationResult, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(TokenVerificationResult codeAccessToken) {
                return OidcIdentityProvider.this.validateTokenWithOidcServer(vertxContext, request, resolvedContext, codeAccessToken);
            }
        });
    }

    private Uni<SecurityIdentity> validateTokenWithOidcServer(final RoutingContext vertxContext, final TokenAuthenticationRequest request, final TenantConfigContext resolvedContext, TokenVerificationResult codeAccessTokenResult) {
        if (codeAccessTokenResult != null) {
            vertxContext.put(CODE_ACCESS_TOKEN_RESULT, (Object)codeAccessTokenResult);
        }
        Uni<JsonObject> userInfo = this.getUserInfoUni(vertxContext, request, resolvedContext);
        return userInfo.onItem().transformToUni((Function)new Function<JsonObject, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(JsonObject userInfo) {
                return OidcIdentityProvider.this.createSecurityIdentityWithOidcServer(vertxContext, request, resolvedContext, userInfo);
            }
        });
    }

    private Uni<SecurityIdentity> createSecurityIdentityWithOidcServer(final RoutingContext vertxContext, final TokenAuthenticationRequest request, final TenantConfigContext resolvedContext, final JsonObject userInfo) {
        Uni<TokenVerificationResult> codeFlowTokenUni = this.verifyTokenUni(resolvedContext, request.getToken().getToken());
        return codeFlowTokenUni.onItem().transformToUni((Function)new Function<TokenVerificationResult, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(TokenVerificationResult result) {
                TokenCredential tokenCred = request.getToken();
                JsonObject tokenJson = result.localVerificationResult;
                if (tokenJson == null) {
                    tokenJson = OidcUtils.decodeJwtContent(tokenCred.getToken());
                }
                if (tokenJson != null) {
                    OidcUtils.validatePrimaryJwtTokenType(resolvedContext.oidcConfig.token, tokenJson);
                    JsonObject rolesJson = OidcIdentityProvider.getRolesJson(vertxContext, resolvedContext, tokenCred, tokenJson, userInfo);
                    try {
                        QuarkusSecurityIdentity securityIdentity = OidcUtils.validateAndCreateIdentity(vertxContext, tokenCred, resolvedContext.oidcConfig, tokenJson, rolesJson, userInfo);
                        if (OidcIdentityProvider.tokenAutoRefreshPrepared(tokenJson, vertxContext, resolvedContext.oidcConfig)) {
                            return Uni.createFrom().failure((Throwable)new TokenAutoRefreshException((SecurityIdentity)securityIdentity));
                        }
                        return Uni.createFrom().item((Object)securityIdentity);
                    }
                    catch (Throwable ex) {
                        return Uni.createFrom().failure(ex);
                    }
                }
                if (tokenCred instanceof IdTokenCredential || tokenCred instanceof AccessTokenCredential && !((AccessTokenCredential)tokenCred).isOpaque()) {
                    return Uni.createFrom().failure((Throwable)new AuthenticationFailedException("JWT token can not be converted to JSON"));
                }
                QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder();
                builder.addCredential((Credential)tokenCred);
                OidcUtils.setSecurityIdentityUserInfo(builder, userInfo);
                if (result.introspectionResult.containsKey("username")) {
                    final String userName = result.introspectionResult.getString("username");
                    builder.setPrincipal(new Principal(){

                        @Override
                        public String getName() {
                            return userName;
                        }
                    });
                }
                if (result.introspectionResult.containsKey("scope")) {
                    for (String role : result.introspectionResult.getString("scope").split(" ")) {
                        builder.addRole(role.trim());
                    }
                }
                if (userInfo != null) {
                    OidcUtils.setSecurityIdentityRoles(builder, resolvedContext.oidcConfig, userInfo);
                }
                OidcUtils.setBlockinApiAttribute(builder, vertxContext);
                OidcUtils.setTenantIdAttribute(builder, resolvedContext.oidcConfig);
                return Uni.createFrom().item((Object)builder.build());
            }
        });
    }

    private static boolean tokenAutoRefreshPrepared(JsonObject tokenJson, RoutingContext vertxContext, OidcTenantConfig oidcConfig) {
        if (tokenJson != null && oidcConfig.token.refreshExpired && oidcConfig.token.autoRefreshInterval.isPresent() && vertxContext.get(REFRESH_TOKEN_GRANT_RESPONSE) != Boolean.TRUE && vertxContext.get(NEW_AUTHENTICATION) != Boolean.TRUE) {
            long autoRefreshInterval = oidcConfig.token.autoRefreshInterval.get().getSeconds();
            long expiry = tokenJson.getLong("exp");
            long now = System.currentTimeMillis() / 1000L;
            return now + autoRefreshInterval > expiry;
        }
        return false;
    }

    private static JsonObject getRolesJson(RoutingContext vertxContext, TenantConfigContext resolvedContext, TokenCredential tokenCred, JsonObject tokenJson, JsonObject userInfo) {
        JsonObject rolesJson = tokenJson;
        if (resolvedContext.oidcConfig.roles.source.isPresent()) {
            if (resolvedContext.oidcConfig.roles.source.get() == OidcTenantConfig.Roles.Source.userinfo) {
                rolesJson = userInfo;
            } else if (tokenCred instanceof IdTokenCredential && resolvedContext.oidcConfig.roles.source.get() == OidcTenantConfig.Roles.Source.accesstoken && (rolesJson = ((TokenVerificationResult)vertxContext.get((String)CODE_ACCESS_TOKEN_RESULT)).localVerificationResult) == null) {
                rolesJson = OidcUtils.decodeJwtContent((String)vertxContext.get(CODE_FLOW_ACCESS_TOKEN));
            }
        }
        return rolesJson;
    }

    private Uni<TokenVerificationResult> verifyCodeFlowAccessTokenUni(RoutingContext vertxContext, TokenAuthenticationRequest request, TenantConfigContext resolvedContext) {
        if (request.getToken() instanceof IdTokenCredential && (resolvedContext.oidcConfig.authentication.verifyAccessToken || resolvedContext.oidcConfig.roles.source.orElse(null) == OidcTenantConfig.Roles.Source.accesstoken)) {
            String codeAccessToken = (String)vertxContext.get(CODE_FLOW_ACCESS_TOKEN);
            return this.verifyTokenUni(resolvedContext, codeAccessToken);
        }
        return NULL_CODE_ACCESS_TOKEN_UNI;
    }

    private Uni<TokenVerificationResult> verifyTokenUni(final TenantConfigContext resolvedContext, final String token) {
        if (OidcUtils.isOpaqueToken(token)) {
            return Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super TokenVerificationResult>>(){

                @Override
                public void accept(final UniEmitter<? super TokenVerificationResult> uniEmitter) {
                    if (BlockingOperationControl.isBlockingAllowed()) {
                        resolvedContext.client.verifyToken(uniEmitter, resolvedContext, token);
                    } else {
                        OidcIdentityProvider.this.tenantResolver.getBlockingExecutor().execute(new Runnable(){

                            @Override
                            public void run() {
                                resolvedContext.client.verifyToken((UniEmitter<? super TokenVerificationResult>)uniEmitter, resolvedContext, token);
                            }
                        });
                    }
                }
            });
        }
        return Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super TokenVerificationResult>>(){

            @Override
            public void accept(UniEmitter<? super TokenVerificationResult> uniEmitter) {
                resolvedContext.client.verifyToken(uniEmitter, resolvedContext, token);
            }
        });
    }

    private static Uni<SecurityIdentity> validateTokenWithoutOidcServer(TokenAuthenticationRequest request, TenantConfigContext resolvedContext) {
        JsonObject tokenJson = null;
        try {
            tokenJson = resolvedContext.client.validateTokenWithoutOidcServer(request.getToken().getToken());
        }
        catch (Throwable ex) {
            return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(ex));
        }
        try {
            return Uni.createFrom().item((Object)OidcUtils.validateAndCreateIdentity(null, request.getToken(), resolvedContext.oidcConfig, tokenJson, tokenJson, null));
        }
        catch (Throwable ex) {
            return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(ex));
        }
    }

    private Uni<JsonObject> getUserInfoUni(final RoutingContext vertxContext, final TokenAuthenticationRequest request, final TenantConfigContext resolvedContext) {
        if (resolvedContext.oidcConfig.authentication.isUserInfoRequired()) {
            return Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super JsonObject>>(){

                @Override
                public void accept(final UniEmitter<? super JsonObject> uniEmitter) {
                    if (BlockingOperationControl.isBlockingAllowed()) {
                        resolvedContext.client.createUserInfoToken(uniEmitter, vertxContext, request);
                    } else {
                        OidcIdentityProvider.this.tenantResolver.getBlockingExecutor().execute(new Runnable(){

                            @Override
                            public void run() {
                                resolvedContext.client.createUserInfoToken((UniEmitter<? super JsonObject>)uniEmitter, vertxContext, request);
                            }
                        });
                    }
                }
            });
        }
        return NULL_USER_INFO_UNI;
    }
}

