/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc;

import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

@ConfigGroup
public class OidcTenantConfig
extends OidcCommonConfig {
    @ConfigItem
    public Optional<String> tenantId = Optional.empty();
    @ConfigItem(defaultValue="true")
    public boolean tenantEnabled = true;
    @ConfigItem(defaultValue="service")
    public ApplicationType applicationType = ApplicationType.SERVICE;
    @ConfigItem
    public Optional<String> authorizationPath = Optional.empty();
    @ConfigItem
    public Optional<String> userInfoPath = Optional.empty();
    @ConfigItem
    public Optional<String> introspectionPath = Optional.empty();
    @ConfigItem
    public Optional<String> jwksPath = Optional.empty();
    @ConfigItem
    public Optional<String> endSessionPath = Optional.empty();
    @ConfigItem
    public Optional<String> publicKey = Optional.empty();
    @ConfigItem
    public Roles roles = new Roles();
    @ConfigItem
    public Token token = new Token();
    @ConfigItem
    public Logout logout = new Logout();
    public Authentication authentication = new Authentication();
    @ConfigItem
    public TokenStateManager tokenStateManager = new TokenStateManager();

    public Optional<String> getAuthorizationPath() {
        return this.authorizationPath;
    }

    public void setAuthorizationPath(String authorizationPath) {
        this.authorizationPath = Optional.of(authorizationPath);
    }

    public Optional<String> getUserInfoPath() {
        return this.userInfoPath;
    }

    public void setUserInfoPath(String userInfoPath) {
        this.userInfoPath = Optional.of(userInfoPath);
    }

    public Optional<String> getIntrospectionPath() {
        return this.introspectionPath;
    }

    public void setIntrospectionPath(String introspectionPath) {
        this.introspectionPath = Optional.of(introspectionPath);
    }

    public Optional<String> getJwksPath() {
        return this.jwksPath;
    }

    public void setJwksPath(String jwksPath) {
        this.jwksPath = Optional.of(jwksPath);
    }

    public Optional<String> getEndSessionPath() {
        return this.endSessionPath;
    }

    public void setEndSessionPath(String endSessionPath) {
        this.endSessionPath = Optional.of(endSessionPath);
    }

    public Optional<String> getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = Optional.of(publicKey);
    }

    public Roles getRoles() {
        return this.roles;
    }

    public void setRoles(Roles roles) {
        this.roles = roles;
    }

    public Token getToken() {
        return this.token;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public Optional<String> getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = Optional.of(tenantId);
    }

    public boolean isTenantEnabled() {
        return this.tenantEnabled;
    }

    public void setTenantEnabled(boolean enabled) {
        this.tenantEnabled = enabled;
    }

    public void setLogout(Logout logout) {
        this.logout = logout;
    }

    public Logout getLogout() {
        return this.logout;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(ApplicationType type) {
        this.applicationType = type;
    }

    public static enum ApplicationType {
        WEB_APP,
        SERVICE,
        HYBRID;

    }

    @ConfigGroup
    public static class Token {
        @ConfigItem
        public Optional<String> issuer = Optional.empty();
        @ConfigItem
        public Optional<List<String>> audience = Optional.empty();
        @ConfigItem
        public Optional<String> tokenType = Optional.empty();
        @ConfigItem
        public OptionalInt lifespanGrace = OptionalInt.empty();
        @ConfigItem
        public Optional<String> principalClaim = Optional.empty();
        @ConfigItem
        public boolean refreshExpired;
        @ConfigItem
        public Optional<Duration> autoRefreshInterval = Optional.empty();
        @ConfigItem(defaultValue="10M")
        public Duration forcedJwkRefreshInterval = Duration.ofMinutes(10L);
        @ConfigItem
        public Optional<String> header = Optional.empty();

        public static Token fromIssuer(String issuer) {
            Token tokenClaims = new Token();
            tokenClaims.issuer = Optional.of(issuer);
            tokenClaims.audience = Optional.ofNullable(null);
            return tokenClaims;
        }

        public static Token fromAudience(String ... audience) {
            Token tokenClaims = new Token();
            tokenClaims.issuer = Optional.ofNullable(null);
            tokenClaims.audience = Optional.of(Arrays.asList(audience));
            return tokenClaims;
        }

        public Optional<String> getIssuer() {
            return this.issuer;
        }

        public void setIssuer(String issuer) {
            this.issuer = Optional.of(issuer);
        }

        public Optional<String> getHeader() {
            return this.header;
        }

        public void setHeader(String header) {
            this.header = Optional.of(header);
        }

        public Optional<List<String>> getAudience() {
            return this.audience;
        }

        public void setAudience(List<String> audience) {
            this.audience = Optional.of(audience);
        }

        public OptionalInt getLifespanGrace() {
            return this.lifespanGrace;
        }

        public void setLifespanGrace(int lifespanGrace) {
            this.lifespanGrace = OptionalInt.of(lifespanGrace);
        }

        public Optional<String> getPrincipalClaim() {
            return this.principalClaim;
        }

        public void setPrincipalClaim(String principalClaim) {
            this.principalClaim = Optional.of(principalClaim);
        }

        public boolean isRefreshExpired() {
            return this.refreshExpired;
        }

        public void setRefreshExpired(boolean refreshExpired) {
            this.refreshExpired = refreshExpired;
        }

        public Duration getForcedJwkRefreshInterval() {
            return this.forcedJwkRefreshInterval;
        }

        public void setForcedJwkRefreshInterval(Duration forcedJwkRefreshInterval) {
            this.forcedJwkRefreshInterval = forcedJwkRefreshInterval;
        }

        public Optional<String> getTokenType() {
            return this.tokenType;
        }

        public void setTokenType(String tokenType) {
            this.tokenType = Optional.of(tokenType);
        }
    }

    @ConfigGroup
    public static class Authentication {
        @ConfigItem
        public Optional<String> redirectPath = Optional.empty();
        @ConfigItem(defaultValue="true")
        public boolean restorePathAfterRedirect = true;
        @ConfigItem(defaultValue="true")
        public boolean removeRedirectParameters = true;
        @ConfigItem(defaultValue="false")
        public boolean verifyAccessToken;
        @ConfigItem(defaultValue="false")
        public boolean forceRedirectHttpsScheme;
        @ConfigItem
        public Optional<List<String>> scopes = Optional.empty();
        @ConfigItem
        public Map<String, String> extraParams;
        @ConfigItem(defaultValue="false")
        public boolean cookieForceSecure;
        @ConfigItem
        public Optional<String> cookiePath = Optional.empty();
        @ConfigItem
        public Optional<String> cookiePathHeader = Optional.empty();
        @ConfigItem
        public Optional<String> cookieDomain = Optional.empty();
        @ConfigItem(defaultValue="false")
        public boolean userInfoRequired;
        @ConfigItem(defaultValue="5M")
        public Duration sessionAgeExtension = Duration.ofMinutes(5L);
        @ConfigItem(defaultValue="true")
        public boolean javaScriptAutoRedirect = true;

        public boolean isJavaScriptAutoRedirect() {
            return this.javaScriptAutoRedirect;
        }

        public void setJavaScriptAutoredirect(boolean autoRedirect) {
            this.javaScriptAutoRedirect = autoRedirect;
        }

        public Optional<String> getRedirectPath() {
            return this.redirectPath;
        }

        public void setRedirectPath(String redirectPath) {
            this.redirectPath = Optional.of(redirectPath);
        }

        public Optional<List<String>> getScopes() {
            return this.scopes;
        }

        public void setScopes(Optional<List<String>> scopes) {
            this.scopes = scopes;
        }

        public Map<String, String> getExtraParams() {
            return this.extraParams;
        }

        public void setExtraParams(Map<String, String> extraParams) {
            this.extraParams = extraParams;
        }

        public boolean isForceRedirectHttpsScheme() {
            return this.forceRedirectHttpsScheme;
        }

        public void setForceRedirectHttpsScheme(boolean forceRedirectHttpsScheme) {
            this.forceRedirectHttpsScheme = forceRedirectHttpsScheme;
        }

        public boolean isRestorePathAfterRedirect() {
            return this.restorePathAfterRedirect;
        }

        public void setRestorePathAfterRedirect(boolean restorePathAfterRedirect) {
            this.restorePathAfterRedirect = restorePathAfterRedirect;
        }

        public boolean isCookieForceSecure() {
            return this.cookieForceSecure;
        }

        public void setCookieForceSecure(boolean cookieForceSecure) {
            this.cookieForceSecure = cookieForceSecure;
        }

        public Optional<String> getCookiePath() {
            return this.cookiePath;
        }

        public void setCookiePath(String cookiePath) {
            this.cookiePath = Optional.of(cookiePath);
        }

        public Optional<String> getCookieDomain() {
            return this.cookieDomain;
        }

        public void setCookieDomain(String cookieDomain) {
            this.cookieDomain = Optional.of(cookieDomain);
        }

        public boolean isUserInfoRequired() {
            return this.userInfoRequired;
        }

        public void setUserInfoRequired(boolean userInfoRequired) {
            this.userInfoRequired = userInfoRequired;
        }

        public boolean isRemoveRedirectParameters() {
            return this.removeRedirectParameters;
        }

        public void setRemoveRedirectParameters(boolean removeRedirectParameters) {
            this.removeRedirectParameters = removeRedirectParameters;
        }

        public boolean isVerifyAccessToken() {
            return this.verifyAccessToken;
        }

        public void setVerifyAccessToken(boolean verifyAccessToken) {
            this.verifyAccessToken = verifyAccessToken;
        }

        public Duration getSessionAgeExtension() {
            return this.sessionAgeExtension;
        }

        public void setSessionAgeExtension(Duration sessionAgeExtension) {
            this.sessionAgeExtension = sessionAgeExtension;
        }

        public Optional<String> getCookiePathHeader() {
            return this.cookiePathHeader;
        }

        public void setCookiePathHeader(String cookiePathHeader) {
            this.cookiePathHeader = Optional.of(cookiePathHeader);
        }
    }

    @ConfigGroup
    public static class Roles {
        @ConfigItem
        public Optional<String> roleClaimPath = Optional.empty();
        @ConfigItem
        public Optional<String> roleClaimSeparator = Optional.empty();
        @ConfigItem
        public Optional<Source> source = Optional.empty();

        public static Roles fromClaimPath(String path) {
            return Roles.fromClaimPathAndSeparator(path, null);
        }

        public static Roles fromClaimPathAndSeparator(String path, String sep) {
            Roles roles = new Roles();
            roles.roleClaimPath = Optional.ofNullable(path);
            roles.roleClaimSeparator = Optional.ofNullable(sep);
            return roles;
        }

        public Optional<String> getRoleClaimPath() {
            return this.roleClaimPath;
        }

        public void setRoleClaimPath(String roleClaimPath) {
            this.roleClaimPath = Optional.of(roleClaimPath);
        }

        public Optional<String> getRoleClaimSeparator() {
            return this.roleClaimSeparator;
        }

        public void setRoleClaimSeparator(String roleClaimSeparator) {
            this.roleClaimSeparator = Optional.of(roleClaimSeparator);
        }

        public Optional<Source> getSource() {
            return this.source;
        }

        public void setSource(Source source) {
            this.source = Optional.of(source);
        }

        public static enum Source {
            idtoken,
            accesstoken,
            userinfo;

        }
    }

    @ConfigGroup
    public static class TokenStateManager {
        @ConfigItem(defaultValue="keep_all_tokens")
        public Strategy strategy = Strategy.KEEP_ALL_TOKENS;
        @ConfigItem(defaultValue="false")
        public boolean splitTokens;

        public boolean isSplitTokens() {
            return this.splitTokens;
        }

        public void setSplitTokens(boolean spliTokens) {
            this.splitTokens = spliTokens;
        }

        public Strategy getStrategy() {
            return this.strategy;
        }

        public void setStrategy(Strategy strategy) {
            this.strategy = strategy;
        }

        public static enum Strategy {
            KEEP_ALL_TOKENS,
            ID_TOKEN,
            ID_REFRESH_TOKENS;

        }
    }

    @ConfigGroup
    public static class Logout {
        @ConfigItem
        public Optional<String> path = Optional.empty();
        @ConfigItem
        public Optional<String> postLogoutPath = Optional.empty();

        public void setPath(Optional<String> path) {
            this.path = path;
        }

        public String getPath() {
            return this.path.get();
        }

        public void setPostLogoutPath(Optional<String> postLogoutPath) {
            this.postLogoutPath = postLogoutPath;
        }

        public Optional<String> getPostLogoutPath() {
            return this.postLogoutPath;
        }
    }
}

