/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.common.runtime;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import java.time.Duration;
import java.util.Optional;

@ConfigGroup
public class OidcCommonConfig {
    @ConfigItem
    public Optional<String> authServerUrl = Optional.empty();
    @ConfigItem(defaultValue="true")
    public boolean discoveryEnabled = true;
    @ConfigItem
    public Optional<String> tokenPath = Optional.empty();
    @ConfigItem
    public Optional<String> clientId = Optional.empty();
    @ConfigItem
    public Optional<Duration> connectionDelay = Optional.empty();
    @ConfigItem(defaultValue="3")
    public int connectionRetryCount = 3;
    @ConfigItem(defaultValue="10s")
    public Duration connectionTimeout = Duration.ofSeconds(10L);
    @ConfigItem
    public Credentials credentials = new Credentials();
    @ConfigItem
    public Proxy proxy = new Proxy();
    @ConfigItem
    public Tls tls = new Tls();

    public Optional<Duration> getConnectionDelay() {
        return this.connectionDelay;
    }

    public void setConnectionDelay(Duration connectionDelay) {
        this.connectionDelay = Optional.of(connectionDelay);
    }

    public Optional<String> getAuthServerUrl() {
        return this.authServerUrl;
    }

    public void setAuthServerUrl(String authServerUrl) {
        this.authServerUrl = Optional.of(authServerUrl);
    }

    public Optional<String> getTokenPath() {
        return this.tokenPath;
    }

    public void setTokenPath(String tokenPath) {
        this.tokenPath = Optional.of(tokenPath);
    }

    public Optional<String> getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = Optional.of(clientId);
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public boolean isDiscoveryEnabled() {
        return this.discoveryEnabled;
    }

    public void setDiscoveryEnabled(boolean enabled) {
        this.discoveryEnabled = enabled;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @ConfigGroup
    public static class Proxy {
        @ConfigItem
        public Optional<String> host = Optional.empty();
        @ConfigItem(defaultValue="80")
        public int port = 80;
        @ConfigItem
        public Optional<String> username = Optional.empty();
        @ConfigItem
        public Optional<String> password = Optional.empty();
    }

    @ConfigGroup
    public static class Tls {
        @ConfigItem
        public Optional<Verification> verification = Optional.empty();

        public Optional<Verification> getVerification() {
            return this.verification;
        }

        public void setVerification(Verification verification) {
            this.verification = Optional.of(verification);
        }

        public static enum Verification {
            REQUIRED,
            NONE;

        }
    }

    @ConfigGroup
    public static class Credentials {
        @ConfigItem
        public Optional<String> secret = Optional.empty();
        @ConfigItem
        public Secret clientSecret = new Secret();
        @ConfigItem
        public Jwt jwt = new Jwt();

        public Optional<String> getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = Optional.of(secret);
        }

        public Secret getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(Secret clientSecret) {
            this.clientSecret = clientSecret;
        }

        @ConfigGroup
        public static class Jwt {
            @ConfigItem
            public Optional<String> secret = Optional.empty();
            @ConfigItem
            public Optional<String> keyFile = Optional.empty();
            @ConfigItem
            public Optional<String> keyStoreFile = Optional.empty();
            @ConfigItem(defaultValue="password")
            public String keyStorePassword;
            @ConfigItem
            public Optional<String> keyId = Optional.empty();
            @ConfigItem(defaultValue="password")
            public String keyPassword;
            @ConfigItem
            public Optional<String> tokenKeyId = Optional.empty();
            @ConfigItem(defaultValue="10")
            public int lifespan = 10;

            public Optional<String> getSecret() {
                return this.secret;
            }

            public void setSecret(String secret) {
                this.secret = Optional.of(secret);
            }

            public int getLifespan() {
                return this.lifespan;
            }

            public void setLifespan(int lifespan) {
                this.lifespan = lifespan;
            }
        }

        @ConfigGroup
        public static class Secret {
            @ConfigItem
            public Optional<String> value = Optional.empty();
            @ConfigItem
            public Optional<Method> method = Optional.empty();

            public Optional<String> getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = Optional.of(value);
            }

            public Optional<Method> getMethod() {
                return this.method;
            }

            public void setMethod(Method method) {
                this.method = Optional.of(method);
            }

            public static enum Method {
                BASIC,
                POST;

            }
        }
    }
}

