/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.netty.runtime.virtual;

import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.PlatformDependent;
import io.quarkus.netty.runtime.virtual.VirtualAddress;
import io.quarkus.netty.runtime.virtual.VirtualChannel;
import io.quarkus.netty.runtime.virtual.VirtualChannelRegistry;
import io.quarkus.netty.runtime.virtual.VirtualServerChannel;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class VirtualClientConnection {
    protected VirtualAddress address;
    protected BlockingQueue<Object> queue = new LinkedBlockingQueue<Object>();
    protected boolean connected = true;
    protected VirtualChannel peer;

    VirtualClientConnection(VirtualAddress address) {
        this.address = address;
    }

    public VirtualAddress clientAddress() {
        return this.address;
    }

    public BlockingQueue<Object> queue() {
        return this.queue;
    }

    public void close() {
        this.connected = false;
        this.peer.close();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void sendMessage(Object msg) {
        this.peer.inboundBuffer.add(msg);
        this.finishPeerRead0(this.peer);
    }

    private void finishPeerRead0(VirtualChannel peer) {
        Future<?> peerFinishReadFuture = peer.finishReadFuture;
        if (peerFinishReadFuture != null) {
            if (!peerFinishReadFuture.isDone()) {
                this.runFinishPeerReadTask(peer);
                return;
            }
            VirtualChannel.FINISH_READ_FUTURE_UPDATER.compareAndSet(peer, peerFinishReadFuture, null);
        }
        if (peer.readInProgress && !peer.inboundBuffer.isEmpty()) {
            peer.readInProgress = false;
            peer.readInbound();
        }
    }

    private void runFinishPeerReadTask(final VirtualChannel peer) {
        Runnable finishPeerReadTask = new Runnable(){

            @Override
            public void run() {
                VirtualClientConnection.this.finishPeerRead0(peer);
            }
        };
        try {
            if (peer.writeInProgress) {
                peer.finishReadFuture = peer.eventLoop().submit(finishPeerReadTask);
            } else {
                peer.eventLoop().execute(finishPeerReadTask);
            }
        }
        catch (Throwable cause) {
            this.close();
            peer.close();
            PlatformDependent.throwException((Throwable)cause);
        }
    }

    public static VirtualClientConnection connect(VirtualAddress remoteAddress) {
        Channel boundChannel = VirtualChannelRegistry.get(remoteAddress);
        if (boundChannel == null) {
            throw new RuntimeException("No virtual channel available");
        }
        if (!(boundChannel instanceof VirtualServerChannel)) {
            throw new RuntimeException("Should be virtual server channel: " + boundChannel.getClass().getName());
        }
        VirtualServerChannel serverChannel = (VirtualServerChannel)boundChannel;
        VirtualClientConnection conn = new VirtualClientConnection(remoteAddress);
        conn.peer = serverChannel.serve(conn);
        return conn;
    }
}

