/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mutiny.runtime;

import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

@Recorder
public class MutinyInfrastructure {
    public void configureMutinyInfrastructure(ExecutorService exec) {
        Infrastructure.setDefaultExecutor((Executor)exec);
    }

    public void configureDroppedExceptionHandlerAndThreadBlockingChecker() {
        final Logger logger = Logger.getLogger(MutinyInfrastructure.class);
        Infrastructure.setDroppedExceptionHandler((Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable throwable) {
                logger.error((Object)"Mutiny had to drop the following exception", throwable);
            }
        });
        Infrastructure.setCanCallerThreadBeBlockedSupplier((BooleanSupplier)new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                String threadName = Thread.currentThread().getName();
                return !threadName.contains("vertx-eventloop-thread-");
            }
        });
    }
}

