/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.quarkus.arc.Arc;
import io.quarkus.micrometer.runtime.binder.HttpBinderConfiguration;
import io.quarkus.micrometer.runtime.binder.vertx.VertxMeterBinderAdapter;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.VertxOptions;
import io.vertx.core.metrics.MetricsOptions;
import java.lang.annotation.Annotation;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

@Recorder
public class VertxMeterBinderRecorder {
    static final Logger VERTX_LOGGER = Logger.getLogger(VertxMeterBinderRecorder.class);
    static VertxMeterBinderAdapter binderAdapter = new VertxMeterBinderAdapter();
    static volatile HttpBinderConfiguration devModeConfig;

    public Consumer<VertxOptions> setVertxMetricsOptions() {
        return new Consumer<VertxOptions>(){

            @Override
            public void accept(VertxOptions vertxOptions) {
                vertxOptions.setMetricsOptions((MetricsOptions)binderAdapter);
            }
        };
    }

    public void configureBinderAdapter() {
        HttpBinderConfiguration httpConfig = (HttpBinderConfiguration)Arc.container().instance(HttpBinderConfiguration.class, new Annotation[0]).get();
        if (LaunchMode.current() == LaunchMode.DEVELOPMENT) {
            if (devModeConfig == null) {
                devModeConfig = httpConfig.unwrap();
                binderAdapter.setHttpConfig(devModeConfig);
            } else {
                devModeConfig.update(httpConfig);
            }
        } else {
            binderAdapter.setHttpConfig(httpConfig.unwrap());
        }
    }
}

