/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.quarkus.arc.Arc;
import io.quarkus.micrometer.runtime.binder.HttpBinderConfiguration;
import io.quarkus.micrometer.runtime.binder.HttpCommonTags;
import io.quarkus.micrometer.runtime.binder.RequestMetricInfo;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.spi.RestClientListener;

public class RestClientMetricsListener
implements RestClientListener {
    private static final String REQUEST_METRIC_PROPERTY = "restClientMetrics";
    private final MeterRegistry registry = Metrics.globalRegistry;
    private boolean initialized = false;
    private boolean clientMetricsEnabled = false;
    private MetricsClientRequestFilter clientRequestFilter;
    private MetricsClientResponseFilter clientResponseFilter;

    public void onNewClient(Class<?> serviceInterface, RestClientBuilder builder) {
        MicrometerConfig micrometerConfig = (MicrometerConfig)Arc.container().instance(MicrometerConfig.class, new Annotation[0]).get();
        if (!micrometerConfig.enabled) {
            return;
        }
        if (this.prepClientMetrics()) {
            builder.register((Object)this.clientRequestFilter, 3001);
            builder.register((Object)this.clientResponseFilter, 3001);
        }
    }

    boolean prepClientMetrics() {
        boolean clientMetricsEnabled = this.clientMetricsEnabled;
        if (!this.initialized) {
            HttpBinderConfiguration httpMetricsConfig = (HttpBinderConfiguration)Arc.container().instance(HttpBinderConfiguration.class, new Annotation[0]).get();
            clientMetricsEnabled = httpMetricsConfig.isClientEnabled();
            if (clientMetricsEnabled) {
                this.clientRequestFilter = new MetricsClientRequestFilter(this.registry);
                this.clientResponseFilter = new MetricsClientResponseFilter(this.registry, httpMetricsConfig);
            }
            this.clientMetricsEnabled = clientMetricsEnabled;
            this.initialized = true;
        }
        return clientMetricsEnabled;
    }

    static class RestClientMetricInfo
    extends RequestMetricInfo {
        ClientRequestContext requestContext;

        RestClientMetricInfo(ClientRequestContext requestContext) {
            this.requestContext = requestContext;
        }
    }

    static class MetricsClientResponseFilter
    implements ClientResponseFilter {
        private final MeterRegistry registry;
        private final HttpBinderConfiguration httpMetricsConfig;

        MetricsClientResponseFilter(MeterRegistry registry, HttpBinderConfiguration httpMetricsConfig) {
            this.registry = registry;
            this.httpMetricsConfig = httpMetricsConfig;
        }

        public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
            RequestMetricInfo requestMetric = this.getRequestMetric(requestContext);
            if (requestMetric != null) {
                String templatePath = (String)requestContext.getProperty("UrlPathTemplate");
                String requestPath = requestMetric.getNormalizedUriPath(this.httpMetricsConfig.getClientMatchPatterns(), this.httpMetricsConfig.getClientIgnorePatterns(), templatePath == null ? requestContext.getUri().getPath() : templatePath);
                if (requestPath != null) {
                    Timer.Sample sample = requestMetric.getSample();
                    int statusCode = responseContext.getStatus();
                    Timer.Builder builder = Timer.builder((String)this.httpMetricsConfig.getHttpClientRequestsName()).tags((Iterable)Tags.of((Tag[])new Tag[]{HttpCommonTags.method(requestContext.getMethod()), HttpCommonTags.uri(requestPath, statusCode), HttpCommonTags.outcome(statusCode), HttpCommonTags.status(statusCode), this.clientName(requestContext)}));
                    sample.stop(builder.register(this.registry));
                }
            }
        }

        private RequestMetricInfo getRequestMetric(ClientRequestContext requestContext) {
            return (RequestMetricInfo)requestContext.getProperty(RestClientMetricsListener.REQUEST_METRIC_PROPERTY);
        }

        private Tag clientName(ClientRequestContext requestContext) {
            String host = requestContext.getUri().getHost();
            if (host == null) {
                host = "none";
            }
            return Tag.of((String)"clientName", (String)host);
        }
    }

    static class MetricsClientRequestFilter
    implements ClientRequestFilter {
        private final MeterRegistry registry;

        MetricsClientRequestFilter(MeterRegistry registry) {
            this.registry = registry;
        }

        public void filter(ClientRequestContext requestContext) throws IOException {
            RestClientMetricInfo requestMetric = new RestClientMetricInfo(requestContext);
            requestMetric.setSample(Timer.start((MeterRegistry)this.registry));
            requestContext.setProperty(RestClientMetricsListener.REQUEST_METRIC_PROPERTY, (Object)requestMetric);
        }
    }
}

