/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mailer;

import io.quarkus.mailer.Attachment;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;

public class Mail {
    private List<String> bcc = new ArrayList<String>();
    private List<String> cc = new ArrayList<String>();
    private String from;
    private String replyTo;
    private String bounceAddress;
    private String subject;
    private String text;
    private String html;
    private List<String> to = new ArrayList<String>();
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private List<Attachment> attachments = new ArrayList<Attachment>();

    public static Mail withText(String to, String subject, String text) {
        return new Mail().addTo(to).setSubject(subject).setText(text);
    }

    public static Mail withHtml(String to, String subject, String html) {
        return new Mail().addTo(to).setSubject(subject).setHtml(html);
    }

    public Mail addBcc(String ... bcc) {
        if (bcc != null) {
            Collections.addAll(this.bcc, bcc);
        }
        return this;
    }

    public Mail addCc(String ... cc) {
        if (cc != null) {
            Collections.addAll(this.cc, cc);
        }
        return this;
    }

    public Mail addTo(String ... to) {
        if (to != null) {
            Collections.addAll(this.to, to);
        }
        return this;
    }

    public List<String> getBcc() {
        return this.bcc;
    }

    public Mail setBcc(List<String> bcc) {
        this.bcc = bcc == null ? new ArrayList<String>() : bcc;
        return this;
    }

    public List<String> getCc() {
        return this.cc;
    }

    public Mail setCc(List<String> cc) {
        this.cc = cc == null ? new ArrayList<String>() : cc;
        return this;
    }

    public String getFrom() {
        return this.from;
    }

    public Mail setFrom(String from) {
        this.from = from;
        return this;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public Mail setReplyTo(String replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    public String getBounceAddress() {
        return this.bounceAddress;
    }

    public Mail setBounceAddress(String bounceAddress) {
        this.bounceAddress = bounceAddress;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public Mail setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public Mail setText(String text) {
        this.text = text;
        return this;
    }

    public String getHtml() {
        return this.html;
    }

    public Mail setHtml(String html) {
        this.html = html;
        return this;
    }

    public List<String> getTo() {
        return this.to;
    }

    public Mail setTo(List<String> to) {
        this.to = to == null ? new ArrayList<String>() : to;
        return this;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public Mail addHeader(String key, String ... values) {
        if (key == null || values == null) {
            throw new IllegalArgumentException("Cannot add header, key and value must not be null");
        }
        List content = this.headers.computeIfAbsent(key, k -> new ArrayList());
        Collections.addAll(content, values);
        return this;
    }

    public Mail removeHeader(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Cannot remove header, key must not be null");
        }
        this.headers.remove(key);
        return this;
    }

    public Mail setHeaders(Map<String, List<String>> headers) {
        this.headers = headers == null ? new HashMap<String, List<String>>() : headers;
        return this;
    }

    public Mail addInlineAttachment(String name, File file, String contentType, String contentId) {
        this.attachments.add(new Attachment(name, file, contentType, contentId));
        return this;
    }

    public Mail addAttachment(String name, File file, String contentType) {
        this.attachments.add(new Attachment(name, file, contentType));
        return this;
    }

    public Mail addAttachment(String name, byte[] data, String contentType) {
        this.attachments.add(new Attachment(name, data, contentType));
        return this;
    }

    public Mail addAttachment(String name, Publisher<Byte> data, String contentType) {
        this.attachments.add(new Attachment(name, data, contentType));
        return this;
    }

    public Mail addInlineAttachment(String name, byte[] data, String contentType, String contentId) {
        this.attachments.add(new Attachment(name, data, contentType, contentId));
        return this;
    }

    public Mail addInlineAttachment(String name, Publisher<Byte> data, String contentType, String contentId) {
        this.attachments.add(new Attachment(name, data, contentType, contentId));
        return this;
    }

    public Mail addAttachment(String name, byte[] data, String contentType, String description, String disposition) {
        this.attachments.add(new Attachment(name, data, contentType, description, disposition));
        return this;
    }

    public Mail addAttachment(String name, Publisher<Byte> data, String contentType, String description, String disposition) {
        this.attachments.add(new Attachment(name, data, contentType, description, disposition));
        return this;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public Mail setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }
}

