/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.launcher;

import io.quarkus.deployment.dev.testing.TestConfig;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.DefaultDockerContainerLauncher;
import io.quarkus.test.common.DockerContainerArtifactLauncher;
import io.quarkus.test.common.TestConfigUtil;
import io.quarkus.test.junit.ArtifactTypeUtil;
import io.quarkus.test.junit.launcher.ArtifactLauncherProvider;
import io.quarkus.test.junit.launcher.DefaultInitContextBase;
import io.smallrye.config.SmallRyeConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.ServiceLoader;
import org.eclipse.microprofile.config.ConfigProvider;

public class DockerContainerLauncherProvider
implements ArtifactLauncherProvider {
    @Override
    public boolean supportsArtifactType(String type, String testProfile) {
        return ArtifactTypeUtil.isContainer(type) || ArtifactTypeUtil.isJar(type) && "test-with-native-agent".equals(testProfile);
    }

    public DockerContainerArtifactLauncher create(ArtifactLauncherProvider.CreateContext context) {
        String containerImage = context.quarkusArtifactProperties().getProperty("metadata.container-image");
        boolean pullRequired = Boolean.parseBoolean(context.quarkusArtifactProperties().getProperty("metadata.pull-required", "false"));
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        if (containerImage != null && !containerImage.isEmpty()) {
            ServiceLoader<DockerContainerArtifactLauncher> loader = ServiceLoader.load(DockerContainerArtifactLauncher.class);
            Iterator<DockerContainerArtifactLauncher> iterator = loader.iterator();
            Object launcher = iterator.hasNext() ? iterator.next() : new DefaultDockerContainerLauncher();
            this.launcherInit(context, (DockerContainerArtifactLauncher)launcher, config, containerImage, pullRequired, Optional.empty(), this.volumeMounts(config), Collections.emptyList());
            return launcher;
        }
        TestConfig testConfig = (TestConfig)config.getConfigMapping(TestConfig.class);
        if ("test-with-native-agent".equals(testConfig.integrationTestProfile())) {
            DefaultDockerContainerLauncher launcher = new DefaultDockerContainerLauncher();
            Optional<String> entryPoint = Optional.of("java");
            HashMap<String, String> volumeMounts = new HashMap<String, String>(this.volumeMounts(config));
            volumeMounts.put(context.buildOutputDirectory().toString(), "/project");
            containerImage = "quay.io/quarkus/ubi9-quarkus-mandrel-builder-image:jdk-21";
            ArrayList<String> programArgs = new ArrayList<String>();
            this.addNativeAgentProgramArgs(programArgs, context);
            this.launcherInit(context, (DockerContainerArtifactLauncher)launcher, config, containerImage, pullRequired, entryPoint, volumeMounts, programArgs);
            return launcher;
        }
        throw new IllegalStateException("The container image to be launched could not be determined");
    }

    private void launcherInit(ArtifactLauncherProvider.CreateContext context, DockerContainerArtifactLauncher launcher, SmallRyeConfig config, String containerImage, boolean pullRequired, Optional<String> entryPoint, Map<String, String> volumeMounts, List<String> programArgs) {
        TestConfig testConfig = (TestConfig)config.getConfigMapping(TestConfig.class);
        launcher.init((ArtifactLauncher.InitContext)new DefaultDockerInitContext(((OptionalInt)config.getValue("quarkus.http.test-port", OptionalInt.class)).orElse(8081), ((OptionalInt)config.getValue("quarkus.http.test-ssl-port", OptionalInt.class)).orElse(8444), testConfig.waitTime(), testConfig.integrationTestProfile(), TestConfigUtil.argLineValues((String)testConfig.argLine().orElse("")), testConfig.env(), context.devServicesLaunchResult(), containerImage, pullRequired, this.additionalExposedPorts(config), this.labels(config), volumeMounts, entryPoint, programArgs));
    }

    private void addNativeAgentProgramArgs(List<String> programArgs, ArtifactLauncherProvider.CreateContext context) {
        String outputPropertyName = System.getProperty("quarkus.test.native.agent.output.property.name", "config-output-dir");
        String outputPropertyValue = System.getProperty("quarkus.test.native.agent.output.property.value", "native-image-agent-base-config");
        String agentAdditionalArgs = System.getProperty("quarkus.test.native.agent.additional.args", "");
        String accessFilter = "access-filter-file=quarkus-access-filter.json";
        String callerFilter = "caller-filter-file=quarkus-caller-filter.json";
        String output = String.format("%s=%s", outputPropertyName, outputPropertyValue);
        String agentLibArg = String.format("-agentlib:native-image-agent=%s,%s,%s,%s", "access-filter-file=quarkus-access-filter.json", "caller-filter-file=quarkus-caller-filter.json", output, agentAdditionalArgs);
        programArgs.add(agentLibArg);
        programArgs.add("-jar");
        String jarPath = FileUtil.translateToVolumePath((String)context.quarkusArtifactProperties().getProperty("path"));
        programArgs.add(jarPath);
    }

    private Map<Integer, Integer> additionalExposedPorts(SmallRyeConfig config) {
        try {
            return config.getValues("quarkus.test.container.additional-exposed-ports", Integer.class, Integer.class);
        }
        catch (NoSuchElementException e) {
            return Collections.emptyMap();
        }
    }

    private Map<String, String> volumeMounts(SmallRyeConfig config) {
        try {
            return config.getValues("quarkus.test.container.volume-mounts", String.class, String.class);
        }
        catch (NoSuchElementException e) {
            return Collections.emptyMap();
        }
    }

    private Map<String, String> labels(SmallRyeConfig config) {
        try {
            return config.getValues("quarkus.test.container.labels", String.class, String.class);
        }
        catch (NoSuchElementException e) {
            return Collections.emptyMap();
        }
    }

    static class DefaultDockerInitContext
    extends DefaultInitContextBase
    implements DockerContainerArtifactLauncher.DockerInitContext {
        private final String containerImage;
        private final boolean pullRequired;
        private final Map<Integer, Integer> additionalExposedPorts;
        private final Optional<String> entryPoint;
        private final List<String> programArgs;
        private final Map<String, String> labels;
        private final Map<String, String> volumeMounts;

        public DefaultDockerInitContext(int httpPort, int httpsPort, Duration waitTime, String testProfile, List<String> argLine, Map<String, String> env, ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult, String containerImage, boolean pullRequired, Map<Integer, Integer> additionalExposedPorts, Map<String, String> labels, Map<String, String> volumeMounts, Optional<String> entryPoint, List<String> programArgs) {
            super(httpPort, httpsPort, waitTime, testProfile, argLine, env, devServicesLaunchResult);
            this.containerImage = containerImage;
            this.pullRequired = pullRequired;
            this.additionalExposedPorts = additionalExposedPorts;
            this.labels = labels;
            this.volumeMounts = volumeMounts;
            this.entryPoint = entryPoint;
            this.programArgs = programArgs;
        }

        public String containerImage() {
            return this.containerImage;
        }

        public boolean pullRequired() {
            return this.pullRequired;
        }

        public Map<Integer, Integer> additionalExposedPorts() {
            return this.additionalExposedPorts;
        }

        public Map<String, String> labels() {
            return this.labels;
        }

        public Map<String, String> volumeMounts() {
            return this.volumeMounts;
        }

        public Optional<String> entryPoint() {
            return this.entryPoint;
        }

        public List<String> programArgs() {
            return this.programArgs;
        }
    }
}

