/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.bootstrap.BootstrapClassLoaderFactory;
import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.DefineClassVisibleURLClassLoader;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.bootstrap.util.PropertyUtils;
import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.ClassOutput;
import io.quarkus.deployment.QuarkusClassWriter;
import io.quarkus.deployment.builditem.TestAnnotationBuildItem;
import io.quarkus.deployment.builditem.TestClassPredicateBuildItem;
import io.quarkus.deployment.util.IoUtil;
import io.quarkus.runner.RuntimeRunner;
import io.quarkus.runner.TransformerTarget;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.test.common.NativeImageLauncher;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.RestAssuredURLManager;
import io.quarkus.test.common.TestInjectionManager;
import io.quarkus.test.common.TestInstantiator;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.common.TestScopeManager;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import io.quarkus.test.junit.NativeImageTest;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.SubstrateTest;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstanceFactory;
import org.junit.jupiter.api.extension.TestInstanceFactoryContext;
import org.junit.jupiter.api.extension.TestInstantiationException;
import org.junit.platform.commons.JUnitException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.opentest4j.TestAbortedException;

public class QuarkusTestExtension
implements BeforeEachCallback,
AfterEachCallback,
TestInstanceFactory,
BeforeAllCallback {
    private URLClassLoader appCl;
    private ClassLoader originalCl;
    private static boolean failedBoot;
    private static final String CREATED_FILES = "CREATED_FILES.txt";
    private final RestAssuredURLManager restAssuredURLManager = new RestAssuredURLManager(false);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExtensionState doJavaStart(ExtensionContext context, TestResourceManager testResourceManager) {
        Path testWiringClassesDir;
        final LinkedBlockingDeque<DeleteRunnable> shutdownTasks = new LinkedBlockingDeque<DeleteRunnable>();
        Path appClassLocation = PathTestHelper.getAppClassLocation((Class)context.getRequiredTestClass());
        this.appCl = this.createQuarkusBuildClassLoader(appClassLocation);
        this.originalCl = QuarkusTestExtension.setCCL(this.appCl);
        final ClassLoader testClassLoader = context.getRequiredTestClass().getClassLoader();
        RuntimeRunner.Builder runnerBuilder = RuntimeRunner.builder();
        Path testClassLocation = PathTestHelper.getTestClassesLocation((Class)context.getRequiredTestClass());
        if (Files.isDirectory(testClassLocation, new LinkOption[0])) {
            testWiringClassesDir = testClassLocation;
        } else {
            if (!appClassLocation.equals(testClassLocation)) {
                runnerBuilder.addAdditionalArchive(testClassLocation);
            }
            if (Files.exists(testWiringClassesDir = Paths.get("", new String[0]).normalize().toAbsolutePath().resolve("target").resolve("test-classes"), new LinkOption[0])) {
                IoUtils.recursiveDelete((Path)testWiringClassesDir);
            }
            try {
                Files.createDirectories(testWiringClassesDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create a directory for wiring test classes at " + testWiringClassesDir, e);
            }
        }
        Path createdFilesPath = testWiringClassesDir.resolve(CREATED_FILES);
        if (Files.exists(createdFilesPath, new LinkOption[0])) {
            this.cleanupOldRun(createdFilesPath);
        }
        try (final OutputStream created = Files.newOutputStream(createdFilesPath, new OpenOption[0]);){
            final RuntimeRunner runtimeRunner = runnerBuilder.setLaunchMode(LaunchMode.TEST).setClassLoader((ClassLoader)this.appCl).setTarget(appClassLocation).addAdditionalArchive(testWiringClassesDir).setClassOutput(new ClassOutput(){

                public void writeClass(boolean applicationClass, String className, byte[] data) throws IOException {
                    Path location = testWiringClassesDir.resolve(className.replace('.', '/') + ".class");
                    Files.createDirectories(location.getParent(), new FileAttribute[0]);
                    Files.write(location, data, new OpenOption[0]);
                    QuarkusTestExtension.this.handleCreatedFile(location, created, testWiringClassesDir, shutdownTasks);
                }

                public void writeResource(String name, byte[] data) throws IOException {
                    Path location = testWiringClassesDir.resolve(name);
                    Files.createDirectories(location.getParent(), new FileAttribute[0]);
                    Files.write(location, data, new OpenOption[0]);
                    QuarkusTestExtension.this.handleCreatedFile(location, created, testWiringClassesDir, shutdownTasks);
                }
            }).setTransformerTarget(new TransformerTarget(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void setTransformers(Map<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> functions) {
                    final ClassLoader main = Thread.currentThread().getContextClassLoader();
                    ClassLoader temp = new ClassLoader(){

                        @Override
                        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                            Class<?> c = this.findLoadedClass(name);
                            if (c == null) {
                                c = this.findClass(name);
                            }
                            if (resolve) {
                                this.resolveClass(c);
                            }
                            return c;
                        }

                        @Override
                        public URL getResource(String name) {
                            return main.getResource(name);
                        }

                        @Override
                        public Enumeration<URL> getResources(String name) throws IOException {
                            return main.getResources(name);
                        }
                    };
                    for (Map.Entry<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> e : functions.entrySet()) {
                        String resourceName = e.getKey().replace('.', '/') + ".class";
                        try {
                            InputStream stream = temp.getResourceAsStream(resourceName);
                            Throwable throwable = null;
                            try {
                                if (stream == null) {
                                    System.err.println("Failed to transform " + e.getKey());
                                    continue;
                                }
                                byte[] data = IoUtil.readBytes((InputStream)stream);
                                ClassReader cr = new ClassReader(data);
                                QuarkusClassWriter cw = new QuarkusClassWriter(cr, 3){

                                    protected ClassLoader getClassLoader() {
                                        return main;
                                    }
                                };
                                ClassLoader old = Thread.currentThread().getContextClassLoader();
                                Thread.currentThread().setContextClassLoader(temp);
                                try {
                                    QuarkusClassWriter visitor = cw;
                                    for (BiFunction<String, ClassVisitor, ClassVisitor> i : e.getValue()) {
                                        visitor = i.apply(e.getKey(), (ClassVisitor)visitor);
                                    }
                                    cr.accept((ClassVisitor)visitor, 0);
                                }
                                finally {
                                    Thread.currentThread().setContextClassLoader(old);
                                }
                                Path location = testWiringClassesDir.resolve(resourceName);
                                Files.createDirectories(location.getParent(), new FileAttribute[0]);
                                Files.write(location, cw.toByteArray(), new OpenOption[0]);
                                QuarkusTestExtension.this.handleCreatedFile(location, created, testWiringClassesDir, shutdownTasks);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (stream == null) continue;
                                if (throwable != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                stream.close();
                            }
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }).addChainCustomizer((Consumer)new Consumer<BuildChainBuilder>(){

                @Override
                public void accept(BuildChainBuilder buildChainBuilder) {
                    buildChainBuilder.addBuildStep(new BuildStep(){

                        public void execute(BuildContext context) {
                            context.produce((BuildItem)new TestClassPredicateBuildItem((Predicate)new Predicate<String>(){

                                @Override
                                public boolean test(String className) {
                                    return PathTestHelper.isTestClass((String)className, (ClassLoader)testClassLoader);
                                }
                            }));
                        }
                    }).produces(TestClassPredicateBuildItem.class).build();
                }
            }).addChainCustomizer((Consumer)new Consumer<BuildChainBuilder>(){

                @Override
                public void accept(BuildChainBuilder buildChainBuilder) {
                    buildChainBuilder.addBuildStep(new BuildStep(){

                        public void execute(BuildContext context) {
                            context.produce((BuildItem)new TestAnnotationBuildItem(QuarkusTest.class.getName()));
                        }
                    }).produces(TestAnnotationBuildItem.class).build();
                }
            }).build();
            runtimeRunner.run();
            System.setProperty("test.url", TestHTTPResourceManager.getUri());
            final Closeable shutdownTask = new Closeable(){

                @Override
                public void close() throws IOException {
                    runtimeRunner.close();
                    while (!shutdownTasks.isEmpty()) {
                        ((Runnable)shutdownTasks.pop()).run();
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        shutdownTask.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }, "Quarkus Test Cleanup Shutdown task"));
            shutdownTasks.add(new DeleteRunnable(createdFilesPath));
            ExtensionState extensionState = new ExtensionState(testResourceManager, shutdownTask, false);
            return extensionState;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void cleanupOldRun(Path createdFilesPath) {
        try (BufferedReader reader = Files.newBufferedReader(createdFilesPath);){
            String line;
            while ((line = reader.readLine()) != null) {
                Files.deleteIfExists(createdFilesPath.getParent().resolve(line));
            }
            Files.deleteIfExists(createdFilesPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void handleCreatedFile(Path location, OutputStream created, Path testWiringClassesDir, LinkedBlockingDeque<Runnable> shutdownTasks) throws IOException {
        created.write((testWiringClassesDir.relativize(location).toString() + "\n").getBytes(StandardCharsets.UTF_8));
        created.flush();
        shutdownTasks.add(new DeleteRunnable(location));
    }

    private URLClassLoader createQuarkusBuildClassLoader(Path appClassLocation) {
        String deploymentCp = PropertyUtils.getProperty((String)"quarkus-deployment-cp");
        if (deploymentCp != null && !deploymentCp.isEmpty()) {
            ArrayList<URL> list = new ArrayList<URL>();
            for (String entry : deploymentCp.split("\\s")) {
                try {
                    list.add(new URL(entry));
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException("Failed to parse a deployment classpath entry " + entry, e);
                }
            }
            return new DefineClassVisibleURLClassLoader(list.toArray(new URL[list.size()]), this.getClass().getClassLoader());
        }
        try {
            return BootstrapClassLoaderFactory.newInstance().setAppClasses(appClassLocation).setParent(this.getClass().getClassLoader()).setOffline(PropertyUtils.getBooleanOrNull((String)"quarkus-bootstrap-offline")).setLocalProjectsDiscovery(PropertyUtils.getBoolean((String)"quarkus-workspace-discovery", (boolean)true)).setEnableClasspathCache(PropertyUtils.getBoolean((String)"quarkus-classpath-cache", (boolean)true)).newDeploymentClassLoader();
        }
        catch (BootstrapException e) {
            throw new IllegalStateException("Failed to create the boostrap class loader", e);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (!failedBoot) {
            boolean nativeImageTest = context.getRequiredTestClass().isAnnotationPresent(SubstrateTest.class) || context.getRequiredTestClass().isAnnotationPresent(NativeImageTest.class);
            this.restAssuredURLManager.clearURL();
            TestScopeManager.tearDown((boolean)nativeImageTest);
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (!failedBoot) {
            boolean nativeImageTest = context.getRequiredTestClass().isAnnotationPresent(SubstrateTest.class) || context.getRequiredTestClass().isAnnotationPresent(NativeImageTest.class);
            this.restAssuredURLManager.setURL();
            TestScopeManager.setup((boolean)nativeImageTest);
        }
    }

    public Object createTestInstance(TestInstanceFactoryContext factoryContext, ExtensionContext extensionContext) throws TestInstantiationException {
        Class testClass;
        boolean nativeImageTest;
        if (failedBoot) {
            try {
                return extensionContext.getRequiredTestClass().newInstance();
            }
            catch (Exception e) {
                throw new TestInstantiationException("Boot failed", (Throwable)e);
            }
        }
        ExtensionContext root = extensionContext.getRoot();
        ExtensionContext.Store store = root.getStore(ExtensionContext.Namespace.GLOBAL);
        ExtensionState state = (ExtensionState)store.get((Object)ExtensionState.class.getName(), ExtensionState.class);
        PropertyTestUtil.setLogFileProperty();
        boolean bl = nativeImageTest = extensionContext.getRequiredTestClass().isAnnotationPresent(SubstrateTest.class) || extensionContext.getRequiredTestClass().isAnnotationPresent(NativeImageTest.class);
        if (state == null) {
            TestResourceManager testResourceManager = new TestResourceManager(extensionContext.getRequiredTestClass());
            try {
                Map systemProps = testResourceManager.start();
                if (nativeImageTest) {
                    NativeImageLauncher launcher = new NativeImageLauncher(extensionContext.getRequiredTestClass());
                    launcher.addSystemProperties(systemProps);
                    try {
                        launcher.start();
                    }
                    catch (IOException e) {
                        try {
                            launcher.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        throw new JUnitException("Quarkus native image start failed, original cause: " + e);
                    }
                    state = new ExtensionState(testResourceManager, (Closeable)launcher, true);
                } else {
                    state = this.doJavaStart(extensionContext, testResourceManager);
                }
                store.put((Object)ExtensionState.class.getName(), (Object)state);
            }
            catch (Throwable e) {
                try {
                    testResourceManager.stop();
                }
                catch (Exception ex) {
                    e.addSuppressed(ex);
                }
                failedBoot = true;
                throw e;
            }
        }
        if (nativeImageTest != state.isNativeImage()) {
            throw new RuntimeException("Attempted to mix @NativeImageTest and JVM mode tests in the same test run. This is not allowed.");
        }
        if ((testClass = factoryContext.getTestClass()).getEnclosingClass() != null && !Modifier.isStatic(testClass.getModifiers())) {
            throw new IllegalStateException("Test class " + testClass + " cannot be a non-static inner class.");
        }
        Object instance = TestInstantiator.instantiateTest((Class)testClass);
        TestHTTPResourceManager.inject((Object)instance);
        TestInjectionManager.inject((Object)instance);
        state.testResourceManager.inject(instance);
        return instance;
    }

    private static ClassLoader setCCL(ClassLoader cl) {
        Thread thread = Thread.currentThread();
        ClassLoader original = thread.getContextClassLoader();
        thread.setContextClassLoader(cl);
        return original;
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        if (failedBoot) {
            throw new TestAbortedException("Not running test as boot failed");
        }
    }

    static class DeleteRunnable
    implements Runnable {
        final Path path;

        DeleteRunnable(Path path) {
            this.path = path;
        }

        @Override
        public void run() {
            try {
                Files.deleteIfExists(this.path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class ExtensionState
    implements ExtensionContext.Store.CloseableResource {
        private final TestResourceManager testResourceManager;
        private final Closeable resource;
        private final boolean nativeImage;

        ExtensionState(TestResourceManager testResourceManager, Closeable resource, boolean nativeImage) {
            this.testResourceManager = testResourceManager;
            this.resource = resource;
            this.nativeImage = nativeImage;
        }

        public void close() throws Throwable {
            this.testResourceManager.stop();
            try {
                this.resource.close();
            }
            finally {
                if (QuarkusTestExtension.this.originalCl != null) {
                    QuarkusTestExtension.setCCL(QuarkusTestExtension.this.originalCl);
                }
            }
            if (QuarkusTestExtension.this.appCl != null) {
                QuarkusTestExtension.this.appCl.close();
            }
        }

        @Deprecated
        public boolean isSubstrate() {
            return this.nativeImage;
        }

        public boolean isNativeImage() {
            return this.nativeImage;
        }
    }
}

