/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.database.DatabaseTypeRegister;
import org.flywaydb.core.internal.database.base.TestContainersDatabaseType;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBDatabaseType;
import org.flywaydb.core.internal.database.db2.DB2DatabaseType;
import org.flywaydb.core.internal.database.derby.DerbyDatabaseType;
import org.flywaydb.core.internal.database.firebird.FirebirdDatabaseType;
import org.flywaydb.core.internal.database.h2.H2DatabaseType;
import org.flywaydb.core.internal.database.hsqldb.HSQLDBDatabaseType;
import org.flywaydb.core.internal.database.informix.InformixDatabaseType;
import org.flywaydb.core.internal.database.mysql.MySQLDatabaseType;
import org.flywaydb.core.internal.database.mysql.mariadb.MariaDBDatabaseType;
import org.flywaydb.core.internal.database.oracle.OracleDatabaseType;
import org.flywaydb.core.internal.database.postgresql.PostgreSQLDatabaseType;
import org.flywaydb.core.internal.database.redshift.RedshiftDatabaseType;
import org.flywaydb.core.internal.database.saphana.SAPHANADatabaseType;
import org.flywaydb.core.internal.database.snowflake.SnowflakeDatabaseType;
import org.flywaydb.core.internal.database.sqlite.SQLiteDatabaseType;
import org.flywaydb.core.internal.database.sqlserver.SQLServerDatabaseType;
import org.flywaydb.core.internal.database.sqlserver.synapse.SynapseDatabaseType;
import org.flywaydb.core.internal.database.sybasease.SybaseASEJConnectDatabaseType;
import org.flywaydb.core.internal.database.sybasease.SybaseASEJTDSDatabaseType;

@TargetClass(value=DatabaseTypeRegister.class)
public final class DatabaseTypeRegisterSubstitutions {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    private static List<DatabaseType> registeredDatabaseTypes = new ArrayList<DatabaseType>();
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    private static boolean hasRegisteredDatabaseTypes = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    private static void registerDatabaseTypes() {
        List<DatabaseType> list = registeredDatabaseTypes;
        synchronized (list) {
            if (hasRegisteredDatabaseTypes) {
                return;
            }
            registeredDatabaseTypes.clear();
            registeredDatabaseTypes.add((DatabaseType)new CockroachDBDatabaseType());
            registeredDatabaseTypes.add((DatabaseType)new RedshiftDatabaseType());
            registeredDatabaseTypes.add((DatabaseType)new MariaDBDatabaseType());
            registeredDatabaseTypes.add((DatabaseType)new DB2DatabaseType());
            registeredDatabaseTypes.add((DatabaseType)new DerbyDatabaseType());
            registeredDatabaseTypes.add((DatabaseType)new FirebirdDatabaseType());
            registeredDatabaseTypes.add((DatabaseType)new H2DatabaseType());
            registeredDatabaseTypes.add((DatabaseType)new HSQLDBDatabaseType());
            registeredDatabaseTypes.add((DatabaseType)new InformixDatabaseType());
            registeredDatabaseTypes.add((DatabaseType)new MySQLDatabaseType());
            try {
                Class.forName("oracle.jdbc.OracleConnection");
                registeredDatabaseTypes.add((DatabaseType)new OracleDatabaseType());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try {
                Class.forName("org.postgresql.Driver");
                registeredDatabaseTypes.add((DatabaseType)new PostgreSQLDatabaseType());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            registeredDatabaseTypes.add((DatabaseType)new SAPHANADatabaseType());
            registeredDatabaseTypes.add((DatabaseType)new SnowflakeDatabaseType());
            registeredDatabaseTypes.add((DatabaseType)new SQLiteDatabaseType());
            registeredDatabaseTypes.add((DatabaseType)new SQLServerDatabaseType());
            registeredDatabaseTypes.add((DatabaseType)new SynapseDatabaseType());
            registeredDatabaseTypes.add((DatabaseType)new SybaseASEJConnectDatabaseType());
            registeredDatabaseTypes.add((DatabaseType)new SybaseASEJTDSDatabaseType());
            registeredDatabaseTypes.add((DatabaseType)new TestContainersDatabaseType());
            Collections.sort(registeredDatabaseTypes);
            hasRegisteredDatabaseTypes = true;
        }
    }
}

