/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment.menu;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsLocalDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.devtools.commands.AddExtensions;
import io.quarkus.devtools.commands.ListCategories;
import io.quarkus.devtools.commands.ListExtensions;
import io.quarkus.devtools.commands.RemoveExtensions;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.devui.deployment.DevUIConfig;
import io.quarkus.devui.deployment.ExtensionsBuildItem;
import io.quarkus.devui.deployment.InternalPageBuildItem;
import io.quarkus.devui.deployment.extension.ExtensionGroup;
import io.quarkus.devui.spi.buildtime.BuildTimeActionBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.registry.catalog.Extension;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class ExtensionsProcessor {
    private static final String NAMESPACE = "devui-extensions";

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    InternalPageBuildItem createExtensionsPages(ExtensionsBuildItem extensionsBuildItem, DevUIConfig config) {
        InternalPageBuildItem extensionsPages = new InternalPageBuildItem("Extensions", 10, "qwc-extensions-menu-action");
        Map<ExtensionGroup, List<io.quarkus.devui.deployment.extension.Extension>> response = Map.of(ExtensionGroup.active, extensionsBuildItem.getActiveExtensions(), ExtensionGroup.inactive, extensionsBuildItem.getInactiveExtensions());
        extensionsPages.addBuildTimeData("extensions", response, "All the extensions added to this Quarkus application. Some extensions are 'active' meaning they have actions in Dev UI, and some are 'inactive', meaning they will be listed in Dev UI, but a user can not perform any actions.For both active and inactive all sorts of information is available about the extension, like it's name, URL to the guide, GAV and much more", true, null);
        extensionsPages.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().namespace(NAMESPACE)).title("Extensions")).icon("font-awesome-solid:puzzle-piece")).componentLink("qwc-extensions.js"));
        extensionsPages.addBuildTimeData("allowExtensionManagement", config.allowExtensionManagement());
        return extensionsPages;
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    void createBuildTimeActions(BuildProducer<BuildTimeActionBuildItem> buildTimeActionProducer, LaunchModeBuildItem launchModeBuildItem, DevUIConfig config) {
        if (launchModeBuildItem.getDevModeType().isPresent() && ((DevModeType)launchModeBuildItem.getDevModeType().get()).equals((Object)DevModeType.LOCAL) && config.allowExtensionManagement()) {
            BuildTimeActionBuildItem buildTimeActions = new BuildTimeActionBuildItem(NAMESPACE);
            this.getCategories(buildTimeActions);
            this.getInstallableExtensions(buildTimeActions);
            this.listInstallableExtensions(buildTimeActions);
            this.getInstalledNamespaces(buildTimeActions);
            this.removeExtension(buildTimeActions);
            this.addExtension(buildTimeActions);
            buildTimeActionProducer.produce((BuildItem)buildTimeActions);
        }
    }

    private void getCategories(BuildTimeActionBuildItem buildTimeActions) {
        buildTimeActions.actionBuilder().methodName(new Object(){}.getClass().getEnclosingMethod().getName()).description("Get all available categories for the Quarkus Extension List").function(ignored -> CompletableFuture.supplyAsync(() -> {
            try {
                QuarkusCommandOutcome outcome = new ListCategories(this.getQuarkusProject()).format("object").execute();
                if (outcome.isSuccess()) {
                    return outcome.getResult();
                }
            }
            catch (QuarkusCommandException ex) {
                throw new RuntimeException(ex);
            }
            return null;
        })).build();
    }

    private void getInstallableExtensions(BuildTimeActionBuildItem buildTimeActions) {
        buildTimeActions.actionBuilder().methodName(new Object(){}.getClass().getEnclosingMethod().getName()).function(ignored -> CompletableFuture.supplyAsync(() -> this.listExtensionInQuarkusProject())).build();
    }

    private void listInstallableExtensions(BuildTimeActionBuildItem buildTimeActions) {
        buildTimeActions.actionBuilder().methodName(new Object(){}.getClass().getEnclosingMethod().getName()).description("Get all extensions that can be added to the current project (i.e it's not currently added to the pom)").function(ignored -> CompletableFuture.supplyAsync(() -> {
            ArrayList filtered = new ArrayList();
            for (Extension e : this.listExtensionInQuarkusProject()) {
                HashMap<String, String> entry = new HashMap<String, String>();
                entry.put("name", e.getName());
                entry.put("description", e.getDescription());
                entry.put("extensionArtifactId", e.getArtifact().toCompactCoords());
                filtered.add(entry);
            }
            return filtered;
        })).enableMcpFuctionByDefault().build();
    }

    private List<Extension> listExtensionInQuarkusProject() throws RuntimeException {
        try {
            QuarkusCommandOutcome outcome = new ListExtensions(this.getQuarkusProject()).installed(false).all(false).format("object").execute();
            if (outcome.isSuccess()) {
                return (List)outcome.getResult();
            }
            return null;
        }
        catch (QuarkusCommandException e) {
            throw new RuntimeException(e);
        }
    }

    private void getInstalledNamespaces(BuildTimeActionBuildItem buildTimeActions) {
        buildTimeActions.actionBuilder().methodName(new Object(){}.getClass().getEnclosingMethod().getName()).description("Get all extensions that is already part of the current project (i.e it's currently in the pom)").function(ignored -> CompletableFuture.supplyAsync(() -> {
            try {
                QuarkusCommandOutcome outcome = new ListExtensions(this.getQuarkusProject()).installed(true).all(false).format("object").execute();
                if (outcome.isSuccess()) {
                    List extensionList = (List)outcome.getResult();
                    ArrayList<CallSite> namespaceList = new ArrayList<CallSite>();
                    if (!extensionList.isEmpty()) {
                        for (Extension e : extensionList) {
                            String groupId = e.getArtifact().getGroupId();
                            String artifactId = e.getArtifact().getArtifactId();
                            namespaceList.add((CallSite)((Object)(groupId + "." + artifactId)));
                        }
                    }
                    return namespaceList;
                }
                return null;
            }
            catch (IllegalStateException e) {
                return null;
            }
            catch (QuarkusCommandException e) {
                throw new RuntimeException(e);
            }
        })).build();
    }

    private void removeExtension(BuildTimeActionBuildItem buildTimeActions) {
        buildTimeActions.actionBuilder().methodName(new Object(){}.getClass().getEnclosingMethod().getName()).description("Remove a certain extension from the current project (i.e remove it from the pom)").parameter("extensionArtifactId", "The gav string of the extension to remove in format groupId:artifactId:version").function(params -> CompletableFuture.supplyAsync(() -> {
            String extensionArtifactId = (String)params.get("extensionArtifactId");
            try {
                QuarkusCommandOutcome outcome = new RemoveExtensions(this.getQuarkusProject()).extensions(Set.of(extensionArtifactId)).execute();
                return outcome.isSuccess();
            }
            catch (QuarkusCommandException e) {
                throw new RuntimeException(e);
            }
        })).enableMcpFuctionByDefault().build();
    }

    private void addExtension(BuildTimeActionBuildItem buildTimeActions) {
        buildTimeActions.actionBuilder().methodName(new Object(){}.getClass().getEnclosingMethod().getName()).description("Adds a certain extension to the current project (i.e add it from the pom)").parameter("extensionArtifactId", "The gav string of the extension to remove in format groupId:artifactId:version").function(params -> CompletableFuture.supplyAsync(() -> {
            String extensionArtifactId = (String)params.get("extensionArtifactId");
            try {
                QuarkusCommandOutcome outcome = new AddExtensions(this.getQuarkusProject()).extensions(Set.of(extensionArtifactId)).execute();
                return outcome.isSuccess();
            }
            catch (QuarkusCommandException e) {
                throw new RuntimeException(e);
            }
        })).enableMcpFuctionByDefault().build();
    }

    private QuarkusProject getQuarkusProject() {
        String gradlePath = System.getProperty("gradle.project.path");
        Path projectRoot = gradlePath != null ? Path.of(gradlePath, new String[0]) : Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath().normalize();
        return QuarkusProjectHelper.getCachedProject((Path)projectRoot);
    }
}

