/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog.json;

import io.quarkus.registry.catalog.Category;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.ExtensionOrigin;
import io.quarkus.registry.catalog.json.JsonExtensionCatalog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;

public class JsonCatalogMerger {
    public static ExtensionCatalog merge(List<ExtensionCatalog> catalogs) {
        if (catalogs.isEmpty()) {
            throw new IllegalArgumentException("No catalogs provided");
        }
        if (catalogs.size() == 1) {
            return catalogs.get(0);
        }
        List<ExtensionCatalog> roots = JsonCatalogMerger.detectRoots(catalogs);
        if (roots.size() == 1) {
            return roots.get(0);
        }
        JsonExtensionCatalog combined = new JsonExtensionCatalog();
        LinkedHashMap categories = new LinkedHashMap();
        LinkedHashMap<String, ExtensionCatalog> derivedFrom = new LinkedHashMap<String, ExtensionCatalog>();
        LinkedHashMap extensions = new LinkedHashMap();
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        for (ExtensionCatalog catalog : roots) {
            if (combined.getBom() == null) {
                combined.setBom(catalog.getBom());
            }
            if (catalog.getId() != null) {
                derivedFrom.putIfAbsent(catalog.getId(), catalog);
            }
            catalog.getDerivedFrom().forEach(o -> derivedFrom.putIfAbsent(o.getId(), (ExtensionCatalog)o));
            catalog.getCategories().forEach(c -> categories.putIfAbsent(c.getId(), c));
            catalog.getExtensions().forEach(e -> extensions.putIfAbsent(e.getArtifact().getKey(), e));
            catalog.getMetadata().entrySet().forEach(entry -> metadata.putIfAbsent((String)entry.getKey(), entry.getValue()));
            if (combined.getQuarkusCoreVersion() == null && catalog.getQuarkusCoreVersion() != null) {
                combined.setQuarkusCoreVersion(catalog.getQuarkusCoreVersion());
            }
            if (combined.getUpstreamQuarkusCoreVersion() != null || catalog.getUpstreamQuarkusCoreVersion() == null || combined.getQuarkusCoreVersion().equals(catalog.getUpstreamQuarkusCoreVersion())) continue;
            combined.setUpstreamQuarkusCoreVersion(catalog.getUpstreamQuarkusCoreVersion());
        }
        combined.setCategories(new ArrayList<Category>(categories.values()));
        combined.setDerivedFrom(new ArrayList<ExtensionOrigin>(derivedFrom.values()));
        combined.setExtensions(new ArrayList<Extension>(extensions.values()));
        combined.setMetadata(metadata);
        return combined;
    }

    private static List<ExtensionCatalog> detectRoots(List<ExtensionCatalog> catalogs) {
        HashSet<String> allDerivedFrom = new HashSet<String>(catalogs.size());
        for (ExtensionCatalog catalog : catalogs) {
            for (ExtensionOrigin o : catalog.getDerivedFrom()) {
                allDerivedFrom.add(o.getId());
            }
        }
        ArrayList<ExtensionCatalog> roots = new ArrayList<ExtensionCatalog>(catalogs.size());
        for (ExtensionCatalog catalog : catalogs) {
            if (catalog.getId() == null) {
                roots.add(catalog);
                continue;
            }
            if (allDerivedFrom.contains(catalog.getId())) continue;
            roots.add(catalog);
        }
        return roots;
    }
}

