/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.update.rewrite;

import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.update.rewrite.RewriteOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class QuarkusUpdateRecipe {
    public static final String RECIPE_IO_QUARKUS_OPENREWRITE_QUARKUS = "io.quarkus.openrewrite.Quarkus";
    public static final Map<String, Object> QUARKUS_RECIPE = Map.of("type", "specs.openrewrite.org/v1beta/recipe", "name", "io.quarkus.openrewrite.Quarkus", "displayName", "Migrate quarkus project to a new version", "description", "Update Quarkus version and refactor imports and resources if needed.", "tags", List.of("quarkus"));
    public static final String RECIPE_LIST_KEY = "recipeList";
    private BuildTool buildTool = BuildTool.MAVEN;
    private final List<RewriteOperation> operations = new ArrayList<RewriteOperation>();
    private final List<Map<String, Object>> recipes = new ArrayList<Map<String, Object>>();

    public QuarkusUpdateRecipe buildTool(BuildTool buildTool) {
        this.buildTool = buildTool;
        return this;
    }

    public QuarkusUpdateRecipe addOperation(RewriteOperation operation) {
        this.operations.add(operation);
        return this;
    }

    public QuarkusUpdateRecipe addRecipes(List<Object> recipe) {
        for (Object r : recipe) {
            if (!(r instanceof Map)) continue;
            this.addRecipe((Map)r);
        }
        return this;
    }

    public QuarkusUpdateRecipe addRecipe(Map<String, Object> recipe) {
        Objects.requireNonNull(recipe, "recipe is required");
        if (!recipe.containsKey("name") || !(recipe.get("name") instanceof String)) {
            throw new IllegalArgumentException("Recipe name is required");
        }
        this.recipes.add(recipe);
        return this;
    }

    public BuildTool getBuildTool() {
        return this.buildTool;
    }

    public List<RewriteOperation> getOperations() {
        return this.operations;
    }

    public List<Map<String, Object>> getRecipes() {
        return this.recipes;
    }

    public List<String> getOtherRecipeNames() {
        return this.recipes.stream().map(r -> (String)r.get("name")).collect(Collectors.toList());
    }
}

