/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.quarkus;

import io.quarkus.devtools.codestarts.Codestart;
import io.quarkus.devtools.codestarts.CodestartCatalogLoader;
import io.quarkus.devtools.codestarts.CodestartException;
import io.quarkus.devtools.codestarts.CodestartProjectInput;
import io.quarkus.devtools.codestarts.CodestartResourceLoader;
import io.quarkus.devtools.codestarts.CodestartStructureException;
import io.quarkus.devtools.codestarts.CodestartType;
import io.quarkus.devtools.codestarts.DataKey;
import io.quarkus.devtools.codestarts.core.CodestartCatalogs;
import io.quarkus.devtools.codestarts.core.GenericCodestartCatalog;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartProjectInput;
import io.quarkus.devtools.project.CodestartResourceLoadersBuilder;
import io.quarkus.devtools.project.extensions.Extensions;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.platform.catalog.processor.ExtensionProcessor;
import io.quarkus.platform.descriptor.loader.json.ResourceLoader;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.smallrye.common.version.VersionScheme;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class QuarkusCodestartCatalog
extends GenericCodestartCatalog<QuarkusCodestartProjectInput> {
    public static final String QUARKUS_CODESTARTS_DIR = "codestarts/quarkus";
    public static final String INPUT_SELECTED_EXTENSIONS_KEY = "selected-extensions";
    public static final String INPUT_SELECTED_EXTENSIONS_GA_KEY = "selected-extensions-ga";
    public static final String INPUT_PROVIDED_CODE_KEY = "provided-code";
    private static final String IO_QUARKUS_GROUP_ID = "io.quarkus";
    private static final String IO_QUARKUS_PLATFORM_GROUP_ID = "io.quarkus.platform";
    private static final String COM_REDHAT_QUARKUS_PLATFORM_GROUP_ID = "com.redhat.quarkus.platform";
    private static final String QUARKUS_BOM = "quarkus-bom";
    private static final String QUARKUS_UNIVERSE_BOM = "quarkus-universe-bom";
    private static final Set<String> LANGUAGE_EXTENSIONS = Set.of("quarkus-kotlin", "quarkus-scala");
    private final Map<String, Extension> extensionsMapping;

    private QuarkusCodestartCatalog(Collection<Codestart> codestarts, Map<String, Extension> extensionsMapping) {
        super(codestarts);
        this.extensionsMapping = extensionsMapping;
    }

    public static QuarkusCodestartCatalog fromBaseCodestartsResources(Map<String, Extension> extensionsMapping) throws IOException {
        Map<String, Codestart> codestarts = CodestartResourceLoader.loadCodestartsFromResources(CodestartResourceLoadersBuilder.getCodestartResourceLoaders(), QUARKUS_CODESTARTS_DIR);
        return new QuarkusCodestartCatalog(codestarts.values(), extensionsMapping);
    }

    public static QuarkusCodestartCatalog fromBaseCodestartsResources() throws IOException {
        return QuarkusCodestartCatalog.fromBaseCodestartsResources(Collections.emptyMap());
    }

    public static QuarkusCodestartCatalog fromExtensionsCatalogAndDirectories(ExtensionCatalog catalog, Collection<Path> directories) throws IOException {
        List<ResourceLoader> loaders = CodestartResourceLoadersBuilder.getCodestartResourceLoaders(catalog);
        Map<String, Codestart> codestarts = CodestartResourceLoader.loadCodestartsFromResources(loaders, QUARKUS_CODESTARTS_DIR);
        for (Path directory : directories) {
            Map dirCodestarts = CodestartCatalogLoader.loadCodestartsFromDir((Path)directory).stream().collect(Collectors.toMap(Codestart::getName, Function.identity()));
            codestarts.putAll(dirCodestarts);
        }
        Map<String, Extension> extensionsMapping = QuarkusCodestartCatalog.buildExtensionsMapping(catalog.getExtensions());
        return new QuarkusCodestartCatalog(codestarts.values(), extensionsMapping);
    }

    public static QuarkusCodestartCatalog fromExtensionsCatalog(ExtensionCatalog catalog, List<ResourceLoader> codestartResourceLoaders) throws IOException {
        Map<String, Codestart> codestarts = CodestartResourceLoader.loadCodestartsFromResources(codestartResourceLoaders, QUARKUS_CODESTARTS_DIR);
        Map<String, Extension> extensionCodestartMapping = QuarkusCodestartCatalog.buildExtensionsMapping(catalog.getExtensions());
        return new QuarkusCodestartCatalog(codestarts.values(), extensionCodestartMapping);
    }

    protected Collection<Codestart> select(QuarkusCodestartProjectInput projectInput) {
        long examples;
        projectInput.getSelection().addNames(this.getExtensionCodestarts(projectInput));
        projectInput.getSelection().addNames(this.getToolingCodestarts(projectInput));
        if (projectInput.getExample() != null) {
            projectInput.getSelection().addName(projectInput.getExample());
        }
        List projectCodestarts = super.select((CodestartProjectInput)projectInput).stream().filter(c -> c.getType() != CodestartType.CODE || projectInput.getAppContent().contains((Object)AppContent.CODE)).filter(c -> !QuarkusCodestartCatalog.isExample(c) || projectInput.getExample() == null || c.matches(projectInput.getExample())).collect(Collectors.toCollection(ArrayList::new));
        Optional<ExtensionCodestart> selectedDefaultCodeStart = this.getSelectedDefaultCodeStart(projectInput);
        if (projectInput.getAppContent().contains((Object)AppContent.CODE) && selectedDefaultCodeStart.isPresent() && projectCodestarts.stream().noneMatch(c -> c.getType() == CodestartType.CODE && !c.getSpec().isPreselected())) {
            String languageName;
            Codestart defaultCodestart = this.codestarts.stream().filter(c -> c.matches(((ExtensionCodestart)((Object)((Object)selectedDefaultCodeStart.get()))).key())).findFirst().orElseThrow(() -> new CodestartStructureException(((ExtensionCodestart)((Object)((Object)selectedDefaultCodeStart.get()))).key() + " codestart not found"));
            if (defaultCodestart.implementsLanguage(languageName = CodestartCatalogs.findLanguageName((Collection)projectCodestarts))) {
                projectCodestarts.add(defaultCodestart);
            } else {
                projectInput.log().warn(defaultCodestart.getName() + " codestart will not be applied (doesn't implement language '" + languageName + "' yet)");
            }
        }
        if ((examples = projectCodestarts.stream().filter(QuarkusCodestartCatalog::isExample).count()) == 1L) {
            projectCodestarts.removeIf(QuarkusCodestartCatalog::isExtensionCodestart);
        } else if (examples > 1L) {
            throw new CodestartException("Only example can be selected at a time (you can always use 'noCode' if needed)");
        }
        projectInput.getData().putAll(this.generateSelectionData(projectInput, projectCodestarts));
        return projectCodestarts;
    }

    private Optional<ExtensionCodestart> getSelectedDefaultCodeStart(QuarkusCodestartProjectInput projectInput) {
        Optional<ArtifactCoords> quarkusBom = projectInput.getBoms().stream().map(ArtifactCoords::fromString).filter(b -> this.isCoreBom((ArtifactCoords)b) || this.isPlatformBom((ArtifactCoords)b) || this.isUniverseBom((ArtifactCoords)b)).findFirst();
        String bomVersion = null;
        if (quarkusBom.isPresent()) {
            bomVersion = quarkusBom.get().getVersion();
        }
        if (bomVersion == null || VersionScheme.MAVEN.compare(bomVersion, "2.8") >= 0) {
            if (projectInput.getExtensions().isEmpty() || projectInput.getExtensions().size() == 1 && this.isLanguageExtension(projectInput.getExtensions().iterator().next())) {
                return Optional.of(ExtensionCodestart.RESTEASY_REACTIVE);
            }
            return Optional.empty();
        }
        return Optional.of(ExtensionCodestart.RESTEASY);
    }

    private boolean isCoreBom(ArtifactCoords artifactCoords) {
        return IO_QUARKUS_GROUP_ID.equals(artifactCoords.getGroupId()) && QUARKUS_BOM.equals(artifactCoords.getArtifactId());
    }

    private boolean isUniverseBom(ArtifactCoords artifactCoords) {
        return IO_QUARKUS_GROUP_ID.equals(artifactCoords.getGroupId()) && QUARKUS_UNIVERSE_BOM.equals(artifactCoords.getArtifactId());
    }

    private boolean isPlatformBom(ArtifactCoords artifactCoords) {
        return (IO_QUARKUS_PLATFORM_GROUP_ID.equals(artifactCoords.getGroupId()) || COM_REDHAT_QUARKUS_PLATFORM_GROUP_ID.equals(artifactCoords.getGroupId())) && QUARKUS_BOM.equals(artifactCoords.getArtifactId());
    }

    private boolean isLanguageExtension(ArtifactCoords artifactCoords) {
        return IO_QUARKUS_GROUP_ID.equals(artifactCoords.getGroupId()) && LANGUAGE_EXTENSIONS.contains(artifactCoords.getArtifactId());
    }

    private Set<String> getExtensionCodestarts(QuarkusCodestartProjectInput projectInput) {
        return this.getSelectedExtensionsAsStream(projectInput).map(ExtensionProcessor::getCodestartName).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private Stream<Extension> getSelectedExtensionsAsStream(QuarkusCodestartProjectInput projectInput) {
        return projectInput.getExtensions().stream().map(Extensions::toGA).filter(this.extensionsMapping::containsKey).map(this.extensionsMapping::get);
    }

    private List<String> getToolingCodestarts(QuarkusCodestartProjectInput projectInput) {
        ArrayList<String> codestarts = new ArrayList<String>();
        codestarts.add(projectInput.getBuildTool().getKey());
        if (projectInput.getAppContent().contains((Object)AppContent.BUILD_TOOL_WRAPPER)) {
            switch (projectInput.getBuildTool()) {
                case GRADLE: 
                case GRADLE_KOTLIN_DSL: {
                    codestarts.add(Tooling.TOOLING_GRADLE_WRAPPER.key());
                    break;
                }
                case MAVEN: {
                    codestarts.add(Tooling.TOOLING_MAVEN_WRAPPER.key());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported build tool wrapper: " + projectInput.getBuildTool());
                }
            }
        }
        if (projectInput.getAppContent().contains((Object)AppContent.DOCKERFILES)) {
            codestarts.add(Tooling.TOOLING_DOCKERFILES.key());
        }
        return codestarts;
    }

    private Map<String, Object> generateSelectionData(QuarkusCodestartProjectInput projectInput, List<Codestart> projectCodestarts) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        HashMap inputData = new HashMap();
        inputData.put(INPUT_PROVIDED_CODE_KEY, projectCodestarts.stream().filter(c -> c.getType() == CodestartType.CODE).map(c -> {
            HashMap<String, Object> eData = new HashMap<String, Object>();
            eData.put("name", c.getName());
            eData.put("tags", c.getTags());
            eData.putAll(c.getMetadata());
            return eData;
        }).collect(Collectors.toList()));
        inputData.put(INPUT_SELECTED_EXTENSIONS_GA_KEY, this.getSelectedExtensionsAsStream(projectInput).map(Extension::managementKey).collect(Collectors.toSet()));
        inputData.put(INPUT_SELECTED_EXTENSIONS_KEY, this.getSelectedExtensionsAsStream(projectInput).map(e -> {
            HashMap<String, String> eData = new HashMap<String, String>();
            eData.put("name", e.getName());
            eData.put("description", e.getDescription());
            eData.put("guide", ExtensionProcessor.getGuide(e));
            return eData;
        }).collect(Collectors.toList()));
        data.put("input", inputData);
        return data;
    }

    public static boolean isExtensionCodestart(Codestart codestart) {
        return codestart.getType() == CodestartType.CODE && codestart.containsTag(Tag.EXTENSION_CODESTART.key());
    }

    public static boolean isExample(Codestart codestart) {
        return codestart.getType() == CodestartType.CODE && codestart.containsTag(Tag.EXAMPLE.key());
    }

    public static Map<String, Extension> buildExtensionsMapping(Collection<Extension> extensions) {
        HashMap<String, Extension> map = new HashMap<String, Extension>(extensions.size());
        extensions.forEach(e -> map.put(e.getArtifact().getGroupId() + ":" + e.getArtifact().getArtifactId(), (Extension)e));
        return map;
    }

    public static enum AppContent implements DataKey
    {
        BUILD_TOOL_WRAPPER,
        DOCKERFILES,
        CODE;

    }

    public static enum ExtensionCodestart implements DataKey
    {
        RESTEASY,
        RESTEASY_REACTIVE,
        SPRING_WEB;

    }

    public static enum Tooling implements DataKey
    {
        TOOLING_GRADLE_WRAPPER,
        TOOLING_MAVEN_WRAPPER,
        TOOLING_DOCKERFILES,
        TOOLING_GITHUB_ACTION;

    }

    public static enum Tag implements DataKey
    {
        EXTENSION_CODESTART,
        EXAMPLE,
        MAVEN_ONLY;

    }

    public static enum Language implements DataKey
    {
        JAVA,
        KOTLIN,
        SCALA;

    }
}

