/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts;

import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.dependencies.Extension;
import io.quarkus.devtools.codestarts.Codestart;
import io.quarkus.devtools.codestarts.CodestartCatalogLoader;
import io.quarkus.devtools.codestarts.CodestartPathLoader;
import io.quarkus.devtools.codestarts.CodestartProjectDefinition;
import io.quarkus.devtools.codestarts.CodestartProjectInput;
import io.quarkus.devtools.codestarts.CodestartStructureException;
import io.quarkus.devtools.codestarts.CodestartType;
import io.quarkus.devtools.codestarts.QuarkusCodestartProjectInput;
import io.quarkus.devtools.codestarts.core.CodestartCatalogs;
import io.quarkus.devtools.codestarts.core.GenericCodestartCatalog;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class QuarkusCodestartCatalog
extends GenericCodestartCatalog<QuarkusCodestartProjectInput> {
    public static final String QUARKUS_CODESTARTS_DIR = "codestarts/quarkus";
    private final Map<AppArtifactKey, String> extensionCodestartMapping;

    private QuarkusCodestartCatalog(Collection<Codestart> codestarts, Map<AppArtifactKey, String> extensionCodestartMapping) {
        super(codestarts);
        this.extensionCodestartMapping = extensionCodestartMapping;
    }

    public static QuarkusCodestartCatalog fromQuarkusPlatformDescriptor(QuarkusPlatformDescriptor platformDescriptor) throws IOException {
        CodestartPathLoader pathLoader = QuarkusCodestartCatalog.platformPathLoader(platformDescriptor);
        Collection codestarts = CodestartCatalogLoader.loadCodestarts((CodestartPathLoader)pathLoader, (String)QUARKUS_CODESTARTS_DIR);
        Map<AppArtifactKey, String> extensionCodestartMapping = QuarkusCodestartCatalog.buildCodestartMapping(platformDescriptor.getExtensions());
        return new QuarkusCodestartCatalog(codestarts, extensionCodestartMapping);
    }

    public static QuarkusCodestartCatalog fromQuarkusPlatformDescriptorAndDirectories(QuarkusPlatformDescriptor platformDescriptor, Collection<Path> directories) throws IOException {
        CodestartPathLoader pathLoader = QuarkusCodestartCatalog.platformPathLoader(platformDescriptor);
        ArrayList<Codestart> codestarts = new ArrayList<Codestart>(CodestartCatalogLoader.loadCodestarts((CodestartPathLoader)pathLoader, (String)QUARKUS_CODESTARTS_DIR));
        for (Path directory : directories) {
            codestarts.addAll(CodestartCatalogLoader.loadUserDirectoryCodestarts((Path)directory));
        }
        Map<AppArtifactKey, String> extensionCodestartMapping = QuarkusCodestartCatalog.buildCodestartMapping(platformDescriptor.getExtensions());
        return new QuarkusCodestartCatalog(codestarts, extensionCodestartMapping);
    }

    public CodestartProjectDefinition createProject(QuarkusCodestartProjectInput projectInput) {
        return super.createProject((CodestartProjectInput)projectInput);
    }

    protected Collection<Codestart> select(QuarkusCodestartProjectInput projectInput) {
        projectInput.getSelection().addNames(this.getExtensionCodestarts(projectInput));
        projectInput.getSelection().addNames(this.getToolingCodestarts(projectInput));
        List projectCodestarts = super.select((CodestartProjectInput)projectInput).stream().filter(c -> !QuarkusCodestartCatalog.isExample(c) || !projectInput.noExamples()).collect(Collectors.toCollection(ArrayList::new));
        if (!projectInput.noExamples() && projectCodestarts.stream().noneMatch(c -> QuarkusCodestartCatalog.isExample(c) && !c.getSpec().isPreselected())) {
            String languageName;
            Codestart commandModeCodestart = this.codestarts.stream().filter(c -> c.isSelected(Collections.singleton(Example.COMMANDMODE_EXAMPLE.getKey()))).findFirst().orElseThrow(() -> new CodestartStructureException(Example.COMMANDMODE_EXAMPLE.getKey() + " codestart not found"));
            if (commandModeCodestart.implementsLanguage(languageName = CodestartCatalogs.findLanguageName((Collection)projectCodestarts))) {
                projectCodestarts.add(commandModeCodestart);
            } else {
                projectInput.log().warn(commandModeCodestart.getName() + " codestart will not be applied (doesn't implement language '" + languageName + "' yet)");
            }
        }
        return projectCodestarts;
    }

    private Set<String> getExtensionCodestarts(QuarkusCodestartProjectInput projectInput) {
        return projectInput.getDependencies().stream().filter(this.extensionCodestartMapping::containsKey).map(this.extensionCodestartMapping::get).collect(Collectors.toSet());
    }

    private List<String> getToolingCodestarts(QuarkusCodestartProjectInput projectInput) {
        ArrayList<String> codestarts = new ArrayList<String>();
        codestarts.add(projectInput.getBuildTool().getKey());
        if (!projectInput.noBuildToolWrapper()) {
            switch (projectInput.getBuildTool()) {
                case GRADLE: 
                case GRADLE_KOTLIN_DSL: {
                    codestarts.add(Tooling.GRADLE_WRAPPER.getKey());
                    break;
                }
                case MAVEN: {
                    codestarts.add(Tooling.MAVEN_WRAPPER.getKey());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported build tool wrapper: " + (Object)((Object)projectInput.getBuildTool()));
                }
            }
        }
        if (!projectInput.noDockerfiles()) {
            codestarts.add(Tooling.DOCKERFILES.getKey());
        }
        return codestarts;
    }

    public static CodestartPathLoader platformPathLoader(QuarkusPlatformDescriptor platformDescr) {
        return new QuarkusPlatformCodestartResourceLoader(platformDescr);
    }

    public static boolean isExample(Codestart codestart) {
        return codestart.getType() == CodestartType.CODE && codestart.getSpec().getTags().contains(Tag.EXAMPLE.getKey());
    }

    private static Map<AppArtifactKey, String> buildCodestartMapping(Collection<Extension> extensions) {
        return extensions.stream().filter(e -> e.getCodestart() != null).collect(Collectors.toMap(e -> new AppArtifactKey(e.getGroupId(), e.getArtifactId(), e.getClassifier(), e.getType() == null ? "jar" : e.getType()), Extension::getCodestart));
    }

    static interface KeySupplier {
        default public String getKey() {
            return this.toString().toLowerCase().replace("_", "-");
        }
    }

    private static class QuarkusPlatformCodestartResourceLoader
    implements CodestartPathLoader {
        private QuarkusPlatformDescriptor platformDescr;

        QuarkusPlatformCodestartResourceLoader(QuarkusPlatformDescriptor platformDescr) {
            this.platformDescr = platformDescr;
        }

        public <T> T loadResourceAsPath(String name, CodestartPathLoader.PathConsumer<T> consumer) throws IOException {
            return (T)this.platformDescr.loadResourceAsPath(name, arg_0 -> consumer.consume(arg_0));
        }
    }

    public static enum Example implements KeySupplier
    {
        RESTEASY_EXAMPLE,
        COMMANDMODE_EXAMPLE;

    }

    public static enum Tooling implements KeySupplier
    {
        GRADLE_WRAPPER,
        MAVEN_WRAPPER,
        DOCKERFILES;

    }

    public static enum Language implements KeySupplier
    {
        JAVA,
        KOTLIN,
        SCALA;

    }

    public static enum Tag implements KeySupplier
    {
        EXAMPLE,
        COMPATIBILITY_ISSUES,
        MAVEN_ONLY;

    }
}

