/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkus.registry.model.ArtifactKey;
import io.quarkus.registry.model.Extension;
import io.quarkus.registry.model.ModifiableExtension;
import io.quarkus.registry.model.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;

public final class ImmutableExtension
implements Extension {
    private final ArtifactKey id;
    private final String name;
    @Nullable
    private final String description;
    private final Map<String, Object> metadata;
    private final SortedSet<Extension.ExtensionRelease> releases;

    private ImmutableExtension(ArtifactKey id, String name, @Nullable String description, Map<String, Object> metadata, SortedSet<Extension.ExtensionRelease> releases) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.metadata = metadata;
        this.releases = releases;
    }

    @Override
    @JsonProperty(value="id")
    @JsonUnwrapped
    public ArtifactKey getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="metadata")
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="releases")
    public SortedSet<Extension.ExtensionRelease> getReleases() {
        return this.releases;
    }

    public final ImmutableExtension withId(ArtifactKey value) {
        if (this.id == value) {
            return this;
        }
        ArtifactKey newValue = Objects.requireNonNull(value, "id");
        return new ImmutableExtension(newValue, this.name, this.description, this.metadata, this.releases);
    }

    public final ImmutableExtension withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableExtension(this.id, newValue, this.description, this.metadata, this.releases);
    }

    public final ImmutableExtension withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableExtension(this.id, this.name, value, this.metadata, this.releases);
    }

    public final ImmutableExtension withMetadata(Map<String, ? extends Object> entries) {
        if (this.metadata == entries) {
            return this;
        }
        Map<String, Object> newValue = ImmutableExtension.createUnmodifiableMap(true, false, entries);
        return new ImmutableExtension(this.id, this.name, this.description, newValue, this.releases);
    }

    public final ImmutableExtension withReleases(Extension.ExtensionRelease ... elements) {
        NavigableSet<Extension.ExtensionRelease> newValue = ImmutableExtension.createUnmodifiableSortedSet(true, ImmutableExtension.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableExtension(this.id, this.name, this.description, this.metadata, newValue);
    }

    public final ImmutableExtension withReleases(Iterable<? extends Extension.ExtensionRelease> elements) {
        if (this.releases == elements) {
            return this;
        }
        NavigableSet<Extension.ExtensionRelease> newValue = ImmutableExtension.createUnmodifiableSortedSet(true, ImmutableExtension.createSafeList(elements, true, false));
        return new ImmutableExtension(this.id, this.name, this.description, this.metadata, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExtension && this.equalTo((ImmutableExtension)another);
    }

    private boolean equalTo(ImmutableExtension another) {
        return this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "Extension{id=" + this.id + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableExtension fromJson(Json json) {
        Builder builder = ImmutableExtension.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.metadata != null) {
            builder.putAllMetadata(json.metadata);
        }
        if (json.releases != null) {
            builder.addAllReleases(json.releases);
        }
        return builder.build();
    }

    public static ImmutableExtension copyOf(Extension instance) {
        if (instance instanceof ImmutableExtension) {
            return (ImmutableExtension)instance;
        }
        return ImmutableExtension.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T extends Comparable<T>> NavigableSet<T> createUnmodifiableSortedSet(boolean reverse, List<T> list) {
        TreeSet set = reverse ? new TreeSet(Collections.reverseOrder()) : new TreeSet();
        set.addAll(list);
        return Collections.unmodifiableNavigableSet(set);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        private ArtifactKey id;
        private String name;
        private String description;
        private Map<String, Object> metadata = new LinkedHashMap<String, Object>();
        private List<Extension.ExtensionRelease> releases = new ArrayList<Extension.ExtensionRelease>();

        private Builder() {
        }

        public final Builder from(ModifiableExtension instance) {
            String descriptionValue;
            Objects.requireNonNull(instance, "instance");
            if (instance.idIsSet()) {
                this.id(instance.getId());
            }
            if (instance.nameIsSet()) {
                this.name(instance.getName());
            }
            if ((descriptionValue = instance.getDescription()) != null) {
                this.description(descriptionValue);
            }
            this.putAllMetadata(instance.getMetadata());
            this.addAllReleases(instance.getReleases());
            return this;
        }

        public final Builder from(Extension instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance instanceof ModifiableExtension) {
                return this.from((ModifiableExtension)instance);
            }
            this.id(instance.getId());
            this.name(instance.getName());
            String descriptionValue = instance.getDescription();
            if (descriptionValue != null) {
                this.description(descriptionValue);
            }
            this.putAllMetadata(instance.getMetadata());
            this.addAllReleases(instance.getReleases());
            return this;
        }

        @JsonProperty(value="id")
        @JsonUnwrapped
        public final Builder id(ArtifactKey id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder putMetadata(String key, Object value) {
            this.metadata.put(Objects.requireNonNull(key, "metadata key"), Objects.requireNonNull(value, "metadata value"));
            return this;
        }

        public final Builder putMetadata(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.metadata.put(Objects.requireNonNull(k, "metadata key"), Objects.requireNonNull(v, "metadata value"));
            return this;
        }

        @JsonProperty(value="metadata")
        public final Builder metadata(Map<String, ? extends Object> entries) {
            this.metadata.clear();
            return this.putAllMetadata(entries);
        }

        public final Builder putAllMetadata(Map<String, ? extends Object> entries) {
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.metadata.put(Objects.requireNonNull(k, "metadata key"), Objects.requireNonNull(v, "metadata value"));
            }
            return this;
        }

        public final Builder addReleases(Extension.ExtensionRelease element) {
            this.releases.add(Objects.requireNonNull(element, "releases element"));
            return this;
        }

        public final Builder addReleases(Extension.ExtensionRelease ... elements) {
            for (Extension.ExtensionRelease element : elements) {
                this.releases.add(Objects.requireNonNull(element, "releases element"));
            }
            return this;
        }

        @JsonProperty(value="releases")
        public final Builder releases(Iterable<? extends Extension.ExtensionRelease> elements) {
            this.releases.clear();
            return this.addAllReleases(elements);
        }

        public final Builder addAllReleases(Iterable<? extends Extension.ExtensionRelease> elements) {
            for (Extension.ExtensionRelease extensionRelease : elements) {
                this.releases.add(Objects.requireNonNull(extensionRelease, "releases element"));
            }
            return this;
        }

        public ImmutableExtension build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExtension(this.id, this.name, this.description, ImmutableExtension.createUnmodifiableMap(false, false, this.metadata), ImmutableExtension.createUnmodifiableSortedSet(true, ImmutableExtension.createSafeList(this.releases, false, false)));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Extension, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements Extension {
        ArtifactKey id;
        String name;
        String description;
        Map<String, Object> metadata = Collections.emptyMap();
        SortedSet<Extension.ExtensionRelease> releases = ImmutableExtension.access$000(true, Collections.emptyList());

        Json() {
        }

        @JsonProperty(value="id")
        @JsonUnwrapped
        public void setId(ArtifactKey id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="description")
        public void setDescription(@Nullable String description) {
            this.description = description;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(Map<String, Object> metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="releases")
        public void setReleases(SortedSet<Extension.ExtensionRelease> releases) {
            this.releases = releases;
        }

        @Override
        public ArtifactKey getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedSet<Extension.ExtensionRelease> getReleases() {
            throw new UnsupportedOperationException();
        }
    }
}

