/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.builder;

import io.quarkus.dependencies.Extension;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.registry.DefaultExtensionRegistry;
import io.quarkus.registry.ExtensionRegistry;
import io.quarkus.registry.builder.RegistryBuilder;
import io.quarkus.registry.catalog.model.ImmutableExtension;
import io.quarkus.registry.catalog.model.ImmutablePlatform;
import io.quarkus.registry.catalog.model.Platform;
import io.quarkus.registry.catalog.spi.ArtifactResolver;
import io.quarkus.registry.model.ImmutableRelease;
import io.quarkus.registry.model.Registry;
import io.quarkus.registry.model.Release;
import java.io.IOException;

public class ExtensionRegistryBuilder {
    private final ArtifactResolver artifactResolver;
    private final RegistryBuilder registryBuilder = new RegistryBuilder();

    public ExtensionRegistryBuilder(ArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }

    public ExtensionRegistryBuilder addPlatform(String groupId, String artifactId, String version) throws IOException {
        ImmutablePlatform platform = Platform.builder().groupId(groupId).artifactId(artifactId).build();
        ImmutableRelease release = Release.builder().version(version).build();
        QuarkusPlatformDescriptor descriptor = this.artifactResolver.resolvePlatform(platform, release);
        this.registryBuilder.visitPlatform(descriptor);
        return this;
    }

    public ExtensionRegistryBuilder addExtension(String groupId, String artifactId, String version, String quarkusCore) throws IOException {
        ImmutableExtension extension = io.quarkus.registry.catalog.model.Extension.builder().groupId(groupId).artifactId(artifactId).build();
        ImmutableRelease release = Release.builder().version(version).build();
        Extension ext = this.artifactResolver.resolveExtension(extension, release);
        this.registryBuilder.visitExtension(ext, quarkusCore);
        return this;
    }

    public ExtensionRegistry build() {
        Registry registry = this.registryBuilder.build();
        return new DefaultExtensionRegistry(registry);
    }
}

