/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.dependencies.Extension;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.SelectionResult;
import io.quarkus.devtools.project.extensions.Extensions;
import io.quarkus.platform.tools.ConsoleMessageFormats;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

final class QuarkusCommandHandlers {
    private QuarkusCommandHandlers() {
    }

    static List<AppArtifactCoords> computeCoordsFromQuery(QuarkusCommandInvocation invocation, Set<String> extensionsQuery) {
        ArrayList<AppArtifactCoords> builder = new ArrayList<AppArtifactCoords>();
        for (String query : extensionsQuery) {
            int countColons = StringUtils.countMatches((CharSequence)query, (CharSequence)":");
            if (countColons == 1) {
                builder.add(Extensions.toCoords(AppArtifactKey.fromString((String)query), null));
                continue;
            }
            if (countColons > 1) {
                builder.add(AppArtifactCoords.fromString((String)query));
                continue;
            }
            SelectionResult result = QuarkusCommandHandlers.select(query, invocation.getPlatformDescriptor().getExtensions(), false);
            if (result.matches()) {
                Set withStrippedVersion = result.getExtensions().stream().map(Extensions::toCoords).map(Extensions::stripVersion).collect(Collectors.toSet());
                builder.addAll(withStrippedVersion);
                continue;
            }
            StringBuilder sb = new StringBuilder();
            Set<Extension> candidates = result.getExtensions();
            if (candidates.isEmpty()) {
                invocation.log().info(ConsoleMessageFormats.nok((String)("Cannot find a dependency matching '" + query + "', maybe a typo?")));
                return null;
            }
            sb.append(ConsoleMessageFormats.nok((String)"Multiple extensions matching '")).append(query).append("'");
            result.getExtensions().forEach(extension -> sb.append(System.lineSeparator()).append("     * ").append(extension.managementKey()));
            sb.append(System.lineSeparator()).append("     Be more specific e.g using the exact name or the full GAV.");
            invocation.log().info(sb.toString());
            return null;
        }
        return builder;
    }

    static SelectionResult select(String query, List<Extension> allPlatformExtensions, boolean labelLookup) {
        String q = query.trim().toLowerCase();
        Set<Extension> matchesNameOrArtifactId = allPlatformExtensions.stream().filter(extension -> extension.getName().equalsIgnoreCase(q) || QuarkusCommandHandlers.matchesArtifactId(extension.getArtifactId(), q)).collect(Collectors.toSet());
        if (matchesNameOrArtifactId.size() == 1) {
            return new SelectionResult(matchesNameOrArtifactId, true);
        }
        List listedPlatformExtensions = allPlatformExtensions.stream().filter(e -> !e.isUnlisted()).collect(Collectors.toList());
        Set<Extension> matchesShortName = listedPlatformExtensions.stream().filter(extension -> QuarkusCommandHandlers.matchesShortName(extension, q)).collect(Collectors.toSet());
        if (matchesShortName.size() == 1 && matchesNameOrArtifactId.isEmpty()) {
            return new SelectionResult(matchesShortName, true);
        }
        Set<Extension> partialMatches = listedPlatformExtensions.stream().filter(extension -> extension.getName().toLowerCase().contains(q) || extension.getArtifactId().toLowerCase().contains(q) || extension.getShortName().toLowerCase().contains(q)).collect(Collectors.toSet());
        if (partialMatches.size() == 1 && matchesNameOrArtifactId.isEmpty() && matchesShortName.isEmpty()) {
            return new SelectionResult(partialMatches, true);
        }
        List matchesLabels = labelLookup ? listedPlatformExtensions.stream().filter(extension -> extension.labelsForMatching().contains(q)).collect(Collectors.toList()) : Collections.emptyList();
        Pattern pattern = QuarkusCommandHandlers.toRegex(q);
        if (pattern != null) {
            Set<Extension> matchesPatterns = listedPlatformExtensions.stream().filter(extension -> pattern.matcher(extension.getName().toLowerCase()).matches() || pattern.matcher(extension.getArtifactId().toLowerCase()).matches() || pattern.matcher(extension.getShortName().toLowerCase()).matches() || QuarkusCommandHandlers.matchLabels(pattern, extension.getKeywords())).collect(Collectors.toSet());
            return new SelectionResult(matchesPatterns, true);
        }
        Set matchesPatterns = Collections.emptySet();
        LinkedHashSet<Extension> candidates = new LinkedHashSet<Extension>();
        candidates.addAll(matchesNameOrArtifactId);
        candidates.addAll(matchesShortName);
        candidates.addAll(partialMatches);
        candidates.addAll(matchesLabels);
        candidates.addAll(matchesPatterns);
        return new SelectionResult(candidates, false);
    }

    private static boolean matchLabels(Pattern pattern, List<String> labels) {
        boolean matches = false;
        for (String label : labels) {
            matches = matches || pattern.matcher(label.toLowerCase()).matches();
        }
        return matches;
    }

    private static Pattern toRegex(String str) {
        try {
            String wildcardToRegex = QuarkusCommandHandlers.wildcardToRegex(str);
            if (wildcardToRegex != null && !wildcardToRegex.isEmpty()) {
                return Pattern.compile(wildcardToRegex);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return null;
    }

    private static String wildcardToRegex(String wildcard) {
        if (wildcard == null || wildcard.isEmpty()) {
            return null;
        }
        if (!wildcard.contains("*") && !wildcard.contains("?")) {
            return null;
        }
        StringBuffer s = new StringBuffer(wildcard.length());
        s.append("^.*");
        int is = wildcard.length();
        block6: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block6;
                }
                case '?': {
                    s.append(".");
                    continue block6;
                }
                case '^': {
                    s.append("\\");
                    continue block6;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    continue block6;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append(".*$");
        return s.toString();
    }

    private static boolean matchesShortName(Extension extension, String q) {
        return q.equalsIgnoreCase(extension.getShortName());
    }

    private static boolean matchesArtifactId(String artifactId, String q) {
        return artifactId.equalsIgnoreCase(q) || artifactId.equalsIgnoreCase("quarkus-" + q);
    }
}

