/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands.file;

import io.quarkus.cli.commands.Printer;
import io.quarkus.cli.commands.writer.ProjectWriter;
import io.quarkus.dependencies.Extension;
import io.quarkus.generators.BuildTool;
import io.quarkus.maven.utilities.MojoUtils;
import io.quarkus.maven.utilities.QuarkusDependencyPredicate;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;

public abstract class BuildFile
implements Closeable {
    protected static final Printer PRINTER = new Printer();
    private final ProjectWriter writer;
    private final BuildTool buildTool;

    public BuildFile(ProjectWriter writer, BuildTool buildTool) {
        this.writer = writer;
        this.buildTool = buildTool;
    }

    protected void write(String fileName, String content) throws IOException {
        this.writer.write(fileName, content);
    }

    public boolean addDependency(QuarkusPlatformDescriptor platform, Extension extension) throws IOException {
        if (!this.hasDependency(extension)) {
            Dependency dep;
            PRINTER.ok(" Adding extension " + extension.managementKey());
            if (this.containsBOM(platform.getBomGroupId(), platform.getBomArtifactId()) && this.isDefinedInBom(platform.getManagedDependencies(), extension)) {
                dep = extension.toDependency(true);
            } else {
                dep = extension.toDependency(false);
                if (this.getProperty("quarkus.version") != null) {
                    dep.setVersion(MojoUtils.TEMPLATE_PROPERTY_QUARKUS_VERSION_VALUE);
                }
            }
            this.addDependencyInBuildFile(dep);
            return true;
        }
        PRINTER.noop(" Skipping already present extension " + extension.managementKey());
        return false;
    }

    protected abstract void addDependencyInBuildFile(Dependency var1) throws IOException;

    protected abstract boolean hasDependency(Extension var1) throws IOException;

    public boolean addExtensionAsGAV(String query) throws IOException {
        Dependency parsed = MojoUtils.parse(query.trim().toLowerCase());
        boolean alreadyThere = this.getDependencies().stream().anyMatch(d -> d.getManagementKey().equalsIgnoreCase(parsed.getManagementKey()));
        if (!alreadyThere) {
            PRINTER.ok(" Adding dependency " + parsed.getManagementKey());
            this.addDependencyInBuildFile(parsed);
            return true;
        }
        PRINTER.noop(" Skipping already present dependency " + parsed.getManagementKey());
        return false;
    }

    protected boolean isDefinedInBom(List<Dependency> dependencies, Extension extension) {
        return dependencies.stream().anyMatch(dependency -> dependency.getGroupId().equalsIgnoreCase(extension.getGroupId()) && dependency.getArtifactId().equalsIgnoreCase(extension.getArtifactId()));
    }

    protected abstract boolean containsBOM(String var1, String var2) throws IOException;

    public abstract List<Dependency> getDependencies() throws IOException;

    public Map<String, Dependency> findInstalled() throws IOException {
        return this.mapDependencies(this.getDependencies(), this.loadManaged());
    }

    private Map<String, Dependency> loadManaged() throws IOException {
        List<Dependency> managedDependencies = this.getManagedDependencies();
        return managedDependencies.isEmpty() ? Collections.emptyMap() : this.mapDependencies(managedDependencies, Collections.emptyMap());
    }

    protected Map<String, Dependency> mapDependencies(List<Dependency> dependencies, Map<String, Dependency> managed) {
        TreeMap<String, Dependency> map = new TreeMap<String, Dependency>();
        if (dependencies != null) {
            List<Dependency> listed = dependencies.stream().filter(new QuarkusDependencyPredicate()).collect(Collectors.toList());
            listed.forEach(d -> {
                String version;
                Dependency managedDep;
                if (d.getVersion() == null && (managedDep = (Dependency)managed.get(MojoUtils.credentials(d))) != null && (version = managedDep.getVersion()) != null) {
                    d.setVersion(version);
                }
                map.put(MojoUtils.credentials(d), (Dependency)d);
            });
        }
        return map;
    }

    public abstract String getProperty(String var1) throws IOException;

    protected abstract List<Dependency> getManagedDependencies() throws IOException;

    public abstract void completeFile(String var1, String var2, String var3, QuarkusPlatformDescriptor var4, Properties var5) throws IOException;

    public BuildTool getBuildTool() {
        return this.buildTool;
    }

    protected ProjectWriter getWriter() {
        return this.writer;
    }
}

